/*
 * Decompiled with CFR 0.152.
 */
package com.shfarr.patterns;

import java.util.Stack;

public class Cache {
    protected Stack cache = null;
    protected int capacity;

    public Cache(int capacity) {
        this.capacity = capacity;
        this.cache = new Stack();
    }

    public synchronized void clear() {
        if (this.cache != null) {
            this.cache.clear();
        }
    }

    public synchronized Object locate(Object name) {
        Product product = null;
        int i = 0;
        while (i < this.cache.size()) {
            if (((Product)this.cache.get(i)).getName().equals(name)) {
                product = (Product)this.cache.remove(i);
                this.cache.push(product);
                break;
            }
            ++i;
        }
        return product == null ? null : product.getLoad();
    }

    public synchronized void cache(Object element, Object name) {
        if (this.capacity - this.cache.size() < 1) {
            this.cache.remove(this.cache.firstElement());
        }
        this.cache.push(new Product(name, element));
    }

    public int getCapacity() {
        return this.capacity;
    }

    public void setCapacity(int capacity) {
        this.capacity = capacity;
    }

    protected class Product {
        private Object name = null;
        private Object load = null;

        public Product(Object name, Object load) {
            this.name = name;
            this.load = load;
        }

        public Object getName() {
            return this.name;
        }

        public Object getLoad() {
            return this.load;
        }

        public boolean equals(Object o) {
            return o instanceof Product && ((Product)o).name.equals(this.name);
        }
    }
}

