/*
 * Decompiled with CFR 0.152.
 */
package com.shfarr.ui;

import java.awt.Component;
import java.awt.Font;
import java.net.URL;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;

public abstract class CustomTreeCellRenderer
extends DefaultTreeCellRenderer {
    protected Vector bufferNames = null;
    protected Vector imageBuffer = null;

    public CustomTreeCellRenderer() {
        this.setFont((Font)UIManager.getDefaults().get("Tree.font"));
        this.setVerticalAlignment(0);
        this.setVerticalTextPosition(0);
        this.imageBuffer = new Vector();
        this.bufferNames = new Vector();
    }

    public abstract ImageIcon getOpenIconFor(DefaultMutableTreeNode var1);

    public abstract ImageIcon getClosedIconFor(DefaultMutableTreeNode var1);

    public abstract ImageIcon getLeafIconFor(DefaultMutableTreeNode var1);

    protected boolean isPairCached(String url) {
        return this.bufferNames.indexOf(url) != -1;
    }

    protected void cachePair(String url, ImageIcon icon) {
        this.bufferNames.add(url);
        this.imageBuffer.add(icon);
    }

    protected ImageIcon getIconFromBuffer(String url) {
        int index = this.bufferNames.indexOf(url);
        ImageIcon icon = null;
        if (index == -1) {
            URL rurl = ClassLoader.getSystemResource("cres/" + url);
            if (rurl != null) {
                icon = new ImageIcon(rurl);
            }
        } else {
            icon = (ImageIcon)this.imageBuffer.elementAt(index);
        }
        return icon;
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        if (value != null) {
            int type = -1;
            this.setOpenIcon(this.getOpenIconFor((DefaultMutableTreeNode)value));
            this.setClosedIcon(this.getClosedIconFor((DefaultMutableTreeNode)value));
            this.setLeafIcon(this.getLeafIconFor((DefaultMutableTreeNode)value));
        }
        Component cmp = super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
        return cmp;
    }

    public void setText(String text) {
        super.setText(" " + text);
    }
}

