/*
 * Decompiled with CFR 0.152.
 */
package com.shfarr.ui;

import com.shfarr.ui.FhSysButton;
import com.shfarr.ui.FhSysIcon;
import com.shfarr.ui.layouts.QueueLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JTextField;
import javax.swing.text.Document;

public class FhActiveTextField
extends JTextField {
    private FhSysButton more = null;
    private boolean interactionEnabled = true;

    public FhActiveTextField() {
        this.initialize();
    }

    public FhActiveTextField(int columns) {
        super(columns);
        this.initialize();
    }

    public FhActiveTextField(String text) {
        super(text);
        this.initialize();
    }

    public FhActiveTextField(String text, int columns) {
        super(text, columns);
        this.initialize();
    }

    public FhActiveTextField(Document doc, String text, int columns) {
        super(doc, text, columns);
        this.initialize();
    }

    public void setDocument(Document doc) {
        super.setDocument(doc);
        this.initialize();
    }

    private void initialize() {
        if (this.more == null) {
            AllPurposeMouseAdapter apma = new AllPurposeMouseAdapter();
            this.more = new FhSysButton(200);
            this.more.setIcon(new FhSysIcon(200));
            this.more.setPreferredSize(new Dimension(this.more.getPreferredSize().width, 16));
            this.more.setCursor(Cursor.getPredefinedCursor(0));
            this.more.setVisible(false);
            this.addMouseMotionListener(apma);
            this.addMouseListener(apma);
            this.more.addMouseListener(apma);
        }
        this.setLayout(new QueueLayout(4, 100, 2));
        this.add((Component)this.more, QueueLayout.END);
    }

    protected void processKeyEvent(KeyEvent ke) {
        this.setInteractorShown(ke.isControlDown());
        super.processKeyEvent(ke);
    }

    public void setInteractionEnabled(boolean val) {
        this.interactionEnabled = val;
    }

    public boolean isInteractionEnabled() {
        return this.interactionEnabled;
    }

    public void addActionListener(ActionListener al) {
        this.more.addActionListener(al);
    }

    public void removeActionListener(ActionListener al) {
        this.more.removeActionListener(al);
    }

    protected void setInteractorShown(boolean val) {
        this.more.setVisible(val);
        this.revalidate();
    }

    private class AllPurposeMouseAdapter
    implements MouseMotionListener,
    MouseListener {
        AllPurposeMouseAdapter() {
        }

        public void mouseDragged(MouseEvent e) {
            if (!((Component)e.getSource()).isEnabled()) {
                return;
            }
            FhActiveTextField.this.setInteractorShown(true);
        }

        public void mouseMoved(MouseEvent e) {
            if (!((Component)e.getSource()).isEnabled()) {
                return;
            }
            FhActiveTextField.this.setInteractorShown(true);
        }

        public void mouseClicked(MouseEvent e) {
            if (!((Component)e.getSource()).isEnabled()) {
                return;
            }
            FhActiveTextField.this.setInteractorShown(e.getSource() != FhActiveTextField.this);
        }

        public void mouseEntered(MouseEvent e) {
            if (!((Component)e.getSource()).isEnabled()) {
                return;
            }
            FhActiveTextField.this.setInteractorShown(true);
        }

        public void mouseExited(MouseEvent e) {
            if (!((Component)e.getSource()).isEnabled()) {
                return;
            }
            FhActiveTextField.this.setInteractorShown(false);
        }

        public void mousePressed(MouseEvent e) {
            if (!((Component)e.getSource()).isEnabled()) {
                return;
            }
            FhActiveTextField.this.setInteractorShown(e.getSource() != FhActiveTextField.this);
            FhActiveTextField.this.grabFocus();
        }

        public void mouseReleased(MouseEvent e) {
            if (!((Component)e.getSource()).isEnabled()) {
                return;
            }
            FhActiveTextField.this.setInteractorShown(e.getSource() != FhActiveTextField.this);
        }
    }
}

