/*
 * Decompiled with CFR 0.152.
 */
package com.shfarr.ui;

import com.shfarr.ui.GraphicsUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.UIManager;

public class FhSysButton
extends JButton {
    public static final int UNSPECIFIED = -99999;
    public static final int SIMPLE_ARROW_NORTH = -1;
    public static final int SIMPLE_ARROW_EAST = -2;
    public static final int SIMPLE_ARROW_SOUTH = -3;
    public static final int SIMPLE_ARROW_WEST = -4;
    public static final int ARROW_NORTH = 1;
    public static final int ARROW_EAST = 2;
    public static final int ARROW_SOUTH = 3;
    public static final int ARROW_WEST = 4;
    public static final int MINIMIZER = 105;
    public static final int CLOSER = 106;
    public static final int RESTORER = 107;
    public static final int MAXIMIZER = 108;
    protected int type = 1;
    protected int extraInset = 2;

    public FhSysButton(int type) {
        this(type, 0);
    }

    public FhSysButton(int type, int extraInset) {
        this.type = type;
        this.extraInset = extraInset;
        this.setMargins(null);
        this.setRolloverEnabled(true);
    }

    protected static int[][] getArrowMatrix(int width, int height, int type, int color) {
        if (height <= 0 || width <= 0) {
            return new int[][]{{color}};
        }
        if (type > 0 && (width < 5 || height < 5)) {
            type = -type;
        }
        if (type % 2 == 0) {
            int t = width;
            width = height;
            height = t;
        }
        int[][] data = new int[height][width];
        if (type > 0) {
            int hMax = Math.min(data.length, data[0].length);
            int i = 0;
            while (i < hMax) {
                int k = 0;
                while (k <= data[0].length / 2) {
                    if (i < hMax - hMax / 2) {
                        data[i + (data.length - hMax) / 2][k] = (k < data[0].length - data[0].length / 2 - i - 1 ? 0xFFFFFF : -1) & color;
                        data[i + (data.length - hMax) / 2][data[0].length - k - 1] = (k < data[0].length - data[0].length / 2 - i - 1 ? 0xFFFFFF : -1) & color;
                    } else {
                        data[i + (data.length - hMax) / 2][k] = (k <= hMax / 4 + (data[0].length - hMax) / 2 ? 0xFFFFFF : -1) & color;
                        data[i + (data.length - hMax) / 2][data[0].length - k - 1] = (k <= hMax / 4 + (data[0].length - hMax) / 2 ? 0xFFFFFF : -1) & color;
                    }
                    ++k;
                }
                ++i;
            }
        } else {
            int hMax = Math.min(data.length, data[0].length - data[0].length / 2);
            int i = 0;
            while (i < hMax) {
                int k = 0;
                while (k <= data[0].length / 2) {
                    data[i + (data.length - hMax) / 2][k] = (k < data[0].length - data[0].length / 2 - i - 1 ? 0xFFFFFF : -1) & color;
                    data[i + (data.length - hMax) / 2][data[0].length - k - 1] = (k < data[0].length - data[0].length / 2 - i - 1 ? 0xFFFFFF : -1) & color;
                    ++k;
                }
                ++i;
            }
        }
        return data;
    }

    protected int getExtraInset() {
        return this.extraInset;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
        this.repaint();
    }

    public String getUIClassID() {
        return "SysButtonUI";
    }

    public boolean isDefaultButton() {
        return false;
    }

    public boolean isDefaultCapable() {
        return false;
    }

    public boolean isFocusPainted() {
        return false;
    }

    public boolean isFocusTraversable() {
        return false;
    }

    public void paint(Graphics g) {
        super.paint(g);
        if (this.type == -99999) {
            return;
        }
        if (Math.abs(this.type) < 100) {
            FhSysButton.paintCenteredArrow(this, g, this.getType(), this.getExtraInset(), null, this.getForeground());
        }
    }

    public static void paintArrow(Component c, Graphics g, int orientation, Rectangle r, Color highlight, Color foreground) {
        if (highlight == null) {
            highlight = UIManager.getDefaults().getColor("Component.absoluteHighlight");
        }
        if (foreground == null) {
            foreground = UIManager.getDefaults().getColor("Component.foreground");
        }
        int rotation = 0;
        switch (orientation) {
            case 1: {
                break;
            }
            case 2: {
                rotation = 1;
                break;
            }
            case 3: {
                rotation = 2;
                break;
            }
            case 4: {
                rotation = 3;
                break;
            }
            case -1: {
                break;
            }
            case -2: {
                rotation = 1;
                break;
            }
            case -3: {
                rotation = 2;
                break;
            }
            case -4: {
                rotation = 3;
            }
        }
        g.drawImage(GraphicsUtils.createTextureImage(FhSysButton.getArrowMatrix(r.width, r.height, orientation, highlight.getRGB()), rotation), r.x + 1, r.y + 1, null);
        g.drawImage(GraphicsUtils.createTextureImage(FhSysButton.getArrowMatrix(r.width, r.height, orientation, foreground.getRGB()), rotation), r.x, r.y, null);
    }

    public static void paintCenteredArrow(Component c, Graphics g, int orientation, int extraInset, Color highlight, Color foreground) {
        int w = c.getSize().width;
        int h = c.getSize().height;
        int x = 0;
        int y = 0;
        if (c instanceof JComponent && ((JComponent)c).getBorder() != null) {
            w -= ((JComponent)c).getBorder().getBorderInsets((Component)c).left + ((JComponent)c).getBorder().getBorderInsets((Component)c).right;
            h -= ((JComponent)c).getBorder().getBorderInsets((Component)c).top + ((JComponent)c).getBorder().getBorderInsets((Component)c).bottom;
            x += ((JComponent)c).getBorder().getBorderInsets((Component)c).left;
            y += ((JComponent)c).getBorder().getBorderInsets((Component)c).top;
        }
        FhSysButton.paintArrow(c, g, orientation, new Rectangle(x + extraInset, y + extraInset, w - 2 * extraInset, h - 2 * extraInset), highlight, foreground);
    }

    public void setMargins(Insets ins) {
        super.setMargin(new Insets(0, 0, 0, 0));
    }

    public void setExtraInset(int extraInset) {
        this.extraInset = extraInset;
        this.repaint();
    }
}

