/*
 * Decompiled with CFR 0.152.
 */
package com.shfarr.ui;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.FilteredImageSource;
import java.awt.image.RGBImageFilter;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.UIManager;

public class GraphicsUtils {
    public static final int ROTATE_0 = 0;
    public static final int ROTATE_90 = 1;
    public static final int ROTATE_180 = 2;
    public static final int ROTATE_270 = 3;

    public static BufferedImage createTextureImage(int[][] matrix, int rotation) {
        if (((int[][])(matrix = GraphicsUtils.rotateClockwise(matrix, rotation))).length == 0 || matrix[0].length == 0) {
            matrix = new int[][]{new int[1]};
        }
        BufferedImage image = new BufferedImage(matrix[0].length, ((int[][])matrix).length, 2);
        int i = 0;
        while (i < ((int[][])matrix).length) {
            image.setRGB(0, i, matrix[0].length, 1, matrix[i], 0, matrix[i].length);
            ++i;
        }
        return image;
    }

    public static Icon createColorIcon(Color c, int width, int height) {
        BufferedImage img = new BufferedImage(width, height, 2);
        Graphics2D g = img.createGraphics();
        g.setColor(Color.white);
        g.fillRect(0, 0, width, height);
        g.setColor(Color.gray);
        g.drawRect(0, 0, width - 1, height - 1);
        GraphicsUtils.paintTiledBackground(g, new Rectangle(3, 2, width - 6, height - 4), 5);
        g.drawImage((Image)GraphicsUtils.createColorImage(c, width - 6, height - 4), 3, 2, null);
        return new ImageIcon(img);
    }

    public static BufferedImage createColorImage(Color c, int width, int height) {
        BufferedImage image = new BufferedImage(width, height, 2);
        int ci = c != null ? c.getRGB() : 0xFFFFFF;
        int i = 0;
        while (i < width) {
            int k = 0;
            while (k < height) {
                image.setRGB(i, k, ci);
                ++k;
            }
            ++i;
        }
        return image;
    }

    public static ImageIcon applyFilter(ImageIcon ic, RGBImageFilter filter) {
        Image img = ic.getImage();
        FilteredImageSource prod = new FilteredImageSource(img.getSource(), filter);
        Image grayImage = Toolkit.getDefaultToolkit().createImage(prod);
        return new ImageIcon(grayImage);
    }

    public static Image applyFilter(BufferedImage img, RGBImageFilter filter) {
        FilteredImageSource prod = new FilteredImageSource(img.getSource(), filter);
        Image grayImage = Toolkit.getDefaultToolkit().createImage(prod);
        return grayImage;
    }

    public static BufferedImage createFilteredString(JComponent jc, Rectangle2D size, String string, boolean vertical) {
        BufferedImage dest = new BufferedImage((int)size.getWidth(), (int)size.getHeight(), 2);
        int[] empty = new int[dest.getWidth() * dest.getHeight()];
        int i = 0;
        while (i < empty.length) {
            empty[i] = jc.getForeground().getRGB() & 0xFFFFFF;
            ++i;
        }
        dest.setRGB(0, 0, dest.getWidth(), dest.getHeight(), empty, 0, dest.getWidth());
        Graphics2D g = dest.createGraphics();
        g.setFont(jc.getFont());
        int fontY = g.getFontMetrics().getAscent();
        g.setColor(jc.getForeground());
        Vector<String> lines = new Vector<String>();
        StringTokenizer st = new StringTokenizer(string, "\r\n", false);
        while (st.hasMoreTokens()) {
            lines.addElement(st.nextToken().trim());
        }
        int k = 0;
        while (k < lines.size()) {
            int fontX = (dest.getWidth() - (int)g.getFontMetrics().getStringBounds(lines.elementAt(k).toString(), g).getWidth()) / 2;
            g.drawString(lines.elementAt(k).toString(), fontX, fontY + k * jc.getFont().getSize());
            ++k;
        }
        return vertical ? GraphicsUtils.rotate90(dest, 1) : dest;
    }

    public static int alpha(int color, double amount) {
        return 0xFFFFFF & color | 0xFF000000 & (int)((double)(color >> 24 & 0xFF) * amount) << 24;
    }

    public static int brighter(int color, double factor) {
        return GraphicsUtils.channel(color, factor, factor, factor);
    }

    public static int darker(int color, double factor) {
        return GraphicsUtils.channel(color, -factor, -factor, -factor);
    }

    public static int desaturate(int color, double amount) {
        amount = 1.0 - amount;
        int a = color >> 24 & 0xFF;
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        double gray = 1.4488 * (double)r + 1.25 * (double)g + 0.55 * (double)b;
        if ((gray *= (double)0.307971f) < 0.0) {
            gray = 0.0;
        }
        if (gray > 255.0) {
            gray = 255.0;
        }
        r = (int)((double)r > gray ? gray + ((double)r - gray) * amount : gray - (gray - (double)r) * amount);
        g = (int)((double)g > gray ? gray + ((double)g - gray) * amount : gray - (gray - (double)g) * amount);
        b = (int)((double)b > gray ? gray + ((double)b - gray) * amount : gray - (gray - (double)b) * amount);
        return a << 24 | r << 16 | g << 8 | b << 0;
    }

    public static int blend(int color, int base, double opacity) {
        int ca = color >> 24 & 0xFF;
        int cr = color >> 16 & 0xFF;
        int cg = color >> 8 & 0xFF;
        int cb = color & 0xFF;
        int ba = base >> 24 & 0xFF;
        int br = base >> 16 & 0xFF;
        int bg = base >> 8 & 0xFF;
        int bb = base & 0xFF;
        return Math.max(0, ba + (int)((double)(ca - ba) * opacity)) << 24 | Math.max(0, br + (int)((double)(cr - br) * opacity)) << 16 | Math.max(0, bg + (int)((double)(cg - bg) * opacity)) << 8 | Math.max(0, bb + (int)((double)(cb - bb) * opacity));
    }

    public static int channel(int color, double rFactor, double gFactor, double bFactor) {
        int a = color >> 24 & 0xFF;
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color >> 0 & 0xFF;
        if (rFactor > 0.0) {
            r = (int)((double)r + Math.min(255.0 * rFactor, (double)(255 - r)));
        } else if (rFactor < 0.0) {
            r = (int)((double)r - Math.min(-255.0 * rFactor, (double)r));
        }
        if (gFactor > 0.0) {
            g = (int)((double)g + Math.min(255.0 * gFactor, (double)(255 - g)));
        } else if (gFactor < 0.0) {
            g = (int)((double)g - Math.min(-255.0 * gFactor, (double)g));
        }
        if (bFactor > 0.0) {
            b = (int)((double)b + Math.min(255.0 * bFactor, (double)(255 - b)));
        } else if (bFactor < 0.0) {
            b = (int)((double)b - Math.min(-255.0 * bFactor, (double)b));
        }
        return a << 24 | r << 16 | g << 8 | b << 0;
    }

    public static void drawDashedLine(double xs, double ys, double xe, double ye, boolean[] sequence, Graphics g) {
        double decay = 0.0;
        decay = xe - xs == 0.0 ? 1.5707963267948966 * (double)(ye - ys < 0.0 ? 3 : 1) : (ye - ys == 0.0 ? (xe - xs < 0.0 ? Math.PI : 0.0) : Math.atan((ye - ys) / (xe - xs)));
        double length = Math.sqrt((ye - ys) * (ye - ys) + (xe - xs) * (xe - xs));
        double xDecay = Math.cos(decay);
        double yDecay = Math.sin(decay);
        int i = 0;
        while (i < (int)length) {
            if (sequence[i % sequence.length]) {
                g.drawLine((int)(xs + (double)i * xDecay), (int)(ys + (double)i * yDecay), (int)(xs + (double)i * xDecay), (int)(ys + (double)i * yDecay));
            }
            ++i;
        }
    }

    public static boolean isAntialiasingEnabled() {
        return UIManager.getDefaults().get("Text.antialias") != null && UIManager.getDefaults().get("Text.antialias").toString().equals("true");
    }

    public static BufferedImage rotate90(BufferedImage src, int times) {
        int w = src.getWidth();
        int h = src.getHeight();
        BufferedImage dest = new BufferedImage(times % 2 == 0 ? w : h, times % 2 == 0 ? h : w, 2);
        switch (times) {
            case 1: {
                int i = 0;
                while (i < w) {
                    int j = 0;
                    while (j < h) {
                        dest.setRGB(j, w - i - 1, src.getRGB(i, j));
                        ++j;
                    }
                    ++i;
                }
                break;
            }
            case 2: {
                int i = 0;
                while (i < w) {
                    int j = 0;
                    while (j < h) {
                        dest.setRGB(h - i - 1, w - j - 1, src.getRGB(i, j));
                        ++j;
                    }
                    ++i;
                }
                break;
            }
            case 3: {
                int i = 0;
                while (i < w) {
                    int j = 0;
                    while (j < h) {
                        dest.setRGB(h - j - 1, i, src.getRGB(i, j));
                        ++j;
                    }
                    ++i;
                }
                break;
            }
            default: {
                dest = src;
            }
        }
        return dest;
    }

    public static int[][] rotateClockwise(int[][] matrix, int rotation) {
        int[][] newMatrix;
        block10: {
            block12: {
                block11: {
                    block9: {
                        if (matrix.length == 0 || matrix[0].length == 0) {
                            return matrix;
                        }
                        newMatrix = new int[rotation % 2 == 0 ? matrix.length : matrix[0].length][rotation % 2 == 0 ? matrix[0].length : matrix.length];
                        if (rotation != 0) break block9;
                        int i = 0;
                        while (i < matrix.length) {
                            int k = 0;
                            while (k < matrix[0].length) {
                                newMatrix[i][k] = matrix[i][k];
                                ++k;
                            }
                            ++i;
                        }
                        break block10;
                    }
                    if (rotation != 1) break block11;
                    int i = 0;
                    while (i < matrix.length) {
                        int k = 0;
                        while (k < matrix[0].length) {
                            newMatrix[k][newMatrix[0].length - 1 - i] = matrix[i][k];
                            ++k;
                        }
                        ++i;
                    }
                    break block10;
                }
                if (rotation != 2) break block12;
                int i = 0;
                while (i < matrix.length) {
                    int k = 0;
                    while (k < matrix[0].length) {
                        newMatrix[newMatrix.length - 1 - i][newMatrix[0].length - 1 - k] = matrix[i][k];
                        ++k;
                    }
                    ++i;
                }
                break block10;
            }
            if (rotation != 3) break block10;
            int i = 0;
            while (i < matrix.length) {
                int k = 0;
                while (k < matrix[0].length) {
                    newMatrix[newMatrix.length - 1 - k][i] = matrix[i][k];
                    ++k;
                }
                ++i;
            }
        }
        return newMatrix;
    }

    public static String[][] rotateClockwise(String[][] matrix, int rotation) {
        String[][] newMatrix;
        block10: {
            block12: {
                block11: {
                    block9: {
                        if (matrix.length == 0 || matrix[0].length == 0) {
                            return matrix;
                        }
                        newMatrix = new String[rotation % 2 == 0 ? matrix.length : matrix[0].length][rotation % 2 == 0 ? matrix[0].length : matrix.length];
                        if (rotation != 0) break block9;
                        int i = 0;
                        while (i < matrix.length) {
                            int k = 0;
                            while (k < matrix[0].length) {
                                newMatrix[i][k] = matrix[i][k];
                                ++k;
                            }
                            ++i;
                        }
                        break block10;
                    }
                    if (rotation != 1) break block11;
                    int i = 0;
                    while (i < matrix.length) {
                        int k = 0;
                        while (k < matrix[0].length) {
                            newMatrix[k][newMatrix[0].length - 1 - i] = matrix[i][k];
                            ++k;
                        }
                        ++i;
                    }
                    break block10;
                }
                if (rotation != 2) break block12;
                int i = 0;
                while (i < matrix.length) {
                    int k = 0;
                    while (k < matrix[0].length) {
                        newMatrix[newMatrix.length - 1 - i][newMatrix[0].length - 1 - k] = matrix[i][k];
                        ++k;
                    }
                    ++i;
                }
                break block10;
            }
            if (rotation != 3) break block10;
            int i = 0;
            while (i < matrix.length) {
                int k = 0;
                while (k < matrix[0].length) {
                    newMatrix[newMatrix.length - 1 - k][i] = matrix[i][k];
                    ++k;
                }
                ++i;
            }
        }
        return newMatrix;
    }

    public static void paintTiledBackground(Graphics g, Rectangle r, int step) {
        int[] xs = new int[4];
        int[] ys = new int[4];
        Color paleGreen = new Color(220, 255, 220);
        Rectangle cb = g.getClipBounds();
        g.setClip(r);
        int i = 0;
        while ((double)i < r.getWidth()) {
            int k = 0;
            while ((double)k < r.getHeight()) {
                xs[0] = r.x + i + step;
                xs[1] = r.x + i + 2 * step;
                xs[2] = r.x + i + step;
                xs[3] = r.x + i;
                ys[0] = r.y + k + 0;
                ys[1] = r.y + k + step;
                ys[2] = r.y + k + 2 * step;
                ys[3] = r.y + k + step;
                g.setColor(Color.white);
                g.fillRect(r.x + i, r.y + k, 2 * step, 2 * step);
                g.setColor(paleGreen);
                g.fillPolygon(xs, ys, 4);
                g.setColor(Color.darkGray);
                g.drawPolygon(xs, ys, 4);
                k += 2 * step;
            }
            i += 2 * step;
        }
        g.setClip(cb);
    }
}

