/*
 * Decompiled with CFR 0.152.
 */
package com.shfarr.ui;

import com.shfarr.BasicUtils;
import com.shfarr.DevUtils;
import com.shfarr.beans.BeanUtils;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSeparator;
import javax.swing.JToggleButton;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class UIUtils {
    public static JComponent createButton(String action, ActionListener al) {
        if (action.equals("--")) {
            JSeparator separator = new JSeparator(1);
            return separator;
        }
        AbstractButton button = action.indexOf("|") != -1 ? new JToggleButton(action) : new JButton(action);
        button.setText("");
        button.setActionCommand(action);
        button.setFocusable(false);
        button.setToolTipText(action);
        action = action.toLowerCase();
        if (al != null) {
            button.addActionListener(al);
        }
        try {
            button.setIcon(UIUtils.createIcon(action));
        }
        catch (Exception e) {
            System.out.println("Caught unhandled exception: " + e);
        }
        button.setMargin(new Insets(1, 1, 1, 1));
        button.setRolloverEnabled(true);
        return button;
    }

    public static ImageIcon createIcon(String action) {
        String[] tokens = BeanUtils.unpackPropertyName(action).split(" ");
        URL url = ClassLoader.getSystemResource("cres/actions/" + action + ".png");
        return new ImageIcon(url);
    }

    public static Component[] createMenuTree(JMenu root, Object[] commands, ActionListener listener) {
        return UIUtils.createMenuTree(root, commands, commands, listener);
    }

    public static Component[] createMenuTree(JMenu root, Object[] texts, Object[] commands, ActionListener listener) {
        if (root == null) {
            root = new JMenu();
        }
        ButtonGroup currentGroup = new ButtonGroup();
        int i = 0;
        while (i < commands.length) {
            if (commands[i] != null) {
                String[] cmdpath = BasicUtils.unpack(texts[i].toString(), '/', false);
                JComponent cMenu = root;
                JComponent newItem = null;
                int u = 0;
                while (u < cmdpath.length) {
                    if (u < cmdpath.length - 1) {
                        newItem = null;
                        int k = 0;
                        while (k < ((JMenu)cMenu).getItemCount()) {
                            if (((JMenu)cMenu).getItem(k) instanceof JMenu && ((JMenu)cMenu).getItem(k).getText().trim().equalsIgnoreCase(cmdpath[u])) {
                                newItem = ((JMenu)cMenu).getItem(k);
                            }
                            ++k;
                        }
                        if (newItem == null) {
                            newItem = new JMenu(cmdpath[u]);
                            if (currentGroup.getElements().hasMoreElements()) {
                                currentGroup = new ButtonGroup();
                            }
                        }
                        ((JMenu)cMenu).add(newItem);
                        cMenu = newItem;
                    } else if (cmdpath[u].equals("--")) {
                        newItem = new JSeparator();
                        ((JMenu)cMenu).add(newItem);
                        if (currentGroup.getElements().hasMoreElements()) {
                            currentGroup = new ButtonGroup();
                        }
                    } else {
                        if (cmdpath[u].startsWith("&( )")) {
                            newItem = new JRadioButtonMenuItem(cmdpath[u].substring(4), false);
                            currentGroup.add((AbstractButton)newItem);
                        } else if (cmdpath[u].startsWith("&(o)")) {
                            newItem = new JRadioButtonMenuItem(cmdpath[u].substring(4), true);
                            currentGroup.add((AbstractButton)newItem);
                        } else {
                            newItem = cmdpath[u].startsWith("&[ ]") ? new JCheckBoxMenuItem(cmdpath[u].substring(4), false) : (cmdpath[u].startsWith("&[x]") ? new JCheckBoxMenuItem(cmdpath[u].substring(4), true) : new JMenuItem(cmdpath[u]));
                        }
                        String command = BasicUtils.replaceString(commands[i].toString(), "&( )", "");
                        command = BasicUtils.replaceString(command.toString(), "&(o)", "");
                        command = BasicUtils.replaceString(command.toString(), "&[ ]", "");
                        command = BasicUtils.replaceString(command.toString(), "&[x]", "");
                        ((AbstractButton)newItem).setActionCommand(command);
                        ((AbstractButton)newItem).addActionListener(listener);
                        ((JMenu)cMenu).add((AbstractButton)newItem);
                    }
                    ++u;
                }
            }
            ++i;
        }
        return root.getMenuComponents();
    }

    public static JButton[] createSimpleButtonSet(String[] text, ActionListener al) {
        JButton[] buttons = new JButton[text.length];
        int i = 0;
        while (i < buttons.length) {
            buttons[i] = new JButton(text[i]);
            buttons[i].addActionListener(al);
            buttons[i].setDefaultCapable(true);
            try {
                buttons[i].setIcon(new ImageIcon(ClassLoader.getSystemResource("cres/actions/" + text[i].replace('|', '.').toLowerCase() + ".png")));
            }
            catch (Exception e) {
                DevUtils.handleException("ui", "UIUTils, cause: cres/actions/" + text[i].replace('|', '.').toLowerCase() + ".png", e);
            }
            ++i;
        }
        return buttons;
    }

    public static DefaultMutableTreeNode createTree(Object[] components) {
        DefaultMutableTreeNode root;
        DefaultMutableTreeNode actualRoot = root = new DefaultMutableTreeNode("root");
        int i = 0;
        while (i < components.length) {
            StringTokenizer st = new StringTokenizer(components[i].toString(), "/", false);
            int index = 0;
            while (st.hasMoreTokens()) {
                String ct = st.nextToken();
                DefaultMutableTreeNode cNode = UIUtils.lookupChildContaining(root, ct);
                if (cNode == null) {
                    cNode = new DefaultMutableTreeNode(ct);
                    root.add(cNode);
                }
                root = cNode;
                ++index;
            }
            root = actualRoot;
            ++i;
        }
        return root;
    }

    public static void drawDashedRect(Graphics g, int x, int y, int width, int height) {
        UIUtils.drawDashedRect(g, x, y, width, height, 3);
    }

    public static void drawDashedRect(Graphics g, int x, int y, int width, int height, int gap) {
        int vx = x;
        while (vx < x + width) {
            g.drawLine(vx, y, vx, y);
            g.drawLine(vx, y + height - 1, vx, y + height - 1);
            vx += gap;
        }
        int vy = y;
        while (vy < y + height) {
            g.drawLine(x, vy, x, vy);
            g.drawLine(x + width - 1, vy, x + width - 1, vy);
            vy += gap;
        }
    }

    public static void drawRevertedDashedRect(Graphics g, int x, int y, int width, int height) {
        int vx = x;
        while (vx < x + width) {
            g.drawLine(vx, y, vx, y);
            g.drawLine(vx, y + height - 1, vx, y + height - 1);
            vx += 2;
        }
        int vy = y;
        while (vy < y + height) {
            g.drawLine(x, vy, x, vy);
            g.drawLine(x + width - 1, vy, x + width - 1, vy);
            vy += 2;
        }
    }

    public static void expandPaths(Vector paths, JTree tree, String toSelect) {
        if (paths == null) {
            return;
        }
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)tree.getModel().getRoot();
        DefaultMutableTreeNode lastNode = null;
        TreePath rp = null;
        String cToken = null;
        int i = 0;
        while (i < paths.size()) {
            StringTokenizer st = new StringTokenizer(paths.get(i).toString(), "/:", false);
            st.nextToken();
            lastNode = root;
            while (st.hasMoreTokens()) {
                cToken = st.nextToken();
                if (UIUtils.lookupChildNamed(lastNode, cToken) == null) break;
                lastNode = UIUtils.lookupChildNamed(lastNode, cToken);
            }
            rp = new TreePath(((DefaultTreeModel)tree.getModel()).getPathToRoot(lastNode));
            tree.expandPath(rp);
            ++i;
        }
        UIUtils.setSelectedPath(tree, toSelect);
    }

    public static DefaultMutableTreeNode lookupChildContaining(DefaultMutableTreeNode node, Object content) {
        if (content.equals(node.getUserObject())) {
            return node;
        }
        DefaultMutableTreeNode ans = null;
        int i = 0;
        while (i < node.getChildCount() && ans == null) {
            ans = UIUtils.lookupChildContaining((DefaultMutableTreeNode)node.getChildAt(i), content);
            ++i;
        }
        return ans;
    }

    public static DefaultMutableTreeNode lookupChildNamed(DefaultMutableTreeNode node, String name) {
        Enumeration<TreeNode> children = node.children();
        while (children.hasMoreElements()) {
            DefaultMutableTreeNode chNode = (DefaultMutableTreeNode)children.nextElement();
            boolean eval = name.equals(chNode.toString().trim());
            if (!eval) continue;
            return chNode;
        }
        return null;
    }

    public static Vector lookupExpandedPaths(JTree tree) {
        Vector<String> exp = null;
        exp = new Vector<String>();
        Enumeration<TreePath> e = tree.getExpandedDescendants(new TreePath(tree.getModel().getRoot()));
        while (e.hasMoreElements()) {
            exp.add(UIUtils.treePath2String(e.nextElement()));
        }
        return exp;
    }

    public static String selectionPathAsString(JTree tree) {
        return UIUtils.treePath2String(tree.getSelectionPath());
    }

    public static void setSelectedPath(JTree tree, String toSelect) {
        StringTokenizer st = new StringTokenizer(toSelect, "/:", false);
        st.nextToken();
        DefaultMutableTreeNode lastNode = (DefaultMutableTreeNode)tree.getModel().getRoot();
        TreePath rp = null;
        while (st.hasMoreTokens()) {
            if ((lastNode = UIUtils.lookupChildNamed(lastNode, st.nextToken())) == null) break;
            rp = new TreePath(((DefaultTreeModel)tree.getModel()).getPathToRoot(lastNode));
        }
        tree.setSelectionPath(rp);
    }

    public static String treePath2String(TreePath treePath) {
        String str = "";
        Object[] path = treePath.getPath();
        int i = 0;
        while (i < path.length) {
            str = String.valueOf(str) + path[i].toString().trim() + (i == path.length - 1 ? "" : "/");
            ++i;
        }
        return str;
    }
}

