/*
 * Decompiled with CFR 0.152.
 */
package com.shfarr.ui.layouts;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager2;
import java.util.Vector;

public abstract class AbstractLayout
implements LayoutManager2 {
    protected Vector ccs = new Vector();

    public void addLayoutComponent(Component comp, Object constraints) {
        this.ccs.add(new ConstraintsComponentPair(comp, constraints, comp.getName()));
    }

    public void addLayoutComponent(String name, Component comp) {
        this.ccs.add(new ConstraintsComponentPair(comp, this.getDefaultConstraints(), name));
    }

    protected Object getConstraintsFor(Component c) {
        Object theCts = null;
        int i = 0;
        while (i < this.ccs.size()) {
            if (((ConstraintsComponentPair)this.ccs.elementAt((int)i)).component == c) {
                theCts = ((ConstraintsComponentPair)this.ccs.elementAt((int)i)).constraints;
                break;
            }
            ++i;
        }
        if (theCts == null) {
            theCts = this.getDefaultConstraints();
        }
        return theCts;
    }

    protected abstract Object getDefaultConstraints();

    public float getLayoutAlignmentX(Container target) {
        return -1.0f;
    }

    public float getLayoutAlignmentY(Container target) {
        return -1.0f;
    }

    public void invalidateLayout(Container target) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void layoutContainer(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            this.performLayout(parent);
        }
    }

    public Dimension maximumLayoutSize(Container target) {
        return new Dimension(0, 0);
    }

    public Dimension minimumLayoutSize(Container parent) {
        return new Dimension(0, 0);
    }

    protected abstract void performLayout(Container var1);

    public void removeLayoutComponent(Component comp) {
        int i = 0;
        while (i < this.ccs.size()) {
            if (((ConstraintsComponentPair)this.ccs.elementAt((int)i)).component == comp) {
                this.ccs.removeElementAt(i);
            }
            ++i;
        }
    }

    protected class ConstraintsComponentPair {
        Component component = null;
        Object constraints = null;
        String name = null;

        ConstraintsComponentPair() {
        }

        ConstraintsComponentPair(Component component, Object constraints, String name) {
            this.component = component;
            this.constraints = constraints;
            this.name = name;
        }
    }
}

