/*
 * Decompiled with CFR 0.152.
 */
package com.shfarr.ui.layouts;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;

public class FlexibleGridLayout
implements LayoutManager2 {
    protected int vGap = 0;
    protected int hGap = 0;
    protected int rows = 1;
    protected int cols = 1;
    protected boolean redistributeVertically = true;
    protected boolean redistributeHorizontally = true;

    public FlexibleGridLayout(int rows, int cols) {
        this(rows, cols, 0, 0);
    }

    public FlexibleGridLayout(int rows, int cols, int hGap, int vGap) {
        this.rows = rows;
        this.cols = cols;
        this.hGap = hGap;
        this.vGap = vGap;
    }

    public FlexibleGridLayout(int rows, int cols, int hGap, int vGap, boolean redistributeHorizontally, boolean redistributeVertically) {
        this.rows = rows;
        this.cols = cols;
        this.hGap = hGap;
        this.vGap = vGap;
        this.redistributeHorizontally = redistributeHorizontally;
        this.redistributeVertically = redistributeVertically;
    }

    public void addLayoutComponent(Component comp, Object constraints) {
    }

    public void addLayoutComponent(String name, Component comp) {
    }

    public float getLayoutAlignmentX(Container target) {
        return -1.0f;
    }

    public float getLayoutAlignmentY(Container target) {
        return -1.0f;
    }

    public void invalidateLayout(Container target) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void layoutContainer(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            int amount;
            int k;
            Component[] cps = parent.getComponents();
            Dimension pd = this.preferredLayoutSize(parent);
            Dimension d = null;
            int[] colWidths = new int[this.cols];
            int[] rowHeights = new int[this.rows];
            int k2 = 0;
            while (k2 < cps.length) {
                d = cps[k2].getPreferredSize();
                colWidths[k2 % this.cols] = Math.max(colWidths[k2 % this.cols], d.width);
                rowHeights[k2 / this.cols] = Math.max(rowHeights[k2 / this.cols], d.height);
                ++k2;
            }
            d = parent.getSize();
            int xExcess = d.width - pd.width;
            int yExcess = d.height - pd.height;
            int xCountdown = xExcess;
            int yCountdown = yExcess;
            if (this.redistributeHorizontally) {
                k = 0;
                while (k < this.cols) {
                    if (k % this.cols < this.cols - 1) {
                        amount = (int)((double)xExcess * (double)colWidths[k % this.cols] / (double)pd.width);
                        xCountdown -= amount;
                        int n = k % this.cols;
                        colWidths[n] = colWidths[n] + amount;
                    } else {
                        int n = k % this.cols;
                        colWidths[n] = colWidths[n] + xCountdown;
                    }
                    ++k;
                }
            }
            if (this.redistributeVertically) {
                k = 0;
                while (k < this.rows) {
                    if (k / this.rows < this.rows - 1) {
                        amount = (int)((double)yExcess * (double)rowHeights[k / this.rows] / (double)pd.height);
                        yCountdown -= amount;
                        int n = k / this.rows;
                        rowHeights[n] = rowHeights[n] + amount;
                    } else {
                        int n = k / this.rows;
                        rowHeights[n] = rowHeights[n] + yCountdown;
                    }
                    ++k;
                }
            }
            Insets insets = parent.getInsets() != null ? parent.getInsets() : new Insets(0, 0, 0, 0);
            int k3 = 0;
            int x = insets.left;
            int y = insets.top;
            while (k3 < cps.length) {
                if (k3 % this.cols != 0) {
                    x += this.hGap + colWidths[k3 % this.cols - 1];
                } else {
                    x = insets.left;
                    if (k3 / this.cols != 0) {
                        y += this.vGap + rowHeights[k3 / this.cols - 1];
                    }
                }
                cps[k3].setBounds(x, y, colWidths[k3 % this.cols], rowHeights[k3 / this.cols]);
                ++k3;
            }
        }
    }

    public Dimension maximumLayoutSize(Container target) {
        return new Dimension(50000, 50000);
    }

    public Dimension minimumLayoutSize(Container parent) {
        return new Dimension(10, 10);
    }

    public Dimension preferredLayoutSize(Container parent) {
        Component[] cps = parent.getComponents();
        int[] colWidths = new int[this.cols];
        int[] rowHeights = new int[this.rows];
        Dimension d = null;
        int k = 0;
        while (k < cps.length) {
            d = cps[k].getPreferredSize();
            colWidths[k % this.cols] = Math.max(colWidths[k % this.cols], d.width);
            rowHeights[k / this.cols] = Math.max(rowHeights[k / this.cols], d.height);
            ++k;
        }
        Insets insets = parent.getInsets() != null ? parent.getInsets() : new Insets(0, 0, 0, 0);
        d = new Dimension(insets.left + insets.right + this.hGap * (this.cols - 1), insets.top + insets.bottom + this.vGap * (this.rows - 1));
        int i = 0;
        while (i < colWidths.length) {
            d.width += colWidths[i];
            ++i;
        }
        i = 0;
        while (i < rowHeights.length) {
            d.height += rowHeights[i];
            ++i;
        }
        return d;
    }

    public void removeLayoutComponent(Component comp) {
    }
}

