/*
 * Decompiled with CFR 0.152.
 */
package com.shfarr.ui.plaf.fh;

import com.shfarr.DevUtils;
import com.shfarr.ui.ChannelImageFilter;
import com.shfarr.ui.FhSysButton;
import com.shfarr.ui.GraphicsUtils;
import com.shfarr.ui.plaf.fh.textures.Texture;
import com.shfarr.ui.plaf.fh.theme.ThemeManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.RGBImageFilter;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.DefaultButtonModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.plaf.basic.BasicComboPopup;
import javax.swing.plaf.basic.ComboPopup;

public class FhComboBoxUI
extends BasicComboBoxUI {
    private static ChannelImageFilter fadeFilter = new ChannelImageFilter(0.1, 0.0, 0.0, 0.0);
    private static final Animator animator = new Animator();
    protected Border popupBorder = null;

    public void configureEditor() {
        super.configureEditor();
    }

    protected JButton createArrowButton() {
        FhComboBoxButton button = new FhComboBoxButton();
        return button;
    }

    protected LayoutManager createLayoutManager() {
        return new FhComboBoxLayoutManager();
    }

    protected ComboPopup createPopup() {
        BasicComboPopup popup = new BasicComboPopup(this.comboBox){

            public String getUIClassID() {
                return "ComboPopupUI";
            }

            protected void configurePopup() {
                super.configurePopup();
                this.setBorder(null);
            }
        };
        popup.getAccessibleContext().setAccessibleParent(this.comboBox);
        return popup;
    }

    public PropertyChangeListener createPropertyChangeListener() {
        return new BasicComboBoxUI.PropertyChangeHandler(this){

            public void propertyChange(PropertyChangeEvent e) {
                super.propertyChange(e);
                String propertyName = e.getPropertyName();
                if (propertyName.equals("editable")) {
                    FhComboBoxButton button = FhComboBoxUI.this.getArrowButton();
                    FhComboBoxUI.this.getComboBox().repaint();
                } else if (propertyName.equals("background")) {
                    Color color = (Color)e.getNewValue();
                    FhComboBoxUI.this.getArrowButton().setBackground(color);
                    FhComboBoxUI.this.getListBox().setBackground(color);
                } else if (propertyName.equals("foreground")) {
                    Color color = (Color)e.getNewValue();
                    FhComboBoxUI.this.getArrowButton().setForeground(color);
                    FhComboBoxUI.this.getListBox().setForeground(color);
                }
            }
        };
    }

    public static ComponentUI createUI(JComponent c) {
        return new FhComboBoxUI();
    }

    public FhComboBoxButton getArrowButton() {
        return (FhComboBoxButton)this.arrowButton;
    }

    protected JComboBox getComboBox() {
        return this.comboBox;
    }

    public Component getEditor() {
        return this.editor;
    }

    protected JList getListBox() {
        return this.listBox;
    }

    public Dimension getMinimumSize(JComponent c) {
        Insets i = c.getBorder() != null ? c.getBorder().getBorderInsets(c) : new Insets(0, 0, 0, 0);
        int mh = (int)((double)c.getFont().getSize() * 1.5) + i.top + i.bottom;
        if (ThemeManager.instance().getPreferences().isBordersDoubled()) {
            mh = (int)((double)mh * 1.5);
        }
        return new Dimension(this.getListBox().getPreferredSize().width + mh + 3, mh);
    }

    public void installUI(JComponent jc) {
        super.installUI(jc);
        ((JComboBox)jc).setLightWeightPopupEnabled(true);
    }

    public void paint(Graphics g, JComponent c) {
        ThemeManager.instance().probeAntialiasing(g);
        super.paint(g, c);
        Rectangle r = this.rectangleForCurrentValue();
        g.setColor((Color)UIManager.getDefaults().get("EditableComponent.background"));
        g.drawRect(r.x + r.width - 1, r.y, c.getSize().width - this.getInsets().right - (r.x + r.width), r.height - 1);
        g.setColor(UIManager.getColor("Component.moderatedShadow"));
        g.drawLine(r.x + r.width - 2, r.y, r.x + r.width - 2, r.height + 1);
        Texture texture = (Texture)UIManager.getDefaults().get("Field.inactiveTexture");
        if (texture != null && ThemeManager.instance().probeSmallTextures()) {
            texture.apply(r, (Graphics2D)g, c);
        }
    }

    public Rectangle rectangleForCurrentValue() {
        int width = this.comboBox.getWidth();
        int height = this.comboBox.getHeight();
        Insets insets = this.getInsets();
        int buttonSize = height - (insets.top + insets.bottom);
        if (this.arrowButton != null) {
            buttonSize = this.arrowButton.getWidth();
        }
        if (this.comboBox.getComponentOrientation().isLeftToRight()) {
            return new Rectangle(insets.left, insets.top, width - (insets.left + insets.right + buttonSize) - 1, height - (insets.top + insets.bottom));
        }
        return new Rectangle(insets.left + buttonSize, insets.top, width - (insets.left + insets.right + buttonSize), height - (insets.top + insets.bottom));
    }

    public void unconfigureEditor() {
        super.unconfigureEditor();
    }

    private static class Animator
    implements Runnable {
        private Graphics ag = null;
        private BufferedImage img = null;
        private Component c = null;

        Animator() {
        }

        public void animate(Graphics g, BufferedImage img, Component c) {
            this.ag = g;
            this.img = img;
            this.c = c;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Image faded = GraphicsUtils.applyFilter(this.img, (RGBImageFilter)fadeFilter);
            int i = 0;
            while (i < 10) {
                this.ag.drawImage(faded, 0, 0, null);
                try {
                    Animator animator = this;
                    synchronized (animator) {
                        this.wait(10L);
                    }
                }
                catch (InterruptedException e) {
                    DevUtils.handleException("ui", "(shfarr :: FhComboBoxUI.java)", e);
                }
                ++i;
            }
            this.ag.drawImage(this.img, 0, 0, null);
        }
    }

    protected class FhComboBoxButton
    extends FhSysButton {
        public FhComboBoxButton() {
            super(3, 0);
            DefaultButtonModel model = new DefaultButtonModel(this){
                final /* synthetic */ FhComboBoxButton this$1;
                {
                    this.this$1 = fhComboBoxButton;
                }

                public void setArmed(boolean armed) {
                    super.setArmed(this.isPressed() ? true : armed);
                }
            };
        }

        protected int getExtraInset() {
            return Math.max((int)((float)Math.min(this.getSize().width, this.getSize().height) * 5.0f / 15.0f) - 4, 0);
        }
    }

    protected class FhComboBoxLayoutManager
    implements LayoutManager {
        public void addLayoutComponent(String name, Component comp) {
        }

        public void layoutContainer(Container parent) {
            JComboBox cb = (JComboBox)parent;
            int width = cb.getWidth();
            int height = cb.getHeight();
            Insets insets = cb.getInsets();
            int buttonSize = height - (insets.top + insets.bottom);
            if (((FhComboBoxUI)cb.getUI()).getArrowButton() != null) {
                if (cb.getComponentOrientation().isLeftToRight()) {
                    ((FhComboBoxUI)cb.getUI()).getArrowButton().setBounds(width - (insets.right + buttonSize) - 1, insets.top + 1, buttonSize, buttonSize - 2);
                } else {
                    ((FhComboBoxUI)cb.getUI()).getArrowButton().setBounds(insets.left, insets.top, buttonSize, buttonSize);
                }
            }
            if (((FhComboBoxUI)cb.getUI()).getEditor() != null) {
                Rectangle cvb = ((FhComboBoxUI)cb.getUI()).rectangleForCurrentValue();
                ((FhComboBoxUI)cb.getUI()).getEditor().setBounds(cvb);
            }
        }

        public Dimension minimumLayoutSize(Container parent) {
            JComboBox cb = (JComboBox)parent;
            return parent.getMinimumSize();
        }

        public Dimension preferredLayoutSize(Container parent) {
            JComboBox cb = (JComboBox)parent;
            return parent.getPreferredSize();
        }

        public void removeLayoutComponent(Component comp) {
        }
    }
}

