/*
 * Decompiled with CFR 0.152.
 */
package com.shfarr.ui.plaf.fh;

import com.shfarr.ui.layouts.QueueLayout;
import com.shfarr.ui.plaf.fh.theme.ThemeManager;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicPopupMenuUI;

public class FhPopupMenuUI
extends BasicPopupMenuUI {
    private static final ComponentListener listener = new ComponentAdapter(){

        public void componentResized(ComponentEvent e) {
            if (((JComponent)e.getSource()).getParent().isOpaque()) {
                ((JComponent)((JComponent)e.getSource()).getParent()).setOpaque(false);
            } else {
                ((JComponent)e.getSource()).removeComponentListener(this);
            }
        }
    };

    public static ComponentUI createUI(JComponent cmp) {
        return new FhPopupMenuUI();
    }

    public void installDefaults() {
        if (this.popupMenu.getLayout() == null || this.popupMenu.getLayout() instanceof UIResource) {
            this.popupMenu.setLayout(new QueueLayout((Integer)UIManager.getDefaults().get("PopupMenu.gap"), 0, 2));
        }
        super.installDefaults();
        LookAndFeel.installBorder(this.popupMenu, String.valueOf(this.popupMenu.getUIClassID().substring(0, this.popupMenu.getUIClassID().length() - 2)) + ".border");
    }

    public void paint(Graphics g, JComponent c) {
        ThemeManager.instance().probeAntialiasing(g);
        Insets i = c.getBorder() != null ? c.getBorder().getBorderInsets(c) : new Insets(0, 0, 0, 0);
        g.setColor(UIManager.getColor("PopupMenu.background"));
        g.fillRect(i.left, i.top, c.getWidth() - i.left - i.right, c.getHeight() - i.top - i.bottom);
        super.paint(g, c);
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        if (((JPopupMenu)c).isLightWeightPopupEnabled()) {
            c.setOpaque(false);
            c.addComponentListener(listener);
        }
    }
}

