/*
 * Decompiled with CFR 0.152.
 */
package com.shfarr.ui.plaf.fh;

import com.shfarr.ui.plaf.fh.borders.FhMatrixBorder;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicSeparatorUI;

public class FhSeparatorUI
extends BasicSeparatorUI {
    public static ComponentUI createUI(JComponent c) {
        return new FhSeparatorUI();
    }

    public Dimension getPreferredSize(JComponent c) {
        Border b = UIManager.getDefaults().getBorder("Separator.border");
        if (b == null) {
            return new Dimension(5, 5);
        }
        Insets i = b.getBorderInsets(c);
        return new Dimension(i.left + i.right, i.top + i.bottom);
    }

    protected void installDefaults(JSeparator s) {
        Dimension size;
        LookAndFeel.installColors(s, "Separator.background", "Separator.foreground");
        if (s instanceof JToolBar.Separator && ((size = ((JToolBar.Separator)s).getSeparatorSize()) == null || size instanceof UIResource)) {
            size = (Dimension)UIManager.get("ToolBar.separatorSize");
            ((JToolBar.Separator)s).setSeparatorSize(size);
        }
    }

    public void paint(Graphics g, JComponent c) {
        Rectangle r = new Rectangle(0, 0, c.getWidth(), c.getHeight());
        Border b = UIManager.getDefaults().getBorder("Separator.border");
        if (b instanceof FhMatrixBorder && ((JSeparator)c).getOrientation() == 1) {
            b = ((FhMatrixBorder)b).deriveBorder(1);
        }
        b.paintBorder(c, g, r.x, r.y, r.width, r.height);
    }
}

