/*
 * Decompiled with CFR 0.152.
 */
package com.shfarr.ui.plaf.fh;

import com.shfarr.ui.plaf.fh.ext.FhDefaults;
import com.shfarr.ui.plaf.fh.textures.Texture;
import com.shfarr.ui.plaf.fh.theme.ThemeManager;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicSliderUI;

public class FhSliderUI
extends BasicSliderUI {
    protected int previousLabel = -1;

    public FhSliderUI(JSlider js) {
        super(js);
    }

    public static ComponentUI createUI(JComponent c) {
        return new FhSliderUI((JSlider)c);
    }

    public void paintTrack(Graphics g) {
        Border trackBorder = UIManager.getDefaults().getBorder("Slider.trackBorder");
        Insets ins = trackBorder != null ? trackBorder.getBorderInsets(null) : new Insets(0, 0, 0, 0);
        int textureRotation = 0;
        int outsetX = 0;
        int outsetY = 0;
        Dimension size = this.slider.getSize();
        if (this.slider.getOrientation() == 0) {
            textureRotation = 0;
            outsetX = ins.left;
        } else {
            textureRotation = 3;
            outsetY = ins.top;
        }
        Rectangle fullBounds = new Rectangle(this.trackRect.x, this.trackRect.y, this.trackRect.width, this.trackRect.height);
        Rectangle strippedBounds = new Rectangle(fullBounds.x + ins.left, fullBounds.y + ins.top, fullBounds.width - ins.left - ins.right, fullBounds.height - ins.top - ins.right);
        Rectangle fillRect = new Rectangle(fullBounds.x + ins.left, outsetY != 0 ? this.thumbRect.y : fullBounds.y + ins.top, outsetX != 0 ? this.thumbRect.x - fullBounds.x : fullBounds.width - ins.left - ins.right, outsetY != 0 ? fullBounds.y + fullBounds.height - this.thumbRect.y - ins.bottom : fullBounds.height - ins.top - ins.bottom);
        if (this.slider.isEnabled()) {
            g.setColor(UIManager.getColor("EditableComponent.background"));
        } else {
            g.setColor(UIManager.getColor("EditableComponent.inactiveBackground"));
        }
        g.fillRect(fullBounds.x, fullBounds.y, fullBounds.width, fullBounds.height);
        Texture trackTexture = (Texture)UIManager.getDefaults().get("Slider.trackTexture");
        Texture completedTexture = (Texture)UIManager.getDefaults().get("Slider.trackCompletedTexture");
        if (completedTexture != null && ThemeManager.instance().probeSmallTextures()) {
            completedTexture.rotate(textureRotation);
            completedTexture.apply(strippedBounds, fillRect, (Graphics2D)g, this.slider);
            completedTexture.rotate(-textureRotation);
        } else {
            g.setColor((Color)UIManager.getDefaults().get("Slider.selectionBackground"));
            g.fillRect(fillRect.x, fillRect.y, fillRect.width, fillRect.height);
        }
        if (trackTexture != null && ThemeManager.instance().probeSmallTextures()) {
            trackTexture.rotate(textureRotation);
            trackTexture.apply(strippedBounds, (Graphics2D)g, this.slider);
            trackTexture.rotate(-textureRotation);
        }
        trackBorder.paintBorder(this.slider, g, fullBounds.x, fullBounds.y, fullBounds.width, fullBounds.height);
    }

    public void paintFocus(Graphics g) {
    }

    protected void paintMinorTickForHorizSlider(Graphics g, Rectangle tickBounds, int x) {
        g.setColor((Color)UIManager.getDefaults().get("Slider.shadow"));
        g.drawLine(x, 3, x, this.tickRect.height - 3 - 1);
        g.setColor((Color)UIManager.getDefaults().get("Slider.highlight"));
        g.drawLine(x + 1, 3, x + 1, this.tickRect.height - 3 - 1);
    }

    protected void paintMajorTickForHorizSlider(Graphics g, Rectangle tickBounds, int x) {
        g.setColor((Color)UIManager.getDefaults().get("Slider.shadow"));
        g.drawLine(x, 1, x, this.tickRect.height - 2);
        g.setColor((Color)UIManager.getDefaults().get("Slider.highlight"));
        g.drawLine(x + 1, 1, x + 1, this.tickRect.height - 2);
    }

    protected void paintMinorTickForVertSlider(Graphics g, Rectangle tickBounds, int y) {
        g.setColor((Color)UIManager.getDefaults().get("Slider.shadow"));
        g.drawLine(3, y, this.tickRect.width - 3 - 1, y);
        g.setColor((Color)UIManager.getDefaults().get("Slider.highlight"));
        g.drawLine(3, y + 1, this.tickRect.width - 3 - 1, y + 1);
    }

    protected void paintMajorTickForVertSlider(Graphics g, Rectangle tickBounds, int y) {
        g.setColor((Color)UIManager.getDefaults().get("Slider.shadow"));
        g.drawLine(1, y, this.tickRect.width - 2, y);
        g.setColor((Color)UIManager.getDefaults().get("Slider.highlight"));
        g.drawLine(1, y + 1, this.tickRect.width - 2, y + 1);
    }

    public int getTickLength() {
        return 4;
    }

    public Dimension getThumbSize() {
        Insets ins;
        Border thumbBorder = UIManager.getDefaults().getBorder("Slider.thumbBorder");
        Insets insets = ins = thumbBorder != null ? thumbBorder.getBorderInsets(null) : new Insets(0, 0, 0, 0);
        if (this.slider.getOrientation() == 0) {
            return new Dimension(6 + ins.left + ins.right, 13 + ins.top + ins.bottom);
        }
        return new Dimension(15 + ins.left + ins.right, 6 + ins.top + ins.bottom);
    }

    public void paintThumb(Graphics g) {
        Texture thumbTexture;
        Border thumbBorder = UIManager.getDefaults().getBorder("Slider.thumbBorder");
        Insets ins = thumbBorder.getBorderInsets(null);
        g.translate(this.thumbRect.x, this.thumbRect.y);
        g.setColor(this.slider.getBackground());
        g.fillRect(ins.left, ins.top, this.thumbRect.width - (ins.left + ins.right), this.thumbRect.height - (ins.top + ins.bottom));
        thumbBorder.paintBorder(this.slider, g, 0, 0, this.thumbRect.width, this.thumbRect.height);
        if (this.slider.isEnabled()) {
            FhDefaults.paintTouch(this.slider, g, ins.left + 1, ins.top + 1, this.thumbRect.width - (ins.left + ins.right + 2), this.thumbRect.height - (ins.top + ins.bottom + 2));
        }
        if ((thumbTexture = (Texture)UIManager.getDefaults().get("SysButton.texture")) != null && ThemeManager.instance().probeSmallTextures()) {
            thumbTexture.apply(new Rectangle(ins.left, ins.top, this.thumbRect.width - (ins.left + ins.right), this.thumbRect.height - (ins.top + ins.bottom)), (Graphics2D)g, this.slider);
        }
        g.translate(-this.thumbRect.x, -this.thumbRect.y);
    }

    protected void calculateThumbLocation() {
        super.calculateThumbLocation();
        if (this.slider.getOrientation() == 0) {
            this.thumbRect.translate(0, -Math.min(4, this.thumbRect.y));
        } else {
            this.thumbRect.translate(-Math.min(5, this.thumbRect.x), 0);
        }
    }

    protected void calculateTrackRect() {
        if (this.slider.getOrientation() == 0) {
            this.trackRect.setBounds(this.getThumbSize().width / 2, this.getThumbSize().height / 2 - 4, this.slider.getSize().width - this.getThumbSize().width, 8);
            if (this.slider.getPaintTicks()) {
                this.trackRect.translate(0, 5);
            }
        } else {
            this.trackRect.setBounds(this.getThumbSize().width / 2 - 4, this.getThumbSize().height / 2, 8, this.slider.getSize().height - this.getThumbSize().height);
            if (this.slider.getPaintTicks()) {
                this.trackRect.translate(5, 0);
            }
        }
        Insets i = this.slider.getBorder() != null ? this.slider.getBorder().getBorderInsets(this.slider) : new Insets(0, 0, 0, 0);
        this.trackRect.setBounds(this.trackRect.x + i.left, this.trackRect.y + i.top, this.trackRect.width - i.left - i.right, this.trackRect.height - i.top - i.bottom);
    }

    protected void calculateTickRect() {
        if (this.slider.getOrientation() == 0) {
            this.tickRect.setBounds(this.trackRect.x + 2, this.trackRect.y - 5, this.trackRect.width - 4, this.trackRect.height + 10);
        } else {
            this.tickRect.setBounds(this.trackRect.x - 5, this.trackRect.y + 2, this.trackRect.width + 10, this.trackRect.height - 4);
        }
    }

    public void paint(Graphics g, JComponent c) {
        ThemeManager.instance().probeAntialiasing(g);
        this.recalculateIfInsetsChanged();
        this.recalculateIfOrientationChanged();
        Rectangle clip = g.getClipBounds();
        if (!clip.intersects(this.trackRect) && this.slider.getPaintTrack()) {
            this.calculateGeometry();
        }
        if (this.slider.getPaintTicks() && clip.intersects(this.tickRect)) {
            this.paintTicks(g);
        }
        if (this.slider.getPaintTrack() && clip.intersects(this.trackRect)) {
            this.paintTrack(g);
        }
        if (this.slider.getPaintLabels() && clip.intersects(this.labelRect)) {
            this.paintLabels(g);
        }
        if (this.slider.hasFocus() && clip.intersects(this.focusRect)) {
            this.paintFocus(g);
        }
        if (clip.intersects(this.thumbRect)) {
            this.paintThumb(g);
        }
    }
}

