/*
 * Decompiled with CFR 0.152.
 */
package com.shfarr.ui.plaf.fh;

import com.shfarr.ui.FhSysButton;
import com.shfarr.ui.plaf.fh.theme.ThemeManager;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JSpinner;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicSpinnerUI;

public class FhSpinnerUI
extends BasicSpinnerUI {
    private static final FhArrowButtonHandler nextButtonHandler = new FhArrowButtonHandler(true);
    private static final FhArrowButtonHandler previousButtonHandler = new FhArrowButtonHandler(false);

    protected Component createPreviousButton() {
        FhSysButton button = new FhSysButton(4);
        button.setName("Previous");
        button.addActionListener(previousButtonHandler);
        button.addMouseListener(previousButtonHandler);
        return button;
    }

    protected Component createNextButton() {
        FhSysButton button = new FhSysButton(2);
        button.setName("Next");
        button.addActionListener(nextButtonHandler);
        button.addMouseListener(nextButtonHandler);
        return button;
    }

    protected LayoutManager createLayout() {
        return new FhSpinnerLayoutManager();
    }

    public static ComponentUI createUI(JComponent c) {
        return new FhSpinnerUI();
    }

    public void installDefaults() {
        super.installDefaults();
        LookAndFeel.installBorder(this.spinner.getEditor(), "");
        int i = 0;
        while (i < this.spinner.getEditor().getComponentCount()) {
            ((JComponent)this.spinner.getEditor().getComponent(i)).setBorder(null);
            ++i;
        }
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new FhSpinnerPropertyChangeHandler();
    }

    protected void replaceEditor(JComponent oldEditor, JComponent newEditor) {
        this.spinner.remove(oldEditor);
        this.spinner.add((Component)newEditor, "Editor");
    }

    public void paint(Graphics g, JComponent c) {
        ThemeManager.instance().probeAntialiasing(g);
        super.paint(g, c);
        JSpinner cb = (JSpinner)c;
        int width = cb.getWidth();
        int height = cb.getHeight();
        Insets insets = cb.getInsets();
        g.setColor(UIManager.getColor("EditableComponent.background"));
        g.drawRect(insets.left, insets.top, 10, height - insets.top - insets.bottom - 1);
        g.drawRect(width - insets.right - 11, insets.top, 10, height - insets.top - insets.bottom - 1);
        g.setColor(UIManager.getColor("Component.moderatedShadow"));
        g.drawLine(insets.left + 11, insets.top, insets.left + 11, height - insets.top - insets.bottom + 1);
        g.drawLine(width - insets.right - 12, insets.top, width - insets.right - 12, height - insets.top - insets.bottom + 1);
    }

    protected class FhSpinnerLayoutManager
    implements LayoutManager {
        public void addLayoutComponent(String name, Component comp) {
        }

        public void layoutContainer(Container parent) {
            JSpinner cb = (JSpinner)parent;
            int width = cb.getWidth();
            int height = cb.getHeight();
            Insets insets = cb.getInsets();
            int buttonSize = height - (insets.top + insets.bottom);
            Component[] cps = this.extractComponents(parent);
            cps[0].setBounds(insets.left + 1, insets.top + 1, 9, height - insets.top - insets.bottom - 2);
            cps[1].setBounds(insets.left + 12, insets.top, width - insets.left - insets.right - 24, height - insets.top - insets.bottom);
            cps[2].setBounds(width - insets.right - 10, insets.top + 1, 9, height - insets.top - insets.bottom - 2);
        }

        public Dimension minimumLayoutSize(Container parent) {
            Component[] cps = this.extractComponents(parent);
            Insets insets = ((JComponent)parent).getInsets();
            Dimension ms = new Dimension(insets.left + insets.right + 24 + cps[1].getPreferredSize().width, (int)((double)parent.getFont().getSize() * 1.5) + insets.top + insets.bottom);
            ms.setSize(ms.width, Math.max(ms.height, cps[1].getPreferredSize().height));
            return ms;
        }

        public Dimension preferredLayoutSize(Container parent) {
            Dimension ps = this.minimumLayoutSize(parent);
            ps.setSize(ps.width, Math.max(ps.height, this.minimumLayoutSize((Container)parent).height));
            return ps;
        }

        public void removeLayoutComponent(Component comp) {
        }

        protected Component[] extractComponents(Container parent) {
            Component[] cps = new Component[3];
            int i = 0;
            while (i < parent.getComponentCount()) {
                if ("Previous".equals(parent.getComponent(i).getName())) {
                    cps[0] = parent.getComponent(i);
                } else if ("Next".equals(parent.getComponent(i).getName())) {
                    cps[2] = parent.getComponent(i);
                } else {
                    cps[1] = parent.getComponent(i);
                }
                ++i;
            }
            return cps;
        }
    }

    private static class FhSpinnerPropertyChangeHandler
    implements PropertyChangeListener {
        FhSpinnerPropertyChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent e) {
            String propertyName = e.getPropertyName();
            JSpinner spinner = (JSpinner)e.getSource();
            FhSpinnerUI ui = (FhSpinnerUI)spinner.getUI();
            if ("editor".equals(propertyName)) {
                JComponent oldEditor = (JComponent)e.getOldValue();
                JComponent newEditor = (JComponent)e.getNewValue();
                ui.replaceEditor(oldEditor, newEditor);
                newEditor.setBorder(null);
                int i = 0;
                while (i < newEditor.getComponentCount()) {
                    ((JComponent)newEditor.getComponent(i)).setBorder(null);
                    ++i;
                }
            }
        }
    }

    private static class FhArrowButtonHandler
    extends MouseAdapter
    implements ActionListener {
        final Timer autoRepeatTimer;
        final boolean isNext;
        JSpinner spinner = null;

        FhArrowButtonHandler(boolean isNext) {
            this.isNext = isNext;
            this.autoRepeatTimer = new Timer(60, this);
            this.autoRepeatTimer.setInitialDelay(300);
        }

        private JSpinner eventToSpinner(AWTEvent e) {
            Object src = e.getSource();
            while (src instanceof Component && !(src instanceof JSpinner)) {
                src = ((Component)src).getParent();
            }
            return src instanceof JSpinner ? (JSpinner)src : null;
        }

        public void actionPerformed(ActionEvent e) {
            if (this.spinner != null) {
                try {
                    Object value;
                    this.spinner.commitEdit();
                    Object object = value = this.isNext ? this.spinner.getNextValue() : this.spinner.getPreviousValue();
                    if (value != null) {
                        this.spinner.setValue(value);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        public void mousePressed(MouseEvent e) {
            if (SwingUtilities.isLeftMouseButton(e) && e.getComponent().isEnabled()) {
                this.spinner = this.eventToSpinner(e);
                this.autoRepeatTimer.start();
            }
        }

        public void mouseReleased(MouseEvent e) {
            this.autoRepeatTimer.stop();
            this.spinner = null;
        }
    }
}

