/*
 * Decompiled with CFR 0.152.
 */
package com.shfarr.ui.plaf.fh;

import com.shfarr.ui.GraphicsUtils;
import com.shfarr.ui.plaf.fh.borders.FHMultiMatrixBorder;
import com.shfarr.ui.plaf.fh.borders.FhMatrixBorder;
import com.shfarr.ui.plaf.fh.textures.Texture;
import com.shfarr.ui.plaf.fh.theme.ThemeManager;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTabbedPaneUI;

public class FhTabbedPaneUI
extends BasicTabbedPaneUI {
    protected int lastTab0y = -9999;

    public static ComponentUI createUI(JComponent c) {
        return new FhTabbedPaneUI();
    }

    public void paint(Graphics g, JComponent c) {
        ThemeManager.instance().probeAntialiasing(g);
        super.paint(g, c);
        if (this.tabPane.getSelectedIndex() != -1) {
            this.paintTab(g, this.tabPane.getTabPlacement(), this.rects, this.tabPane.getSelectedIndex(), new Rectangle(), new Rectangle());
        }
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        c.setOpaque(true);
        c.setBorder((Border)UIManager.getDefaults().get("TabbedPane.border"));
    }

    protected void paintTabArea(Graphics g, int tabPlacement, int selectedIndex) {
        int tabCount = this.tabPane.getTabCount();
        int tah = this.calculateTabAreaHeight(tabPlacement, this.runCount, this.maxTabHeight);
        int taw = this.calculateTabAreaWidth(tabPlacement, this.runCount, this.maxTabWidth);
        Insets ins = this.tabPane.getInsets();
        Rectangle iconRect = new Rectangle();
        Rectangle textRect = new Rectangle();
        Rectangle clipRect = g.getClipBounds();
        g.setColor(UIManager.getColor("TabbedPane.tabAreaBackground"));
        switch (tabPlacement) {
            case 2: {
                g.fillRect(ins.left, ins.top, taw, this.tabPane.getSize().height);
                break;
            }
            case 4: {
                g.fillRect(this.tabPane.getSize().width - ins.right - taw, ins.top, taw, this.tabPane.getSize().height);
                break;
            }
            case 3: {
                g.fillRect(ins.left, this.tabPane.getSize().height - ins.bottom - tah, this.tabPane.getSize().width, tah);
                break;
            }
            default: {
                g.fillRect(ins.left, ins.top, this.tabPane.getSize().width, tah);
            }
        }
        int i = this.runCount - 1;
        while (i >= 0) {
            int start = this.tabRuns[i];
            int next = this.tabRuns[i == this.runCount - 1 ? 0 : i + 1];
            int end = next != 0 ? next - 1 : tabCount - 1;
            int j = start;
            while (j <= end) {
                if (this.rects[j].intersects(clipRect)) {
                    this.paintTab(g, tabPlacement, this.rects, j, iconRect, textRect);
                }
                ++j;
            }
            --i;
        }
    }

    protected Insets getContentBorderInsets(int tabPlacement) {
        Border b = UIManager.getDefaults().getBorder("TabbedPane.contentBorder");
        return b == null ? new Insets(0, 0, 0, 0) : b.getBorderInsets(this.tabPane);
    }

    protected void paintContentBorder(Graphics g, int tabPlacement, int selectedIndex) {
        Insets ins = this.tabPane.getInsets();
        Dimension dim = this.tabPane.getSize();
        int x = ins.left;
        int y = ins.top;
        int tah = this.calculateTabAreaHeight(tabPlacement, this.runCount, this.maxTabHeight);
        int taw = this.calculateTabAreaWidth(tabPlacement, this.runCount, this.maxTabWidth);
        int width = dim.width - x - ins.right;
        int height = dim.height - y - ins.bottom;
        switch (tabPlacement) {
            case 2: {
                width -= (x += taw) - ins.left;
                break;
            }
            case 4: {
                width -= taw;
                break;
            }
            case 3: {
                height -= tah;
                break;
            }
            case 1: {
                height -= (y += tah) - ins.top;
            }
        }
        Border b = UIManager.getDefaults().getBorder("TabbedPane.contentBorder");
        if (b instanceof FhMatrixBorder && ThemeManager.instance().getCurrentTheme().metaPalette().get("TabContent border rotates").equals(Boolean.TRUE)) {
            switch (tabPlacement) {
                case 2: {
                    b = ((FhMatrixBorder)b).deriveBorder(3);
                    break;
                }
                case 4: {
                    b = ((FhMatrixBorder)b).deriveBorder(1);
                    break;
                }
                case 3: {
                    b = ((FhMatrixBorder)b).deriveBorder(2);
                }
            }
        }
        if (b != null) {
            b.paintBorder(this.tabPane, g, x, y, width, height);
        }
    }

    protected void paintTabBorder(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
        int shift = 1;
        Insets ins = this.getContentBorderInsets(0);
        Border mb = null;
        switch (tabPlacement) {
            case 2: {
                w += (shift += ins.left);
                mb = UIManager.getBorder("TabbedPane.tabLeft");
                if (mb instanceof FHMultiMatrixBorder) {
                    mb = ((FHMultiMatrixBorder)mb).deriveBorder(1);
                    if (isSelected && this.tabPane.hasFocus()) {
                        ((FHMultiMatrixBorder)mb).selectMatrix("focused");
                    } else if (isSelected) {
                        ((FHMultiMatrixBorder)mb).selectMatrix("selected");
                    } else {
                        ((FHMultiMatrixBorder)mb).selectMatrix(null);
                    }
                }
                if (mb == null) break;
                mb.paintBorder(this.tabPane, g, x, y, h, w);
                break;
            }
            case 4: {
                w += (shift += ins.right);
                x -= shift;
                mb = UIManager.getBorder("TabbedPane.tabRight");
                if (mb instanceof FHMultiMatrixBorder) {
                    if (isSelected && this.tabPane.hasFocus()) {
                        ((FHMultiMatrixBorder)mb).selectMatrix("focused");
                    } else if (isSelected) {
                        ((FHMultiMatrixBorder)mb).selectMatrix("selected");
                    } else {
                        ((FHMultiMatrixBorder)mb).selectMatrix(null);
                    }
                }
                if (mb == null) break;
                mb.paintBorder(this.tabPane, g, x, y, w, h);
                break;
            }
            case 3: {
                h += (shift += ins.bottom);
                y -= shift;
                mb = UIManager.getBorder("TabbedPane.tabBottom");
                if (mb instanceof FHMultiMatrixBorder) {
                    if (isSelected && this.tabPane.hasFocus()) {
                        ((FHMultiMatrixBorder)mb).selectMatrix("focused");
                    } else if (isSelected) {
                        ((FHMultiMatrixBorder)mb).selectMatrix("selected");
                    } else {
                        ((FHMultiMatrixBorder)mb).selectMatrix(null);
                    }
                }
                if (mb == null) break;
                mb.paintBorder(this.tabPane, g, x, y, w, h);
                break;
            }
            default: {
                h += (shift += ins.top);
                mb = UIManager.getBorder("TabbedPane.tabTop");
                if (mb instanceof FHMultiMatrixBorder) {
                    if (isSelected && this.tabPane.hasFocus()) {
                        ((FHMultiMatrixBorder)mb).selectMatrix("focused");
                    } else if (isSelected) {
                        ((FHMultiMatrixBorder)mb).selectMatrix("selected");
                    } else {
                        ((FHMultiMatrixBorder)mb).selectMatrix(null);
                    }
                }
                if (mb == null) break;
                mb.paintBorder(this.tabPane, g, x, y, w, h);
            }
        }
    }

    protected void paintTabBackground(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
        int shift = (Integer)UIManager.getDefaults().get("TabbedPane.selectedTabShift");
        if (isSelected) {
            g.setColor(UIManager.getColor("TabbedPane.selectedBackground"));
        } else {
            g.setColor(UIManager.getColor("TabbedPane.unselectedBackground"));
        }
        switch (tabPlacement) {
            case 2: {
                g.fillRect(x, y, h, w += shift);
                if (!isSelected) break;
                this.paintTexture(g, tabPlacement, x, y, h, w);
                break;
            }
            case 4: {
                g.fillRect(x -= shift, y, w += shift, h);
                if (!isSelected) break;
                this.paintTexture(g, tabPlacement, x, y, w, h);
                break;
            }
            case 3: {
                g.fillRect(x, y -= shift, w, h += shift);
                if (!isSelected) break;
                this.paintTexture(g, tabPlacement, x, y, w, h);
                break;
            }
            default: {
                g.fillRect(x, y, w, h += shift);
                if (!isSelected) break;
                this.paintTexture(g, tabPlacement, x, y, w, h);
            }
        }
        g.setColor(this.tabPane.getForegroundAt(tabIndex));
    }

    private void paintTexture(Graphics g, int tabPlacement, int x, int y, int w, int h) {
        Texture texture = (Texture)UIManager.getDefaults().get("TabbedPane.tabTexture");
        if (texture != null && ThemeManager.instance().probeSmallTextures()) {
            texture.apply(new Rectangle(x, y, w, h), (Graphics2D)g, this.tabPane);
        }
    }

    protected void paintTab(Graphics g, int tabPlacement, Rectangle[] rects, int tabIndex, Rectangle iconRect, Rectangle textRect) {
        if (tabPlacement == 2) {
            BufferedImage b_img = new BufferedImage(rects[tabIndex].height, rects[tabIndex].width + this.getContentBorderInsets((int)tabPlacement).left, 2);
            Graphics2D imgc = b_img.createGraphics();
            ((Graphics)imgc).translate(-rects[tabIndex].x, -rects[tabIndex].y);
            imgc.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            super.paintTab(imgc, tabPlacement, rects, tabIndex, iconRect, textRect);
            b_img = GraphicsUtils.rotate90(b_img, 1);
            g.drawImage(b_img, rects[tabIndex].x, rects[tabIndex].y, null);
        } else {
            super.paintTab(g, tabPlacement, rects, tabIndex, iconRect, textRect);
        }
    }

    protected void layoutLabel(int tabPlacement, FontMetrics metrics, int tabIndex, String title, Icon icon, Rectangle tabRect, Rectangle iconRect, Rectangle textRect, boolean isSelected) {
        if (tabPlacement == 2) {
            Rectangle tabRect_mod = new Rectangle(tabRect.x, tabRect.y, tabRect.height, tabRect.width);
            super.layoutLabel(tabPlacement, metrics, tabIndex, title, icon, tabRect_mod, iconRect, textRect, isSelected);
        } else {
            super.layoutLabel(tabPlacement, metrics, tabIndex, title, icon, tabRect, iconRect, textRect, isSelected);
        }
    }

    private boolean scrollableTabLayoutEnabled() {
        return this.tabPane.getTabLayoutPolicy() == 1;
    }

    protected int getTabLabelShiftY(int tabPlacement, int tabIndex, boolean isSelected) {
        int shift = (Integer)UIManager.getDefaults().get("TabbedPane.selectedTabShift");
        switch (tabPlacement) {
            case 2: {
                return 0;
            }
            case 4: {
                return 0;
            }
            case 3: {
                return -shift / 2;
            }
        }
        return shift / 2;
    }

    protected int getTabLabelShiftX(int tabPlacement, int tabIndex, boolean isSelected) {
        int shift = (Integer)UIManager.getDefaults().get("TabbedPane.selectedTabShift");
        switch (tabPlacement) {
            case 2: {
                return shift / 2;
            }
            case 4: {
                return -shift / 2;
            }
            case 3: {
                return 0;
            }
        }
        return 0;
    }

    protected void paintFocusIndicator(Graphics g, int tabPlacement, Rectangle[] rects, int tabIndex, Rectangle iconRect, Rectangle textRect, boolean isSelected) {
    }

    protected int getTabRunIndent(int tabPlacement, int run) {
        return -1;
    }

    protected int calculateTabWidth(int tabPlacement, int tabIndex, FontMetrics metrics) {
        if (tabPlacement == 2) {
            return super.calculateTabHeight(tabPlacement, tabIndex, metrics.getHeight());
        }
        return super.calculateTabWidth(tabPlacement, tabIndex, metrics);
    }

    protected int calculateTabHeight(int tabPlacement, int tabIndex, int fontHeight) {
        if (tabPlacement == 2) {
            return super.calculateTabWidth(tabPlacement, tabIndex, this.getFontMetrics());
        }
        return super.calculateTabHeight(tabPlacement, tabIndex, fontHeight);
    }
}

