/*
 * Decompiled with CFR 0.152.
 */
package com.shfarr.ui.plaf.fh;

import com.shfarr.ui.GraphicsUtils;
import com.shfarr.ui.plaf.fh.ext.FhTableCellRenderer;
import com.shfarr.ui.plaf.fh.ext.FhTableHeader;
import com.shfarr.ui.plaf.fh.ext.FhTableHeaderCellRenderer;
import com.shfarr.ui.plaf.fh.theme.ThemeManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTableUI;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class FhTableUI
extends BasicTableUI {
    protected BufferedImage draggedArea = null;
    static /* synthetic */ Class class$0;

    public static ComponentUI createUI(JComponent c) {
        return new FhTableUI();
    }

    protected BufferedImage getDraggedArea(int rMin, int rMax, int col) {
        if (this.draggedArea == null) {
            Rectangle rTop = this.table.getCellRect(rMin, col, true);
            Rectangle rBottom = this.table.getCellRect(rMax, col, true);
            this.draggedArea = new BufferedImage(rTop.width, rTop.height + rBottom.height + rBottom.y, 2);
            Graphics2D g = this.draggedArea.createGraphics();
            g.setColor(this.table.getBackground());
            g.fillRect(0, 0, this.draggedArea.getWidth(), this.draggedArea.getHeight());
            int row = rMin;
            while (row <= rMax) {
                Rectangle cellRect = this.table.getCellRect(row, col, false);
                cellRect.x = 1;
                this.paintCell(g, cellRect, row, col);
                ++row;
            }
            g.setColor(new Color(GraphicsUtils.darker(this.table.getGridColor().getRGB(), 0.1)));
            if (this.table.getShowHorizontalLines()) {
                int y = rTop.y;
                int row2 = rMin;
                while (row2 <= rMax) {
                    GraphicsUtils.drawDashedLine(0.0, (y += this.table.getRowHeight()) - 1, this.draggedArea.getWidth() - 1, y - 1, new boolean[]{true, true}, g);
                    ++row2;
                }
            }
            if (this.table.getShowVerticalLines()) {
                int x = 0;
                int column = 0;
                while (column < 2) {
                    GraphicsUtils.drawDashedLine(x, 0.0, x, this.draggedArea.getHeight() - 1, new boolean[]{true, true}, g);
                    x += this.draggedArea.getWidth() - 1;
                    ++column;
                }
            }
            int i = 0;
            while (i < this.draggedArea.getWidth()) {
                int k = 0;
                while (k < this.draggedArea.getHeight()) {
                    float factor = 0.7f;
                    this.draggedArea.setRGB(i, k, this.draggedArea.getRGB(i, k) & (0xFFFFFF | (int)(255.0f * factor) << 24));
                    ++k;
                }
                ++i;
            }
        }
        return this.draggedArea;
    }

    public void installDefaults() {
        Class<?> clazz;
        super.installDefaults();
        if (!(this.table.getTableHeader() instanceof FhTableHeader)) {
            this.table.setTableHeader(new FhTableHeader(this.table.getTableHeader().getColumnModel()));
        }
        if ((clazz = class$0) == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.Object");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.table.setDefaultRenderer(clazz, new FhTableCellRenderer());
        this.table.getTableHeader().setDefaultRenderer(new FhTableHeaderCellRenderer());
    }

    public void paint(Graphics g, JComponent c) {
        ThemeManager.instance().probeAntialiasing(g);
        if (this.table.getRowCount() <= 0 || this.table.getColumnCount() <= 0) {
            return;
        }
        Rectangle clip = g.getClipBounds();
        Point minLocation = clip.getLocation();
        Point maxLocation = new Point(clip.x + clip.width - 1, clip.y + clip.height - 1);
        int rMin = this.table.rowAtPoint(minLocation);
        int rMax = this.table.rowAtPoint(maxLocation);
        if (rMin == -1) {
            rMin = 0;
        }
        if (rMax == -1) {
            rMax = this.table.getRowCount() - 1;
        }
        int cMin = this.table.columnAtPoint(minLocation);
        int cMax = this.table.columnAtPoint(maxLocation);
        if (cMin == -1) {
            cMin = 0;
        }
        if (cMax == -1) {
            cMax = this.table.getColumnCount() - 1;
        }
        this.paintCells(g, rMin, rMax, cMin, cMax);
        this.paintGrid(g, rMin, rMax, cMin, cMax);
    }

    private void paintCell(Graphics g, Rectangle cellRect, int row, int column) {
        if (this.table.isEditing() && this.table.getEditingRow() == row && this.table.getEditingColumn() == column) {
            Component component = this.table.getEditorComponent();
            component.setBounds(cellRect);
            component.validate();
        } else {
            TableCellRenderer renderer = this.table.getCellRenderer(row, column);
            Component component = this.table.prepareRenderer(renderer, row, column);
            this.rendererPane.paintComponent(g, component, this.table, cellRect.x, cellRect.y, cellRect.width, cellRect.height, true);
        }
    }

    private void paintCells(Graphics g, int rMin, int rMax, int cMin, int cMax) {
        JTableHeader header = this.table.getTableHeader();
        TableColumn draggedColumn = header == null ? null : header.getDraggedColumn();
        TableColumnModel cm = this.table.getColumnModel();
        int columnMargin = cm.getColumnMargin();
        int row = rMin;
        while (row <= rMax) {
            Rectangle cellRect = this.table.getCellRect(row, cMin, false);
            int column = cMin;
            while (column <= cMax) {
                TableColumn aColumn = cm.getColumn(column);
                int columnWidth = aColumn.getWidth();
                cellRect.width = columnWidth - columnMargin;
                if (aColumn != draggedColumn) {
                    this.paintCell(g, cellRect, row, column);
                }
                cellRect.x += columnWidth;
                ++column;
            }
            ++row;
        }
        if (draggedColumn != null) {
            this.paintDraggedArea(g, rMin, rMax, draggedColumn, header.getDraggedDistance());
        } else {
            this.draggedArea = null;
        }
        this.rendererPane.removeAll();
    }

    private void paintDraggedArea(Graphics g, int rMin, int rMax, TableColumn draggedColumn, int distance) {
        int draggedColumnIndex = this.viewIndexForColumn(draggedColumn);
        Rectangle minCell = this.table.getCellRect(rMin, draggedColumnIndex, true);
        Rectangle maxCell = this.table.getCellRect(rMax, draggedColumnIndex, true);
        Rectangle vacatedColumnRect = minCell.union(maxCell);
        g.setColor(this.table.getParent().getBackground());
        g.fillRect(vacatedColumnRect.x, vacatedColumnRect.y, vacatedColumnRect.width, vacatedColumnRect.height);
        g.drawImage(this.getDraggedArea(rMin, rMax, draggedColumnIndex), vacatedColumnRect.x, 0, null);
        Rectangle cellRect = this.table.getCellRect(0, draggedColumnIndex, false);
        g.drawImage(this.getDraggedArea(rMin, rMax, draggedColumnIndex), cellRect.x + distance, 0, null);
    }

    private void paintGrid(Graphics g, int rMin, int rMax, int cMin, int cMax) {
        g.setColor(this.table.getGridColor());
        Rectangle minCell = this.table.getCellRect(rMin, cMin, true);
        Rectangle maxCell = this.table.getCellRect(rMax, cMax, true);
        if (this.table.getShowHorizontalLines()) {
            int tableWidth = maxCell.x + maxCell.width;
            int y = minCell.y;
            int row = rMin;
            while (row <= rMax) {
                boolean[] blArray = new boolean[4];
                blArray[0] = true;
                blArray[1] = true;
                blArray[2] = true;
                GraphicsUtils.drawDashedLine(0.0, (y += this.table.getRowHeight()) - 1, tableWidth - 1, y - 1, blArray, g);
                ++row;
            }
        }
        if (this.table.getShowVerticalLines()) {
            TableColumnModel cm = this.table.getColumnModel();
            int tableHeight = maxCell.y + maxCell.height;
            int x = minCell.x;
            int column = cMin;
            while (column <= cMax) {
                boolean[] blArray = new boolean[4];
                blArray[0] = true;
                blArray[1] = true;
                blArray[2] = true;
                GraphicsUtils.drawDashedLine((x += cm.getColumn(column).getWidth()) - 1, 0.0, x - 1, tableHeight - 1, blArray, g);
                ++column;
            }
        }
    }

    private int viewIndexForColumn(TableColumn aColumn) {
        TableColumnModel cm = this.table.getColumnModel();
        int column = 0;
        while (column < cm.getColumnCount()) {
            if (cm.getColumn(column) == aColumn) {
                return column;
            }
            ++column;
        }
        return -1;
    }
}

