/*
 * Decompiled with CFR 0.152.
 */
package com.shfarr.ui.plaf.fh;

import com.shfarr.ui.layouts.QueueLayout;
import com.shfarr.ui.plaf.fh.borders.FHMultiMatrixBorder;
import com.shfarr.ui.plaf.fh.textures.Texture;
import com.shfarr.ui.plaf.fh.theme.ThemeManager;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Hashtable;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicToolBarUI;

public class FhToolBarUI
extends BasicToolBarUI {
    public static ComponentUI createUI(JComponent cmp) {
        return new FhToolBarUI();
    }

    public void installUI(JComponent jc) {
        super.installUI(jc);
        jc.addPropertyChangeListener(new FhPropertyChangeHandler());
        jc.setLayout(new FhToolBarLayoutManager());
    }

    protected void installRolloverBorders(JComponent c) {
        Component[] components = c.getComponents();
        int i = 0;
        while (i < components.length) {
            this.setBorderToRollover(components[i]);
            ++i;
        }
    }

    protected void installNonRolloverBorders(JComponent c) {
        Component[] components = c.getComponents();
        int i = 0;
        while (i < components.length) {
            this.setBorderToNonRollover(components[i]);
            ++i;
        }
    }

    protected void setBorderToRollover(Component c) {
        if (c instanceof AbstractButton) {
            ((AbstractButton)c).setRolloverEnabled(true);
        }
    }

    protected void setBorderToNonRollover(Component c) {
        if (c instanceof AbstractButton) {
            ((AbstractButton)c).setRolloverEnabled(false);
        }
    }

    public void paint(Graphics g, JComponent c) {
        ThemeManager.instance().probeAntialiasing(g);
        if (c.getBorder() instanceof FHMultiMatrixBorder) {
            if (((JToolBar)c).getOrientation() == 0) {
                ((FHMultiMatrixBorder)c.getBorder()).selectMatrix("normal");
            } else {
                ((FHMultiMatrixBorder)c.getBorder()).selectMatrix("vertical");
            }
        }
        super.paint(g, c);
        Insets ins = c.getInsets();
        Texture texture = (Texture)UIManager.getDefaults().get("ToolBar.texture");
        if (texture != null && ThemeManager.instance().probeSmallTextures()) {
            texture.apply(new Rectangle(ins.left, ins.top, c.getSize().width - ins.left - ins.right, c.getSize().height - ins.top - ins.bottom), (Graphics2D)g, c);
        }
        if ((texture = (Texture)UIManager.getDefaults().get("Toolbar.thumbTexture")) != null && ThemeManager.instance().probeSmallTextures()) {
            if (((JToolBar)c).getOrientation() == 0) {
                texture.apply(new Rectangle(ins.left, ins.top, 13, c.getSize().height - ins.top - ins.bottom), (Graphics2D)g, c);
            } else {
                texture.apply(new Rectangle(ins.left, ins.top, c.getSize().width - ins.left - ins.right, 14), (Graphics2D)g, c);
            }
        }
    }

    protected class FhPropertyChangeHandler
    implements PropertyChangeListener {
        protected FhPropertyChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent e) {
            int i = 0;
            while (i < ((Container)e.getSource()).getComponentCount()) {
                if (((Container)e.getSource()).getComponent(i) instanceof JSeparator) {
                    ((JSeparator)((Container)e.getSource()).getComponent(i)).setOrientation(((JToolBar)e.getSource()).getOrientation() == 0 ? 1 : 0);
                }
                ++i;
            }
        }
    }

    public class FhToolBarLayoutManager
    extends QueueLayout {
        protected Hashtable popupHash;

        public FhToolBarLayoutManager() {
            super(2, 100, 3);
            this.popupHash = null;
            this.popupHash = new Hashtable();
        }

        public JPopupMenu createMorePopup(Container c, int index) {
            JPopupMenu menu = new JPopupMenu();
            menu.setLayout(new QueueLayout());
            Component[] cps = c.getComponents();
            int i = index;
            while (i < cps.length && index >= 0) {
                if (cps[i].isVisible()) {
                    Border b = ((JComponent)cps[i]).getBorder();
                    c.remove(cps[i]);
                    menu.add(cps[i]);
                    ((JComponent)cps[i]).setBorder(b);
                }
                ++i;
            }
            this.popupHash.put(c, menu);
            return menu;
        }

        /*
         * Unable to fully structure code
         */
        protected int getBreakIndex(Container c) {
            block6: {
                cps = c.getComponents();
                d = this.getMaxSize(c);
                cs = this.usableSize(c);
                index = cps.length - 1;
                if (((JToolBar)c).getOrientation() != 0) ** GOTO lbl17
                while (d.width > cs.width) {
                    if (!cps[index].isVisible()) continue;
                    d.width -= cps[index].getPreferredSize().width;
                    --index;
                }
                if (index + 1 >= cps.length || d.width <= cs.width - 20) break block6;
                --index;
                break block6;
lbl-1000:
                // 1 sources

                {
                    if (!cps[index].isVisible()) continue;
                    d.height -= cps[index].getPreferredSize().height;
                    --index;
lbl17:
                    // 3 sources

                    ** while (d.height > cs.height)
                }
lbl18:
                // 1 sources

                if (index + 1 < cps.length && d.height > cs.height - 20) {
                    --index;
                }
            }
            return index + 1;
        }

        protected Dimension getMaxSize(Container c) {
            Component[] cps = c.getComponents();
            Dimension d = new Dimension(0, 0);
            int i = 0;
            while (i < cps.length) {
                if (cps[i].isVisible()) {
                    if (((JToolBar)c).getOrientation() == 0) {
                        d.width += cps[i].getPreferredSize().width;
                        if (!(cps[i] instanceof JToolBar.Separator)) {
                            d.height = Math.max(cps[i].getPreferredSize().height, d.height);
                        }
                    } else {
                        d.width = Math.max(cps[i].getPreferredSize().width, d.width);
                        if (!(cps[i] instanceof JToolBar.Separator)) {
                            d.height += cps[i].getPreferredSize().height;
                        }
                    }
                }
                ++i;
            }
            return d;
        }

        protected void performLayout(Container parent) {
            Component[] cps = parent.getComponents();
            Insets ins = parent.getInsets();
            Dimension cPrefSize = null;
            Dimension pSize = parent.getSize();
            int offset = 0;
            int startOffset = (this.orientation == 0 ? ins.top : ins.left) + 16;
            int availSpace = (this.orientation == 0 ? pSize.height - ins.bottom - ins.top : pSize.width - ins.right - ins.left) - 16;
            int endOffset = startOffset + availSpace + this.getGap();
            int mobileVal = 0;
            int i = 0;
            while (i < cps.length) {
                if (cps[i].isVisible()) {
                    cPrefSize = cps[i].getPreferredSize() != null ? cps[i].getPreferredSize() : new Dimension(20, 20);
                    int n = mobileVal = this.orientation == 0 ? cPrefSize.height : cPrefSize.width;
                    if (QueueLayout.BEGIN.equals(this.getConstraintsFor(cps[i]))) {
                        offset = startOffset;
                        startOffset += mobileVal + this.getGap();
                    } else {
                        offset = endOffset -= mobileVal + this.getGap();
                    }
                    int x = ins.left + (pSize.width - ins.left - ins.right - cPrefSize.width) / 2;
                    int y = ins.top + (pSize.height - ins.top - ins.bottom - cPrefSize.height) / 2;
                    int w = cPrefSize.width;
                    int h = cPrefSize.height;
                    if (this.alignment == 2) {
                        x = ins.left;
                        y = ins.top;
                        w = pSize.width - ins.right - ins.left;
                        h = pSize.height - ins.top - ins.bottom;
                    }
                    if (cps[i] instanceof JSeparator) {
                        x = ins.left + 2;
                        y = ins.top + 2;
                        w = pSize.width - ins.right - ins.left - 4;
                        h = pSize.height - ins.top - ins.bottom - 4;
                    }
                    if (this.orientation == 0) {
                        cps[i].setBounds(x, offset, w, mobileVal);
                    } else {
                        cps[i].setBounds(offset, y, mobileVal, h);
                    }
                    availSpace -= this.getGap() + mobileVal;
                }
                ++i;
            }
        }

        public void layoutContainer(Container parent) {
            if (parent instanceof JToolBar) {
                this.orientation = ((JToolBar)parent).getOrientation() == 0 ? 100 : 0;
            }
            super.layoutContainer(parent);
        }

        public Dimension preferredLayoutSize(Container parent) {
            int preferredOrientation = this.getOrientation();
            if (parent instanceof JToolBar) {
                this.orientation = ((JToolBar)parent).getOrientation() == 0 ? 100 : 0;
            }
            Dimension d = super.preferredLayoutSize(parent);
            if (parent instanceof JToolBar) {
                if (((JToolBar)parent).getOrientation() == 0) {
                    d.width += 16;
                } else {
                    d.height += 16;
                }
            }
            this.orientation = preferredOrientation;
            return d;
        }

        protected void showPopup(Container src) {
            JPopupMenu popup = (JPopupMenu)this.popupHash.get(src);
            Point point = null;
            JRootPane rp = SwingUtilities.getRootPane(src);
            point = ((JToolBar)src).getOrientation() == 0 ? new Point(src.getSize().width - popup.getPreferredSize().width - 1, rp.getSize().height > src.getLocation().y + popup.getPreferredSize().height ? src.getSize().height - 1 : -popup.getPreferredSize().height) : new Point(rp.getSize().width > src.getLocation().x + popup.getPreferredSize().width ? src.getSize().width - 1 : -popup.getPreferredSize().width, src.getSize().height - popup.getPreferredSize().height - 1);
            point = SwingUtilities.convertPoint(src, point, rp);
            popup.show(rp, point.x, point.y);
        }

        protected Dimension usableSize(Container c) {
            Dimension d = c.getSize();
            Insets ins = c.getInsets() != null ? c.getInsets() : new Insets(0, 0, 0, 0);
            d.width -= ins.left + ins.right;
            d.height -= ins.top + ins.bottom;
            return d;
        }
    }
}

