/*
 * Decompiled with CFR 0.152.
 */
package com.shfarr.ui.plaf.fh.borders;

import com.shfarr.ui.plaf.fh.borders.FhMatrixBorder;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.plaf.UIResource;

public class FHMultiMatrixBorder
extends AbstractBorder
implements UIResource {
    private TreeMap map = new TreeMap();
    private Object key = null;

    protected FHMultiMatrixBorder() {
        this.key = "normal";
    }

    public FHMultiMatrixBorder(String[] keys, Object[] matrices) {
        int count = 0;
        int i = 0;
        while (i < keys.length) {
            if (matrices[i] != null) {
                this.map.put(keys[i], matrices[i]);
                ++count;
            }
            ++i;
        }
        if (count == 0) {
            throw new Error("Empty border list error");
        }
        this.key = "normal";
    }

    public FHMultiMatrixBorder deriveBorder(int rotation) {
        FHMultiMatrixBorder mmb = new FHMultiMatrixBorder();
        Iterator iter = this.map.keySet().iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            mmb.map.put(key, this.getBorder(key).deriveBorder(rotation));
        }
        return mmb;
    }

    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        Border b;
        if (this.key == null) {
            this.key = "normal";
        }
        if ((b = (Border)this.map.get(this.key)) == null) {
            b = (Border)this.map.get("normal");
        }
        b.paintBorder(c, g, x, y, width, height);
    }

    public Insets getBorderInsets(Component c) {
        Border b = (Border)this.map.get(this.key);
        if (b == null) {
            b = (Border)this.map.get("normal");
        }
        return b.getBorderInsets(c);
    }

    public Insets getBorderInsets(Component c, Insets insets) {
        Insets ins = this.getBorderInsets(c);
        insets.top = ins.top;
        insets.left = ins.left;
        insets.bottom = ins.bottom;
        insets.right = ins.right;
        return insets;
    }

    public void selectMatrix(Object key) {
        if (key == null) {
            key = "normal";
        }
        this.key = key;
    }

    public Set keys() {
        return this.map.keySet();
    }

    public FhMatrixBorder getBorder(Object key) {
        return (FhMatrixBorder)this.map.get(key);
    }
}

