/*
 * Decompiled with CFR 0.152.
 */
package com.shfarr.ui.plaf.fh.borders;

import com.shfarr.ui.GraphicsUtils;
import com.shfarr.ui.plaf.fh.theme.ThemeManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import javax.swing.border.AbstractBorder;
import javax.swing.plaf.UIResource;

public class FhMatrixBorder
extends AbstractBorder
implements UIResource {
    protected String[][] matrix = null;
    protected Insets insets;
    protected boolean[] dash = null;
    protected boolean painting = true;
    protected int centerX = -1;
    protected int centerY = -1;
    protected BufferedImage matrixImage;
    protected BufferedImage topBuffer;
    protected BufferedImage bottomBuffer;
    protected BufferedImage leftBuffer;
    protected BufferedImage rightBuffer;

    protected FhMatrixBorder() {
    }

    public FhMatrixBorder(String[][] customMatrix) throws NullPointerException {
        if (customMatrix == null) {
            throw new NullPointerException("Empty matrix");
        }
        this.setMatrix(customMatrix);
    }

    public Insets getBorderInsets(Component c) {
        if (!this.isPainting()) {
            return new Insets(0, 0, 0, 0);
        }
        if (this.insets == null) {
            this.insets = new Insets(this.centerY, this.centerX, this.matrixImage.getHeight() - this.centerY - 1, this.matrixImage.getWidth() - this.centerX - 1);
        }
        return this.insets;
    }

    public Insets getBorderInsets(Component c, Insets insets) {
        Insets ins = this.getBorderInsets(c);
        insets.top = ins.top;
        insets.left = ins.left;
        insets.bottom = ins.bottom;
        insets.right = ins.right;
        return insets;
    }

    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        BufferedImage b;
        int i;
        BufferedImage a;
        Graphics2D ag;
        Rectangle clip = g.getClipBounds();
        if (this.centerX > 0 && this.centerY > 0) {
            g.setClip(x, y, this.centerX, this.centerY);
            if (clip != null) {
                g.setClip(clip.createIntersection(g.getClipBounds()));
            }
            if (g.getClipBounds().width > 0 && g.getClipBounds().height > 0) {
                g.drawImage(this.matrixImage, x, y, null);
            }
        }
        if (this.centerX > 0 && this.matrixImage.getHeight() - this.centerY - 1 > 0) {
            g.setClip(x, y + height - (this.matrixImage.getHeight() - this.centerY - 1), this.centerX, this.matrixImage.getHeight() - this.centerY - 1);
            if (clip != null) {
                g.setClip(clip.createIntersection(g.getClipBounds()));
            }
            if (g.getClipBounds().width > 0 && g.getClipBounds().height > 0) {
                g.drawImage(this.matrixImage, x, y + height - this.matrixImage.getHeight(), null);
            }
        }
        if (this.matrixImage.getWidth() - this.centerX - 1 > 0 && this.centerY > 0) {
            g.setClip(x + width - (this.matrixImage.getWidth() - this.centerX - 1), y, this.matrixImage.getWidth() - this.centerX - 1, this.centerY);
            if (clip != null) {
                g.setClip(clip.createIntersection(g.getClipBounds()));
            }
            if (g.getClipBounds().width > 0 && g.getClipBounds().height > 0) {
                g.drawImage(this.matrixImage, x + width - this.matrixImage.getWidth(), y, null);
            }
        }
        if (this.matrixImage.getWidth() - this.centerX - 1 > 0 && this.matrixImage.getHeight() - this.centerY - 1 > 0) {
            g.setClip(x + width - (this.matrixImage.getWidth() - this.centerX - 1), y + height - (this.matrixImage.getHeight() - this.centerY - 1), this.matrixImage.getWidth() - this.centerX - 1, this.matrixImage.getHeight() - this.centerY - 1);
            if (clip != null) {
                g.setClip(clip.createIntersection(g.getClipBounds()));
            }
            if (g.getClipBounds().width > 0 && g.getClipBounds().height > 0) {
                g.drawImage(this.matrixImage, x + width - this.matrixImage.getWidth(), y + height - this.matrixImage.getHeight(), null);
            }
        }
        if (this.leftBuffer == null && this.rightBuffer == null) {
            if (this.centerX > 0) {
                this.leftBuffer = new BufferedImage(this.centerX, 100, 2);
                ag = this.leftBuffer.createGraphics();
                a = this.matrixImage.getSubimage(0, this.centerY, this.centerX, 1);
                i = 0;
                while (i < 100) {
                    ag.drawImage((Image)a, 0, i, null);
                    ++i;
                }
            }
            if (this.matrixImage.getWidth() - this.centerX - 1 > 0) {
                this.rightBuffer = new BufferedImage(this.matrixImage.getWidth() - this.centerX - 1, 100, 2);
                ag = this.rightBuffer.createGraphics();
                b = this.matrixImage.getSubimage(this.centerX + 1, this.centerY, this.matrixImage.getWidth() - this.centerX - 1, 1);
                i = 0;
                while (i < 100) {
                    ag.drawImage((Image)b, 0, i, null);
                    ++i;
                }
            }
        }
        if (this.topBuffer == null && this.bottomBuffer == null) {
            if (this.centerY > 0) {
                this.topBuffer = new BufferedImage(100, this.centerY, 2);
                ag = this.topBuffer.createGraphics();
                a = this.matrixImage.getSubimage(this.centerX, 0, 1, this.centerY);
                i = 0;
                while (i < 100) {
                    ag.drawImage((Image)a, i, 0, null);
                    ++i;
                }
            }
            if (this.matrixImage.getHeight() - this.centerY - 1 > 0) {
                this.bottomBuffer = new BufferedImage(100, this.matrixImage.getHeight() - this.centerY - 1, 2);
                ag = this.bottomBuffer.createGraphics();
                b = this.matrixImage.getSubimage(this.centerX, this.centerY + 1, 1, this.matrixImage.getHeight() - this.centerY - 1);
                i = 0;
                while (i < 100) {
                    ag.drawImage((Image)b, i, 0, null);
                    ++i;
                }
            }
        }
        if (this.topBuffer != null) {
            g.setClip(x + this.centerX, y, width - (this.matrixImage.getWidth() - 1), this.centerY);
            if (clip != null) {
                g.setClip(clip.createIntersection(g.getClipBounds()));
            }
            if (g.getClipBounds().width > 0 && g.getClipBounds().height > 0) {
                int i2 = x;
                while (i2 < x + width) {
                    g.drawImage(this.topBuffer, i2, y, null);
                    i2 += 100;
                }
            }
        }
        if (this.bottomBuffer != null) {
            g.setClip(x + this.centerX, y + height - this.bottomBuffer.getHeight(), width - (this.matrixImage.getWidth() - 1), this.bottomBuffer.getHeight());
            if (clip != null) {
                g.setClip(clip.createIntersection(g.getClipBounds()));
            }
            if (g.getClipBounds().width > 0 && g.getClipBounds().height > 0) {
                int i3 = x;
                while (i3 < x + width) {
                    g.drawImage(this.bottomBuffer, i3, y + height - this.bottomBuffer.getHeight(), null);
                    i3 += 100;
                }
            }
        }
        if (this.leftBuffer != null) {
            g.setClip(x, y + this.centerY, this.centerX, height - (this.matrixImage.getHeight() - 1));
            if (clip != null) {
                g.setClip(clip.createIntersection(g.getClipBounds()));
            }
            if (g.getClipBounds().width > 0 && g.getClipBounds().height > 0) {
                int i4 = y;
                while (i4 < y + height) {
                    g.drawImage(this.leftBuffer, x, i4, null);
                    i4 += 100;
                }
            }
        }
        if (this.rightBuffer != null) {
            g.setClip(x + width - this.rightBuffer.getWidth(), y + this.centerY, this.rightBuffer.getWidth(), height - (this.matrixImage.getHeight() - 1));
            if (clip != null) {
                g.setClip(clip.createIntersection(g.getClipBounds()));
            }
            if (g.getClipBounds().width > 0 && g.getClipBounds().height > 0) {
                int i5 = y;
                while (i5 < y + height) {
                    g.drawImage(this.rightBuffer, x + width - this.rightBuffer.getWidth(), i5, null);
                    i5 += 100;
                }
            }
        }
        g.setClip(clip);
    }

    public FhMatrixBorder deriveBorder(int rotation) {
        return new FhMatrixBorder(GraphicsUtils.rotateClockwise(this.getMatrix(), rotation));
    }

    public boolean isPainting() {
        return this.painting;
    }

    public void setPainting(boolean painting) {
        this.painting = painting;
    }

    public synchronized void setCenter(int cx, int cy) {
        this.centerX = cx == -1 ? this.matrix[0].length / 2 : cx;
        this.centerY = cy == -1 ? this.matrix.length / 2 : cy;
        this.setMatrix(this.getMatrix());
    }

    public void dumpMatrix(String[][] matrix) {
        int i = 0;
        while (i < matrix.length) {
            int k = 0;
            while (k < matrix[i].length) {
                System.out.print(String.valueOf(matrix[i][k]) + ", ");
                ++k;
            }
            System.out.println();
            ++i;
        }
        System.out.println();
    }

    protected Color getColor(String name) {
        return ThemeManager.instance().getCurrentTheme().getColor(name);
    }

    public synchronized String[][] getMatrix() {
        boolean doubling;
        String[][] m = GraphicsUtils.rotateClockwise(this.matrix, 0);
        int i = 0;
        while (i < m.length) {
            int k = 0;
            while (k < m[i].length) {
                if (m[i][k] == null) {
                    m[i][k] = "x";
                } else if (m[i][k].startsWith("!")) {
                    m[i][k] = m[i][k].substring(1);
                }
                ++k;
            }
            ++i;
        }
        m[(doubling = ThemeManager.instance().getPreferences().isBordersDoubled()) ? this.centerY / 2 : this.centerY][doubling ? this.centerX / 2 : this.centerX] = "!" + m[doubling ? this.centerY / 2 : this.centerY][doubling ? this.centerX / 2 : this.centerX];
        return m;
    }

    public int[] getCenter() {
        return new int[]{this.centerX, this.centerY};
    }

    public synchronized void setMatrix(String[][] m) {
        try {
            boolean doubling;
            this.matrix = GraphicsUtils.rotateClockwise(m, 0);
            boolean centerSet = false;
            int i = 0;
            while (i < this.matrix.length) {
                int k = 0;
                while (k < this.matrix[i].length) {
                    if (this.matrix[i][k] != null && this.matrix[i][k].indexOf("!") != -1) {
                        this.centerX = k;
                        this.centerY = i;
                        centerSet = true;
                    }
                    ++k;
                }
                ++i;
            }
            if (!centerSet) {
                this.centerX = this.matrix[0].length / 2;
                this.centerY = this.matrix.length / 2;
            }
            if (doubling = ThemeManager.instance().getPreferences().isBordersDoubled()) {
                this.centerX *= 2;
                this.centerY *= 2;
            }
            int[][] mi = doubling ? new int[2 * this.matrix.length - 1][2 * this.matrix[0].length - 1] : new int[this.matrix.length][this.matrix[0].length];
            boolean ceil = false;
            int i2 = 0;
            while (i2 < mi.length) {
                int k = 0;
                while (k < mi[i2].length) {
                    String val = this.matrix[doubling ? (ceil ? (int)Math.ceil((double)i2 / 2.0) : i2 / 2) : i2][doubling ? (ceil ? (int)Math.ceil((double)k / 2.0) : k / 2) : k];
                    if (val == null) {
                        mi[i2][k] = 0;
                    } else if (val.indexOf(33) != -1) {
                        mi[i2][k] = val.equals("!x") ? 0 : this.getColor(val.substring(1)).getRGB();
                        ceil = true;
                    } else {
                        mi[i2][k] = val.equals("x") ? 0 : this.getColor(val).getRGB();
                    }
                    ++k;
                }
                ++i2;
            }
            this.matrixImage = GraphicsUtils.createTextureImage(mi, 0);
            this.bottomBuffer = null;
            this.rightBuffer = null;
            this.leftBuffer = null;
            this.topBuffer = null;
            this.insets = null;
        }
        catch (Exception e) {
            System.out.println("(shfarr :: FhMatrixBorder.java) -> Caught unhandled exception: " + e);
            e.printStackTrace();
        }
    }
}

