/*
 * Decompiled with CFR 0.152.
 */
package com.shfarr.ui.plaf.fh.ext;

import com.shfarr.ui.FhSysButton;
import com.shfarr.ui.FhSysIcon;
import com.shfarr.ui.plaf.fh.textures.Texture;
import com.shfarr.ui.plaf.fh.theme.ThemeManager;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JInternalFrame;
import javax.swing.JMenuBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicInternalFrameTitlePane;

public class FhInternalFrameTitlePane
extends BasicInternalFrameTitlePane {
    protected static LayoutManager layout = null;

    public FhInternalFrameTitlePane(JInternalFrame f) {
        super(f);
    }

    protected void createButtons() {
        this.iconButton = new FhSysButton(105);
        this.iconButton.addActionListener(this.iconifyAction);
        this.maxButton = new FhSysButton(108);
        this.maxButton.addActionListener(this.maximizeAction);
        this.closeButton = new FhSysButton(106);
        this.closeButton.addActionListener(this.closeAction);
        this.setButtonIcons();
    }

    protected LayoutManager createLayout() {
        if (layout == null) {
            layout = new FhInternalFrameTitlePaneLayout();
        }
        return layout;
    }

    protected JButton getCloseButtonFromAncestor() {
        return this.closeButton;
    }

    protected JInternalFrame getFrameFromAncestor() {
        return this.frame;
    }

    protected JButton getIconButtonFromAncestor() {
        return this.iconButton;
    }

    protected JButton getMaxButtonFromAncestor() {
        return this.maxButton;
    }

    protected JMenuBar getMenuBarFromAncestor() {
        return this.menuBar;
    }

    protected String getTitle(String text, FontMetrics fm, int availTextWidth) {
        if (text == null || text.equals("")) {
            return "";
        }
        int textWidth = SwingUtilities.computeStringWidth(fm, text);
        String clipString = "...";
        if (textWidth > availTextWidth) {
            int totalWidth = SwingUtilities.computeStringWidth(fm, clipString);
            int nChars = 0;
            while (nChars < text.length()) {
                if ((totalWidth += fm.charWidth(text.charAt(nChars))) > availTextWidth) break;
                ++nChars;
            }
            text = String.valueOf(text.substring(0, nChars)) + clipString;
        }
        return text;
    }

    public void paintComponent(Graphics g) {
        this.paintTitleBackground(g);
        if (this.frame.getTitle() != null) {
            boolean isSelected = this.frame.isSelected();
            Font f = g.getFont();
            g.setFont(this.getFont());
            FontMetrics fm = g.getFontMetrics();
            int baseline = (this.getHeight() + fm.getAscent() - fm.getLeading() - fm.getDescent()) / 2;
            Rectangle r = new Rectangle(0, 0, 0, 0);
            if (this.frame.isIconifiable()) {
                r = this.iconButton.getBounds();
            } else if (this.frame.isMaximizable()) {
                r = this.maxButton.getBounds();
            } else if (this.frame.isClosable()) {
                r = this.closeButton.getBounds();
            }
            String title = this.frame.getTitle();
            if (r.x == 0) {
                r.x = this.frame.getWidth() - this.frame.getInsets().right;
            }
            int titleX = this.menuBar.getX() + this.menuBar.getWidth() + 5;
            int titleW = r.x - titleX - 3;
            title = this.getTitle(this.frame.getTitle(), fm, titleW);
            if (isSelected) {
                g.setColor(this.selectedTextColor);
                g.drawString(title, titleX, baseline);
            } else {
                g.setColor(this.notSelectedTextColor);
                g.drawString(title, titleX, baseline);
            }
            g.setFont(f);
        }
    }

    protected void paintTitleBackground(Graphics g) {
        Texture texture;
        boolean isSelected = this.frame.isSelected();
        Dimension size = this.getSize();
        g.setColor(this.notSelectedTitleColor);
        g.fillRect(0, 0, size.width, size.height);
        int offset = 23;
        if (this.frame.isClosable()) {
            offset += 15;
        }
        if (this.frame.isMaximizable()) {
            offset += 15;
        }
        if (this.frame.isIconifiable()) {
            offset += 15;
        }
        if ((texture = (Texture)UIManager.getDefaults().get("InternalFrame.titleTexture")) != null && ThemeManager.instance().probeSmallTextures()) {
            texture.apply(new Rectangle(20, 0, this.getSize().width - offset, this.getSize().height), (Graphics2D)g, this);
        }
        if (isSelected) {
            g.setColor(this.selectedTitleColor);
        } else {
            g.setColor(this.notSelectedTitleColor);
        }
        FontMetrics fm = this.getFontMetrics(this.getFont());
        String frameTitle = this.frame.getTitle();
        int title_w = (frameTitle != null ? fm.stringWidth(frameTitle) + 2 : 0) + (this.frame.getFrameIcon() != null ? this.frame.getFrameIcon().getIconWidth() + 2 : 0);
        if (this.frame.getComponentOrientation() != ComponentOrientation.LEFT_TO_RIGHT) {
            int ww = Math.min(size.width - offset, title_w - this.frame.getFrameIcon().getIconWidth() + 2);
            g.fillRect(this.frame.getFrameIcon().getIconWidth() + 2, 0, ww, size.height);
            UIManager.getDefaults().getBorder("InternalFrame.titleBorder").paintBorder(this, g, this.frame.getFrameIcon().getIconWidth() + 2, 0, ww, size.height);
        }
    }

    protected void setButtonIcons() {
        if (this.frame.isIcon()) {
            this.iconButton.setIcon(new FhSysIcon(107));
            this.maxButton.setIcon(new FhSysIcon(108));
        } else if (this.frame.isMaximum()) {
            this.iconButton.setIcon(new FhSysIcon(105));
            this.maxButton.setIcon(new FhSysIcon(107));
        } else {
            this.iconButton.setIcon(new FhSysIcon(((FhSysButton)this.iconButton).getType()));
            this.maxButton.setIcon(new FhSysIcon(((FhSysButton)this.maxButton).getType()));
        }
        this.closeButton.setIcon(new FhSysIcon(((FhSysButton)this.closeButton).getType()));
    }

    public class FhInternalFrameTitlePaneLayout
    extends BasicInternalFrameTitlePane.TitlePaneLayout {
        public FhInternalFrameTitlePaneLayout() {
            super(FhInternalFrameTitlePane.this);
        }

        public Dimension minimumLayoutSize(Container c) {
            int subtitle_w;
            int title_length;
            FhInternalFrameTitlePane pane = (FhInternalFrameTitlePane)c;
            int width = 22;
            if (pane.getFrameFromAncestor().isClosable()) {
                width += 15;
            }
            if (pane.getFrameFromAncestor().isMaximizable()) {
                width += 15;
            }
            if (pane.getFrameFromAncestor().isIconifiable()) {
                width += 15;
            }
            FontMetrics fm = FhInternalFrameTitlePane.this.getFontMetrics(pane.getFont());
            String frameTitle = pane.getFrameFromAncestor().getTitle();
            int title_w = frameTitle != null ? fm.stringWidth(frameTitle) : 0;
            int n = title_length = frameTitle != null ? frameTitle.length() : 0;
            width = title_length > 3 ? (width += title_w < (subtitle_w = fm.stringWidth(String.valueOf(frameTitle.substring(0, 3)) + "...")) ? title_w : subtitle_w) : (width += title_w);
            Icon icon = pane.getFrameFromAncestor().getFrameIcon();
            int fontHeight = fm.getHeight();
            fontHeight += 2;
            int iconHeight = 0;
            if (icon != null) {
                iconHeight = Math.min(icon.getIconHeight(), 16);
            }
            int height = Math.max(fontHeight, iconHeight);
            Dimension dim = new Dimension(width, height);
            if (pane.getBorder() != null) {
                Insets insets = pane.getBorder().getBorderInsets(c);
                dim.height += insets.top + insets.bottom;
                dim.width += insets.left + insets.right;
            }
            return dim;
        }

        public void layoutContainer(Container c) {
            FhInternalFrameTitlePane pane = (FhInternalFrameTitlePane)c;
            boolean leftToRight = pane.getFrameFromAncestor().getComponentOrientation() != ComponentOrientation.LEFT_TO_RIGHT;
            int w = pane.getWidth();
            int h = pane.getHeight();
            int buttonHeight = pane.getCloseButtonFromAncestor().getIcon().getIconHeight() + 2;
            Icon icon = pane.getFrameFromAncestor().getFrameIcon();
            int iconHeight = 0;
            if (icon != null) {
                iconHeight += icon.getIconHeight();
            }
            int x = leftToRight ? 0 : w - 13 - 2;
            pane.getMenuBarFromAncestor().setBounds(x, 0, 16, 16);
            int n = x = leftToRight ? w - 13 - 2 : 2;
            if (pane.getFrameFromAncestor().isClosable()) {
                pane.getCloseButtonFromAncestor().setBounds(x, (h - buttonHeight) / 2, 13, 13);
                x += leftToRight ? -15 : 15;
            }
            if (pane.getFrameFromAncestor().isMaximizable()) {
                pane.getMaxButtonFromAncestor().setBounds(x, (h - buttonHeight) / 2, 13, 13);
                x += leftToRight ? -15 : 15;
            }
            if (pane.getFrameFromAncestor().isIconifiable()) {
                pane.getIconButtonFromAncestor().setBounds(x, (h - buttonHeight) / 2, 13, 13);
            }
        }
    }
}

