/*
 * Decompiled with CFR 0.152.
 */
package com.shfarr.ui.plaf.fh.ext;

import com.shfarr.ui.plaf.fh.textures.Texture;
import com.shfarr.ui.plaf.fh.theme.ThemeManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.plaf.UIResource;
import javax.swing.table.DefaultTableCellRenderer;

public class FhTableHeaderCellRenderer
extends DefaultTableCellRenderer
implements UIResource {
    protected int crow = 0;
    protected int ccol = 0;

    public FhTableHeaderCellRenderer() {
        this.setOpaque(true);
        this.setHorizontalAlignment(0);
    }

    public Font getFont() {
        return UIManager.getFont("TableHeader.font");
    }

    public Color getBackground() {
        return UIManager.getColor("TableHeader.cellBackground");
    }

    public Rectangle getVisibleRect() {
        return new Rectangle(0, 0, this.getWidth(), this.getHeight());
    }

    public Dimension getPreferredSize() {
        Dimension d = super.getPreferredSize();
        if (this.getBorder() != null) {
            Insets i = this.getBorder().getBorderInsets(this);
            d.width += i.left + i.right;
            d.height += i.top + i.bottom;
        }
        return d;
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean selected, boolean hasFocus, int row, int col) {
        this.crow = row;
        this.ccol = col;
        return super.getTableCellRendererComponent(table, value, selected, hasFocus, row, col);
    }

    public void paint(Graphics g) {
        g.setFont(UIManager.getFont("TableHeader.font"));
        this.setOpaque(true);
        Color prevFore = this.getForeground();
        this.setForeground(Color.white);
        g.translate(1, 1);
        super.paint(g);
        Texture texture = (Texture)UIManager.getDefaults().get("TableHeader.texture");
        if (texture != null && ThemeManager.instance().probeSmallTextures()) {
            texture.apply(new Rectangle(0, 0, this.getWidth() - 1, this.getHeight()), (Graphics2D)g, this);
        }
        g.translate(-1, -1);
        this.setForeground(prevFore);
        this.setOpaque(false);
        super.paint(g);
        UIManager.getBorder("TableHeader.cellBorder").paintBorder(this, g, 0, 0, this.getWidth(), this.getHeight());
        g.setColor(UIManager.getColor("Viewport.background"));
        g.setColor(Color.red);
        g.drawLine(this.getWidth(), 0, this.getWidth(), this.getHeight());
    }
}

