/*
 * Decompiled with CFR 0.152.
 */
package com.shfarr.ui.plaf.fh.textures;

import com.shfarr.ui.plaf.fh.textures.Texture;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.JComponent;

public class GradientTexture
extends Texture {
    protected String[] colors = null;

    public GradientTexture() {
    }

    public GradientTexture(String[] colors) {
        this.setColors(colors);
    }

    public void parse(String str) {
    }

    public void apply(Shape s, Rectangle clip, Graphics2D g2D, JComponent c) {
        GradientPaint gradient = null;
        Rectangle rect = s.getBounds();
        Shape oldClip = g2D.getClip();
        g2D.setClip(clip != null ? c.getVisibleRect().createIntersection(clip) : c.getVisibleRect());
        if (g2D.getClipBounds().width > 0 && g2D.getClipBounds().height > 0) {
            float hStep = this.actualRotation() == 0 || this.actualRotation() == 2 ? (float)rect.width / (float)(this.colors.length - 1) : 0.0f;
            float vStep = this.actualRotation() == 1 || this.actualRotation() == 3 ? (float)rect.height / (float)(this.colors.length - 1) : 0.0f;
            int i = 0;
            while (i < this.colors.length - 1) {
                if (this.actualRotation() == 0 || this.actualRotation() == 1) {
                    gradient = new GradientPaint((float)rect.x + (float)i * hStep, (float)rect.y + (float)i * vStep, this.theme.getColor(this.colors[i]), (float)rect.x + (float)(i + 1) * hStep, (float)rect.y + (float)(i + 1) * vStep, this.theme.getColor(this.colors[i + 1]));
                } else if (this.actualRotation() == 2 || this.actualRotation() == 3) {
                    gradient = new GradientPaint((float)rect.x + (float)(this.colors.length - i - 1) * hStep, (float)rect.y + (float)(this.colors.length - i - 1) * vStep, this.theme.getColor(this.colors[i]), (float)rect.x + (float)(this.colors.length - i - 2) * hStep, (float)rect.y + (float)(this.colors.length - i - 2) * vStep, this.theme.getColor(this.colors[i + 1]));
                }
                g2D.setPaint(gradient);
                if (this.actualRotation() == 0) {
                    g2D.fill(new Rectangle(rect.x + (int)((float)i * hStep), rect.y, (int)hStep, rect.height));
                } else if (this.actualRotation() == 1) {
                    g2D.fill(new Rectangle(rect.x, rect.y + (int)((float)i * vStep), rect.width, (int)vStep));
                } else if (this.actualRotation() == 2) {
                    g2D.fill(new Rectangle(rect.x + (int)((float)(this.colors.length - i - 2) * hStep), rect.y, (int)hStep, rect.height));
                } else if (this.actualRotation() == 3) {
                    g2D.fill(new Rectangle(rect.x, rect.y + (int)((float)(this.colors.length - i - 2) * vStep), rect.width, (int)vStep));
                }
                ++i;
            }
        }
        g2D.setClip(oldClip);
    }

    public String[] getColors() {
        return this.colors;
    }

    public void setColors(String[] colors) {
        this.colors = colors;
    }
}

