/*
 * Decompiled with CFR 0.152.
 */
package com.shfarr.ui.plaf.fh.textures;

import com.shfarr.ui.GraphicsUtils;
import com.shfarr.ui.plaf.fh.textures.Texture;
import com.shfarr.ui.plaf.fh.theme.ThemeManager;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.TexturePaint;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;

public class MatrixTexture
extends Texture {
    protected String[][] matrix = null;
    protected BufferedImage matrixImage;

    public MatrixTexture() {
    }

    public MatrixTexture(String[][] customMatrix) {
        this.setMatrix(customMatrix);
    }

    public void parse(String str) {
    }

    public void apply(Shape s, Rectangle clip, Graphics2D g2D, JComponent c) {
        Shape oldClip = g2D.getClip();
        g2D.setClip(clip != null ? c.getVisibleRect().createIntersection(clip) : c.getVisibleRect());
        if (g2D.getClipBounds().width > 0 && g2D.getClipBounds().height > 0) {
            Rectangle anchor = s.getBounds();
            anchor.width = this.matrixImage.getWidth();
            anchor.height = this.matrixImage.getHeight();
            Paint op = g2D.getPaint();
            g2D.setPaint(new TexturePaint(this.matrixImage, anchor));
            g2D.fill(s);
            g2D.setPaint(op);
        }
        g2D.setClip(oldClip);
    }

    public void rotate(int rotation) {
        super.rotate(rotation);
    }

    public String[][] getMatrix() {
        return this.matrix;
    }

    public void setMatrix(String[][] matrix) {
        if (matrix == null) {
            throw new NullPointerException("Matrix null");
        }
        this.matrix = GraphicsUtils.rotateClockwise(matrix, 0);
        int[][] mi = new int[matrix.length][matrix[0].length];
        int i = 0;
        while (i < mi.length) {
            int k = 0;
            while (k < mi[i].length) {
                mi[i][k] = matrix[i][k] != null ? (matrix[i][k].equals("x") || this.getColor(matrix[i][k]) != null ? this.getColor(matrix[i][k]).getRGB() : 0) : 0;
                ++k;
            }
            ++i;
        }
        this.matrixImage = GraphicsUtils.createTextureImage(mi, this.getRotation());
    }

    protected Color getColor(String name) {
        return ThemeManager.instance().getCurrentTheme().getColor(name);
    }

    public Texture deriveTexture(int rotation) {
        MatrixTexture b = new MatrixTexture();
        b.setMatrix(GraphicsUtils.rotateClockwise(this.matrix, ThemeManager.instance().getCurrentTheme().metaPalette().get("Matrix Textures rotate").equals(Boolean.TRUE) ? rotation : 0));
        return b;
    }
}

