/*
 * Decompiled with CFR 0.152.
 */
package com.shfarr.ui.plaf.fh.theme;

import com.shfarr.ui.GraphicsUtils;
import com.shfarr.ui.plaf.fh.theme.Palette;
import com.shfarr.ui.plaf.fh.theme.ThemeManager;
import java.awt.Color;
import java.util.Collection;
import java.util.Vector;

public class ColorPalette
extends Palette {
    public static final Color BLANK = new Color(0, 0, 0, 0);
    protected Color[] colors;

    public ColorPalette derivePalette(Color base) {
        ColorPalette derived = new ColorPalette();
        derived.putAll(this);
        derived.registerColor("base", base);
        return derived;
    }

    public Color getColor(int index) {
        if (this.colors == null) {
            this.colors = new Color[21];
            ColorPalette.createVariations(this, this.getColor("base"));
        }
        if ((index += 10) < 0 || index > 20) {
            return null;
        }
        return this.colors[index];
    }

    public Color getColor(String name) {
        if (name == null) {
            new Throwable().printStackTrace();
        }
        try {
            return this.getColor(Integer.parseInt(name));
        }
        catch (Exception e) {
            if (name.equals("x") || name.equals("!x")) {
                return BLANK;
            }
            return (Color)this.get(name.startsWith("!") ? name.substring(1) : name);
        }
    }

    public Collection list() {
        if (this.colors == null) {
            this.getColor(0);
        }
        Vector<String> v = new Vector<String>();
        int i = 0;
        while (i < this.colors.length) {
            v.add("" + (i - 10));
            ++i;
        }
        v.addAll(this.keySet());
        return v;
    }

    public boolean registerColor(String name, Color color) {
        if ("".equals(name)) {
            return false;
        }
        if (name.equals("base")) {
            this.colors = null;
        }
        if (color != null || !"base".equals(name) && !"negative".equals(name) && !"affirmative".equals(name)) {
            this.put(name, color);
        }
        return true;
    }

    protected static void createVariations(ColorPalette colorPalette, Color baseColor) {
        double factor = 1.0f + (float)ThemeManager.instance().getPreferences().getContrast() / 100.0f;
        colorPalette.colors[0] = ColorPalette.createColorVariation(baseColor, -130, factor);
        colorPalette.colors[1] = ColorPalette.createColorVariation(baseColor, -120, factor);
        colorPalette.colors[2] = ColorPalette.createColorVariation(baseColor, -100, factor);
        colorPalette.colors[3] = ColorPalette.createColorVariation(baseColor, -90, factor);
        colorPalette.colors[4] = ColorPalette.createColorVariation(baseColor, -75, factor);
        colorPalette.colors[5] = ColorPalette.createColorVariation(baseColor, -65, factor);
        colorPalette.colors[6] = ColorPalette.createColorVariation(baseColor, -50, factor);
        colorPalette.colors[7] = ColorPalette.createColorVariation(baseColor, -40, factor);
        colorPalette.colors[8] = ColorPalette.createColorVariation(baseColor, -35, factor);
        colorPalette.colors[9] = ColorPalette.createColorVariation(baseColor, -20, factor);
        colorPalette.colors[10] = baseColor;
        colorPalette.colors[11] = ColorPalette.createColorVariation(baseColor, 20, factor);
        colorPalette.colors[12] = ColorPalette.createColorVariation(baseColor, 40, factor);
        colorPalette.colors[13] = ColorPalette.createColorVariation(baseColor, 60, factor);
        colorPalette.colors[14] = ColorPalette.createColorVariation(baseColor, 75, factor);
        colorPalette.colors[15] = ColorPalette.createColorVariation(baseColor, 90, factor);
        colorPalette.colors[16] = ColorPalette.createColorVariation(baseColor, 100, factor);
        colorPalette.colors[17] = ColorPalette.createColorVariation(baseColor, 120, factor);
        colorPalette.colors[18] = ColorPalette.createColorVariation(baseColor, 125, factor);
        colorPalette.colors[19] = ColorPalette.createColorVariation(baseColor, 130, factor);
        colorPalette.colors[20] = ColorPalette.createColorVariation(baseColor, 160, factor);
    }

    protected static Color createColorVariation(Color base, int amount, double factor) {
        double red = (double)base.getRed() + (double)amount * factor;
        double green = (double)base.getGreen() + (double)amount * factor;
        double blue = (double)base.getBlue() + (double)amount * factor;
        if (red > 255.0) {
            red = 255.0;
        }
        if (green > 255.0) {
            green = 255.0;
        }
        if (blue > 255.0) {
            blue = 255.0;
        }
        if (red < 0.0) {
            red = 0.0;
        }
        if (green < 0.0) {
            green = 0.0;
        }
        if (blue < 0.0) {
            blue = 0.0;
        }
        if (factor < 1.0) {
            red += (255.0 - red) * (1.0 - factor);
            green += (255.0 - green) * (1.0 - factor);
            blue += (255.0 - blue) * (1.0 - factor);
        }
        double med = (red + green + blue) / 3.0;
        double d = Math.min(med, 255.0 - med) / 128.0;
        return new Color(GraphicsUtils.desaturate((int)red << 16 | (int)green << 8 | (int)blue, 1.0 - d));
    }
}

