/*
 * Decompiled with CFR 0.152.
 */
package com.shfarr.ui.plaf.fh.theme.edit;

import com.shfarr.ui.GraphicsUtils;
import com.shfarr.ui.layouts.QueueLayout;
import com.shfarr.ui.plaf.fh.theme.ColorPalette;
import com.shfarr.ui.plaf.fh.theme.edit.ColorPalettePanel;
import com.shfarr.ui.plaf.fh.theme.edit.ThemeEditor;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.MatteBorder;

public class ColorEditor
extends JPanel
implements ActionListener {
    private JLabel customColorChooser = null;
    private JPanel centerPanel = null;
    private JPanel sidePanel = null;
    private JPanel palettePanel = null;
    private JPanel northPanel = null;
    private JTextField colorField = null;
    private JSpinner alphaSpinner = null;
    private JToggleButton selected = null;

    public ColorEditor() {
        super(new BorderLayout(3, 3));
        this.setBorder(new EmptyBorder(10, 4, 4, 0));
        this.add((Component)this.getsidePanel(), "East");
        this.add((Component)this.getCenterPanel(), "Center");
    }

    protected JLabel getCustomColorChooser() {
        if (this.customColorChooser == null) {
            this.customColorChooser = new JLabel("", 0);
            this.customColorChooser.setOpaque(true);
            this.customColorChooser.setPreferredSize(new Dimension(30, 50));
            this.customColorChooser.setBorder(new CompoundBorder(new MatteBorder(0, 0, 0, 0, this.customColorChooser.getBackground()), new MatteBorder(1, 1, 1, 1, Color.black)));
        }
        return this.customColorChooser;
    }

    protected JPanel getPalettePanel() {
        if (this.palettePanel == null) {
            ColorPalette cp = ThemeEditor.instance().getEditedTheme().colorPalette();
            Collection list = cp.list();
            this.palettePanel = new ColorPalettePanel(new GridLayout(list.size() / 4 + (list.size() % 4 != 0 ? 1 : 0) + 1, 4, 2, 2));
            this.palettePanel.setBorder(new EmptyBorder(5, 5, 5, 5));
            ButtonGroup group = new ButtonGroup();
            int i = 0;
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                String name = (String)iter.next();
                if (cp.getColor(name) == null) continue;
                JToggleButton b = this.createToggleButton(name, cp.getColor(name));
                if (i == 24) {
                    int q = 0;
                    while (q < 4) {
                        JLabel sep = new JLabel();
                        sep.setPreferredSize(new Dimension(20, 20));
                        this.palettePanel.add(sep);
                        ++q;
                    }
                }
                this.palettePanel.add(b);
                group.add(b);
                ++i;
            }
        }
        return this.palettePanel;
    }

    protected JToggleButton createToggleButton(String name, Color c) {
        JToggleButton b = new JToggleButton("");
        BufferedImage img = new BufferedImage(20, 20, 2);
        Graphics2D g = img.createGraphics();
        g.setColor(Color.gray);
        g.drawRect(0, 0, 19, 19);
        g.setColor(Color.white);
        g.drawRect(1, 1, 17, 17);
        GraphicsUtils.paintTiledBackground(g, new Rectangle(3, 2, 14, 16), 5);
        g.drawImage((Image)GraphicsUtils.createColorImage(c, 14, 16), 3, 2, null);
        b.setIcon(new ImageIcon(img));
        b.setDisabledIcon(new ImageIcon(img));
        BufferedImage imgS = new BufferedImage(20, 20, 2);
        g = imgS.createGraphics();
        g.setColor(Color.orange);
        g.drawRect(0, 0, 19, 19);
        g.setColor(Color.white);
        g.drawRect(1, 1, 17, 17);
        GraphicsUtils.paintTiledBackground(g, new Rectangle(3, 2, 14, 16), 5);
        g.drawImage((Image)GraphicsUtils.createColorImage(c, 14, 16), 3, 2, null);
        b.setSelectedIcon(new ImageIcon(imgS));
        b.setActionCommand(name);
        b.setMargin(new Insets(1, 1, 1, 1));
        b.addActionListener(this);
        b.setEnabled(!this.isBaseColor(name));
        return b;
    }

    protected JPanel getCenterPanel() {
        if (this.centerPanel == null) {
            JScrollPane scp = new JScrollPane(this.getPalettePanel());
            scp.setPreferredSize(new Dimension(this.getPalettePanel().getPreferredSize().width + scp.getVerticalScrollBar().getPreferredSize().width + 6, 100));
            this.centerPanel = new JPanel(new BorderLayout(4, 4));
            this.centerPanel.add((Component)scp, "West");
            this.centerPanel.add((Component)this.getNorthPanel(), "Center");
        }
        return this.centerPanel;
    }

    protected JTextField getColorField() {
        if (this.colorField == null) {
            this.colorField = new JTextField();
            this.colorField.setPreferredSize(new Dimension(240, this.colorField.getPreferredSize().height));
        }
        return this.colorField;
    }

    protected JSpinner getAlphaSpinner() {
        if (this.alphaSpinner == null) {
            this.alphaSpinner = new JSpinner(new SpinnerNumberModel(0, 0, 255, 1));
        }
        return this.alphaSpinner;
    }

    protected JPanel getNorthPanel() {
        if (this.northPanel == null) {
            this.northPanel = new JPanel(new QueueLayout(4, 0, 2));
            this.northPanel.setBorder(new EmptyBorder(0, 5, 5, 5));
            this.northPanel.add(new JLabel("Selected Color"));
            this.northPanel.add(this.getCustomColorChooser());
            this.northPanel.add(new JLabel(""));
            this.northPanel.add(this.getColorField());
            JButton cc = new JButton("Select");
            cc.setActionCommand("Choose Color");
            cc.addActionListener(this);
            JPanel alphaPanel = new JPanel(new QueueLayout(4, 100, 3));
            alphaPanel.add(cc);
            alphaPanel.add((Component)this.getAlphaSpinner(), QueueLayout.END);
            alphaPanel.add((Component)new JLabel("Alpha ", 4), QueueLayout.END);
            this.northPanel.add(alphaPanel);
        }
        return this.northPanel;
    }

    protected JPanel getsidePanel() {
        if (this.sidePanel == null) {
            this.sidePanel = new JPanel(new QueueLayout(4, 0, 2));
            this.sidePanel.setBorder(new EmptyBorder(0, 4, 4, 4));
            JButton save = new JButton("Save");
            save.addActionListener(this);
            JButton revert = new JButton("Revert");
            revert.addActionListener(this);
            JButton remove = new JButton("Remove");
            remove.addActionListener(this);
            JButton set = new JButton("Add / Set");
            set.addActionListener(this);
            set.setActionCommand("Set");
            JButton rollback = new JButton("Rollback");
            rollback.addActionListener(this);
            this.sidePanel.add(save);
            this.sidePanel.add(revert);
            this.sidePanel.add(new JPanel());
            this.sidePanel.add(set);
            this.sidePanel.add(rollback);
            this.sidePanel.add(remove);
        }
        return this.sidePanel;
    }

    public void actionPerformed(ActionEvent e) {
        Color c;
        Color c2;
        if (e.getSource() instanceof JToggleButton) {
            this.selected = (JToggleButton)e.getSource();
            this.getColorField().setText(e.getActionCommand());
            c2 = ThemeEditor.instance().getEditedTheme().colorPalette().getColor(e.getActionCommand());
            this.getCustomColorChooser().setBackground(new Color(0xFF000000 | c2.getRGB()));
            this.getAlphaSpinner().setValue(new Integer(c2.getAlpha()));
        }
        if (e.getActionCommand().equals("Revert")) {
            ThemeEditor.instance().getEditedTheme().loadColors();
            this.refreshToggleButtons();
        }
        if (e.getActionCommand().equals("Save")) {
            ThemeEditor.instance().getEditedTheme().saveColors();
        }
        if (e.getActionCommand().equals("Rollback") && this.selected != null) {
            this.getColorField().setText(this.selected.getActionCommand());
            c2 = ThemeEditor.instance().getEditedTheme().colorPalette().getColor(this.selected.getActionCommand());
            this.getCustomColorChooser().setBackground(new Color(0xFF000000 | c2.getRGB()));
            this.getAlphaSpinner().setValue(new Integer(c2.getAlpha()));
        }
        if (e.getActionCommand().equals("Set")) {
            int alpha = (Integer)this.getAlphaSpinner().getValue();
            Color c3 = this.getCustomColorChooser().getBackground();
            Color old = ThemeEditor.instance().getEditedTheme().colorPalette().getColor(this.getColorField().getText());
            ThemeEditor.instance().getEditedTheme().colorPalette().registerColor(this.getColorField().getText(), new Color(c3.getRed(), c3.getGreen(), c3.getBlue(), alpha));
            if (this.getColorField().getText().equals("base") && !this.getColorField().getText().equals("")) {
                this.refreshToggleButtons();
            } else {
                JToggleButton b = this.createToggleButton("dummy", new Color(c3.getRed(), c3.getGreen(), c3.getBlue(), alpha));
                if (old != null) {
                    this.selected.setIcon(b.getIcon());
                    this.selected.setSelectedIcon(b.getSelectedIcon());
                } else {
                    this.refreshToggleButtons();
                }
            }
        }
        if (e.getActionCommand().equals("Choose Color") && (c = JColorChooser.showDialog(SwingUtilities.windowForComponent((JButton)e.getSource()), "Custom Color", this.getCustomColorChooser().getBackground())) != null) {
            this.getCustomColorChooser().setBackground(c);
        }
        if (e.getActionCommand().equals("Remove") && !this.getColorField().getText().equals("")) {
            ThemeEditor.instance().getEditedTheme().colorPalette().registerColor(this.getColorField().getText(), null);
            this.refreshToggleButtons();
        }
    }

    protected void refreshToggleButtons() {
        JScrollPane scp = (JScrollPane)this.palettePanel.getParent().getParent();
        this.palettePanel = null;
        scp.setViewportView(this.getPalettePanel());
    }

    protected boolean isBaseColor(String name) {
        try {
            int i = Integer.parseInt(name);
            return i > -11 && i < 11;
        }
        catch (Exception e) {
            return false;
        }
    }
}

