/*
 * Decompiled with CFR 0.152.
 */
package com.shfarr.ui.plaf.fh.theme.edit;

import com.shfarr.ui.layouts.FlexibleGridLayout;
import com.shfarr.ui.layouts.QueueLayout;
import com.shfarr.ui.plaf.fh.theme.edit.ThemeEditor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class FontEditor
extends JPanel
implements ActionListener,
ChangeListener {
    private JComboBox fontCombo = null;
    private JPanel editor = null;
    private JLabel sampleLabel = null;
    private JPanel sidePanel = null;
    private JCheckBox italicCheckBox = null;
    private JCheckBox boldCheckBox = null;
    private JPanel centerPanel = null;
    private JComboBox namesCombo = null;
    private JSpinner sizeSpinner = null;

    public FontEditor() {
        super(new BorderLayout());
        this.setBorder(new EmptyBorder(10, 4, 4, 0));
        this.add((Component)this.getSidePanel(), "East");
        this.add((Component)this.getCenterPanel(), "Center");
    }

    protected JPanel getCenterPanel() {
        if (this.centerPanel == null) {
            this.centerPanel = new JPanel(new BorderLayout(4, 4));
            this.centerPanel.setBorder(new EmptyBorder(0, 0, 0, 4));
            JPanel aPanel = new JPanel(new QueueLayout(4, 100, 2));
            aPanel.add(new JLabel("Font"));
            aPanel.add(this.getNamesCombo());
            this.centerPanel.add((Component)aPanel, "North");
            this.centerPanel.add((Component)new JScrollPane(this.getSampleLabel()), "Center");
            this.centerPanel.add((Component)this.getEditor(), "South");
        }
        return this.centerPanel;
    }

    protected JComboBox getFontCombo() {
        if (this.fontCombo == null) {
            this.fontCombo = new JComboBox();
            Font[] fonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts();
            int i = 0;
            while (i < fonts.length) {
                this.fontCombo.addItem(fonts[i].getName());
                ++i;
            }
            this.fontCombo.addActionListener(this);
        }
        return this.fontCombo;
    }

    protected JLabel getSampleLabel() {
        if (this.sampleLabel == null) {
            this.sampleLabel = new JLabel("Sample Text", 0);
            this.sampleLabel.setOpaque(true);
            this.sampleLabel.setPreferredSize(new Dimension(100, 100));
            this.sampleLabel.setBorder(new EmptyBorder(5, 5, 5, 5));
        }
        return this.sampleLabel;
    }

    protected JCheckBox getBoldCheckBox() {
        if (this.boldCheckBox == null) {
            this.boldCheckBox = new JCheckBox("Bold");
            this.boldCheckBox.addActionListener(this);
        }
        return this.boldCheckBox;
    }

    protected JCheckBox getItalicCheckBox() {
        if (this.italicCheckBox == null) {
            this.italicCheckBox = new JCheckBox("Italic");
            this.italicCheckBox.addActionListener(this);
        }
        return this.italicCheckBox;
    }

    protected JComboBox getNamesCombo() {
        if (this.namesCombo == null) {
            this.namesCombo = new JComboBox();
            Iterator i = ThemeEditor.instance().getEditedTheme().fontPalette().keySet().iterator();
            while (i.hasNext()) {
                this.namesCombo.addItem(i.next());
            }
            this.namesCombo.addActionListener(this);
            this.selectFont((String)this.namesCombo.getItemAt(0));
        }
        return this.namesCombo;
    }

    protected JSpinner getSizeSpinner() {
        if (this.sizeSpinner == null) {
            this.sizeSpinner = new JSpinner(new SpinnerNumberModel(1, 1, 1000, 1));
            this.sizeSpinner.addChangeListener(this);
        }
        return this.sizeSpinner;
    }

    protected JPanel getEditor() {
        if (this.editor == null) {
            this.editor = new JPanel(new FlexibleGridLayout(3, 2, 4, 4));
            this.editor.add(this.getFontCombo());
            this.editor.add(this.getSizeSpinner());
            this.editor.add(this.getBoldCheckBox());
            this.editor.add(new JLabel());
            this.editor.add(this.getItalicCheckBox());
            this.editor.add(new JLabel());
        }
        return this.editor;
    }

    protected JPanel getSidePanel() {
        if (this.sidePanel == null) {
            this.sidePanel = new JPanel(new QueueLayout(4, 0, 2));
            this.sidePanel.setBorder(new EmptyBorder(0, 4, 4, 4));
            JButton save = new JButton("Save");
            save.addActionListener(this);
            JButton revert = new JButton("Revert");
            revert.addActionListener(this);
            this.sidePanel.add(save);
            this.sidePanel.add(revert);
        }
        return this.sidePanel;
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.getNamesCombo()) {
            this.selectFont(this.getNamesCombo().getSelectedItem().toString());
        }
        if (e.getSource() == this.getFontCombo()) {
            this.getSampleLabel().setFont(new Font(this.getFontCombo().getSelectedItem().toString(), this.getSampleLabel().getFont().getStyle(), this.getSampleLabel().getFont().getSize()));
        }
        if (e.getSource() instanceof JCheckBox) {
            int style = 0;
            if (this.getBoldCheckBox().isSelected()) {
                style |= 1;
            }
            if (this.getItalicCheckBox().isSelected()) {
                style |= 2;
            }
            this.getSampleLabel().setFont(this.getSampleLabel().getFont().deriveFont(style));
        }
        if (e.getActionCommand().equals("Save")) {
            ThemeEditor.instance().getEditedTheme().fontPalette().put(this.getNamesCombo().getSelectedItem().toString(), this.getSampleLabel().getFont());
            ThemeEditor.instance().getEditedTheme().saveFonts();
        } else if (e.getActionCommand().equals("Revert")) {
            this.selectFont(this.getNamesCombo().getSelectedItem().toString());
        }
    }

    protected void selectFont(String name) {
        Font font = (Font)ThemeEditor.instance().getEditedTheme().fontPalette().get(name);
        this.getSampleLabel().setFont(font);
        this.getFontCombo().setSelectedItem(font.getName());
        this.getBoldCheckBox().setSelected(font.isBold());
        this.getItalicCheckBox().setSelected(font.isItalic());
        this.getSizeSpinner().setValue(new Integer(font.getSize()));
    }

    public void stateChanged(ChangeEvent e) {
        this.getSampleLabel().setFont(this.getSampleLabel().getFont().deriveFont(((Integer)this.getSizeSpinner().getValue()).floatValue()));
    }
}

