/*
 * Decompiled with CFR 0.152.
 */
package com.shfarr.ui.wizards;

import com.shfarr.ui.UIUtils;
import com.shfarr.ui.layouts.QueueLayout;
import com.shfarr.ui.wizards.Wizard;
import com.shfarr.ui.wizards._WizardLabel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;

public abstract class AbstractWizard
implements ActionListener,
Wizard {
    public static final String[] BASIC_ACTIONS = new String[]{"Previous", "Next", "Cancel"};
    protected _WizardLabel messageArea = null;
    protected JPanel buttonSupport = null;
    protected JPanel workPanel = null;
    private int stepCount = 1;
    private int currentStep = 1;
    protected JButton[] buttons_ = null;
    protected Component[] editors = null;
    private JFrame frame = null;
    private JDialog dialog = null;
    protected Object userObject = null;
    protected Component caller = null;
    protected boolean busy = false;
    protected JOptionPane op = null;
    private boolean wasCentered = false;
    private boolean wasResized = false;
    private int width = 0;
    private int height = 0;

    public AbstractWizard() {
    }

    public AbstractWizard(int stepCount) {
        this.stepCount = stepCount;
    }

    protected JButton[] getButtons() {
        if (this.buttons_ == null) {
            this.buttons_ = UIUtils.createSimpleButtonSet(BASIC_ACTIONS, this);
        }
        return this.buttons_;
    }

    protected JOptionPane getOptionArea() {
        if (this.op == null) {
            this.op = new AnOptionPane(this.getButtons());
            this.op.setBorder(new EmptyBorder(0, 0, 8, 0));
            this.op.setMessage(this.getWorkPanel());
            this.op.setIcon(null);
        }
        return this.op;
    }

    public void actionPerformed(ActionEvent ae) {
        if (ae.getActionCommand().equalsIgnoreCase("next")) {
            if (this.currentStep == this.getStepCount()) {
                if (this.commit()) {
                    if (this.dialog != null) {
                        this.dialog.dispose();
                    }
                    if (this.frame != null) {
                        this.frame.dispose();
                    }
                    this.busy = false;
                }
            } else {
                this.nextStep();
                this.evaluateActions();
                this.evaluateCurrentStep();
            }
        } else if (ae.getActionCommand().equalsIgnoreCase("previous")) {
            this.previousStep();
            this.evaluateActions();
            this.evaluateCurrentStep();
        } else if (ae.getActionCommand().equalsIgnoreCase("cancel")) {
            this.rollBack();
            if (this.dialog != null) {
                this.dialog.dispose();
            }
            if (this.frame != null) {
                this.frame.dispose();
            }
            this.busy = false;
        }
    }

    protected abstract boolean commit();

    public void evaluateActions() {
        ((JButton[])this.getOptionArea().getOptions())[0].setEnabled(false);
        ((JButton[])this.getOptionArea().getOptions())[1].setEnabled(false);
        ((JButton[])this.getOptionArea().getOptions())[2].setEnabled(true);
        ((JButton[])this.getOptionArea().getOptions())[1].setText(this.getCurrentStep() == this.getStepCount() ? "Finish" : "Next");
        ((JButton[])this.getOptionArea().getOptions())[1].setActionCommand("Next");
        try {
            ((JButton[])this.getOptionArea().getOptions())[1].setIcon(new ImageIcon(ClassLoader.getSystemResource("cres/actions/" + ((JButton[])this.getOptionArea().getOptions())[1].getText().toLowerCase() + ".png")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setForwardAllowed(this.getCurrentStep() <= this.getStepCount());
        this.setBackwardAllowed(this.getCurrentStep() > 1);
        if (this.width == 0 && this.height == 0) {
            if (this.dialog != null) {
                this.getDialog().pack();
            }
            if (this.frame != null) {
                this.getFrame().pack();
            }
        } else if (!this.wasResized) {
            if (this.dialog != null) {
                this.dialog.setSize(this.width, this.height);
            }
            if (this.frame != null) {
                this.frame.setSize(this.width, this.height);
            }
            this.wasResized = !this.wasResized;
        }
    }

    protected abstract void evaluateCurrentStep();

    public int getCurrentStep() {
        return this.currentStep;
    }

    protected JFrame getFrame() {
        if (this.frame == null) {
            Object parent = null;
            this.frame = new JFrame("Wizard");
        }
        this.frame.setContentPane(new JPanel(new BorderLayout(6, 6)){

            public String getUIClassID() {
                return "WizardUI";
            }
        });
        ((JComponent)this.frame.getContentPane()).setBorder(BorderFactory.createMatteBorder(0, 0, 0, 0, this.frame.getContentPane().getBackground()));
        this.frame.getContentPane().add((Component)this.getMessageArea(), "North");
        this.frame.getContentPane().add((Component)this.getOptionArea(), "Center");
        this.frame.getRootPane().setDefaultButton(((JButton[])this.getOptionArea().getOptions())[2]);
        return this.frame;
    }

    protected JDialog getDialog() {
        if (this.dialog == null) {
            Window parent = null;
            if (this.caller != null) {
                parent = SwingUtilities.windowForComponent(this.caller);
                this.dialog = parent instanceof Frame ? new JDialog((Frame)parent, "Wizard", true) : new JDialog((Dialog)parent, "Wizard", true);
            } else {
                this.dialog = new JDialog();
                this.dialog.setTitle("Wizard");
                this.dialog.setModal(true);
            }
            this.dialog.setContentPane(new JPanel(new BorderLayout(6, 6)){

                public String getUIClassID() {
                    return "WizardUI";
                }
            });
            ((JComponent)this.dialog.getContentPane()).setBorder(BorderFactory.createMatteBorder(0, 0, 0, 0, this.dialog.getContentPane().getBackground()));
            this.dialog.getContentPane().add((Component)this.getMessageArea(), "North");
            this.dialog.getContentPane().add((Component)this.getOptionArea(), "Center");
            this.dialog.getRootPane().setDefaultButton(((JButton[])this.getOptionArea().getOptions())[2]);
        }
        return this.dialog;
    }

    protected _WizardLabel getMessageArea() {
        if (this.messageArea == null) {
            this.messageArea = new _WizardLabel();
        }
        return this.messageArea;
    }

    protected abstract Object getResult();

    public int getStepCount() {
        return this.stepCount;
    }

    public void setStepCount(int stepCount) {
        this.stepCount = stepCount;
    }

    public int getWindowWidth() {
        return this.width;
    }

    public void setWindowWidth(int width) {
        this.width = width;
    }

    public int getWindowHeight() {
        return this.height;
    }

    public void setWindowHeight(int height) {
        this.height = height;
    }

    protected JPanel getWorkPanel() {
        if (this.workPanel == null) {
            this.workPanel = new JPanel(new QueueLayout(4, 0, 2));
            this.workPanel.setBorder(new EmptyBorder(0, 5, 0, 5));
            this.workPanel.setOpaque(false);
        }
        return this.workPanel;
    }

    public boolean isBusy() {
        return this.busy;
    }

    public Object launchWizard(Object object, String message, Component caller) {
        this.busy = true;
        this.dialog = null;
        this.currentStep = 1;
        this.reset();
        this.caller = caller;
        this.userObject = object;
        this.getMessageArea().setText(message);
        this.evaluateActions();
        this.evaluateCurrentStep();
        return this.getResult();
    }

    protected void nextStep() {
        ++this.currentStep;
    }

    protected void previousStep() {
        --this.currentStep;
    }

    protected abstract void reset();

    protected abstract void rollBack();

    protected void setBackwardAllowed(boolean b) {
        ((JButton[])this.getOptionArea().getOptions())[0].setEnabled(b);
    }

    protected boolean isBackwardAllowed() {
        return ((JButton[])this.getOptionArea().getOptions())[0].isEnabled();
    }

    protected void setForwardAllowed(boolean b) {
        ((JButton[])this.getOptionArea().getOptions())[1].setEnabled(b);
    }

    protected boolean isForwardAllowed() {
        return ((JButton[])this.getOptionArea().getOptions())[1].isEnabled();
    }

    protected void centerDialog() {
        if (!this.wasCentered) {
            Window parentWindow;
            Window window = parentWindow = this.caller != null ? SwingUtilities.windowForComponent(this.caller) : null;
            if (parentWindow != null) {
                if (this.dialog != null) {
                    this.getDialog().setLocation((int)(parentWindow.getLocation().getX() + (double)((parentWindow.getWidth() - this.getDialog().getWidth()) / 2)), (int)(parentWindow.getLocation().getY() + (double)((parentWindow.getHeight() - this.getDialog().getHeight()) / 2)));
                }
                if (this.frame != null) {
                    this.getFrame().setLocation((int)(parentWindow.getLocation().getX() + (double)((parentWindow.getWidth() - this.getFrame().getWidth()) / 2)), (int)(parentWindow.getLocation().getY() + (double)((parentWindow.getHeight() - this.getFrame().getHeight()) / 2)));
                }
            } else {
                if (this.dialog != null) {
                    this.getDialog().setLocation(Toolkit.getDefaultToolkit().getScreenSize().width / 2 - this.getDialog().getWidth() / 2, Toolkit.getDefaultToolkit().getScreenSize().height / 2 - this.getDialog().getHeight() / 2);
                }
                if (this.frame != null) {
                    this.getFrame().setLocation(Toolkit.getDefaultToolkit().getScreenSize().width / 2 - this.getFrame().getWidth() / 2, Toolkit.getDefaultToolkit().getScreenSize().height / 2 - this.getFrame().getHeight() / 2);
                }
            }
            this.wasCentered = !this.wasCentered;
        }
    }

    protected static class AnOptionPane
    extends JOptionPane {
        protected JButton[] buttons = null;

        public AnOptionPane(JButton[] buttons) {
            this.buttons = buttons;
        }

        public Object[] getOptions() {
            return this.buttons;
        }

        public Color getBackground() {
            return UIManager.getColor("Wizard.background");
        }
    }
}

