/*
 * Decompiled with CFR 0.152.
 */
package com.shfarr.ui.wizards;

import com.shfarr.ui.wizards.Wizard;
import java.util.Vector;

public class WizardManager {
    protected static WizardManager currentManager = null;
    protected Vector pool = new Vector();
    protected int poolSize = 10;

    protected WizardManager() {
    }

    protected Wizard createWizard(String job) {
        try {
            return (Wizard)Class.forName(System.getProperty("ui.wizardry.jobs." + job)).newInstance();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static WizardManager getCurrentManager() {
        if (currentManager == null) {
            currentManager = new WizardManager();
        }
        return currentManager;
    }

    public int getPoolSize() {
        return this.poolSize;
    }

    public Wizard hireWizard(String job) {
        Wizard wizard = null;
        int i = 0;
        while (i < this.pool.size()) {
            if (((Wizard)this.pool.get(i)).canDo(job) && !((Wizard)this.pool.get(i)).isBusy()) {
                wizard = (Wizard)this.pool.get(i);
                break;
            }
            ++i;
        }
        if (wizard == null && (wizard = this.createWizard(job)) != null) {
            i = 0;
            while (i < this.pool.size() && this.pool.size() < this.getPoolSize() - 1) {
                if (!((Wizard)this.pool.get(i)).isBusy()) {
                    this.pool.remove(i);
                    --i;
                }
                ++i;
            }
            this.pool.add(wizard);
        }
        return wizard;
    }

    public void setPoolSize(int newPoolSize) {
        this.poolSize = newPoolSize;
    }
}

