/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.pda_utils;

import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class PdaInputDialog {
    private String[] result;
    private boolean set = false;
    private Text[] texts;
    private Shell dialog;

    public PdaInputDialog(Display display, String[] fields, String[] defaults, String title) {
        this(new Shell(display, 64), fields, defaults, title);
    }

    public PdaInputDialog(final Shell dialog, String[] fields, String[] defaults, String title) {
        this.dialog = dialog;
        this.result = new String[fields.length];
        this.texts = new Text[fields.length];
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        dialog.setLayout((Layout)gridLayout);
        dialog.setText(title);
        for (int i = 0; i < fields.length; ++i) {
            Label l = new Label((Composite)dialog, 0);
            l.setText(fields[i]);
            this.texts[i] = new Text((Composite)dialog, 2048);
            this.texts[i].setText(defaults[i]);
            this.texts[i].setLayoutData((Object)new GridData(4, 4, true, false));
            final Text t = this.texts[i];
            this.texts[i].addFocusListener(new FocusListener(){

                public void focusGained(FocusEvent arg0) {
                    t.setSelection(0, t.getText().length());
                }

                public void focusLost(FocusEvent arg0) {
                }
            });
        }
        Button ok = new Button((Composite)dialog, 8);
        ok.setText("OK");
        ok.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PdaInputDialog.this.set = true;
                for (int i = 0; i < PdaInputDialog.this.texts.length; ++i) {
                    ((PdaInputDialog)PdaInputDialog.this).result[i] = PdaInputDialog.this.texts[i].getText();
                }
                dialog.close();
            }
        });
        ok.setLayoutData((Object)new GridData(4, 4, true, false));
        Button cancel = new Button((Composite)dialog, 8);
        cancel.setText("Cancel");
        cancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                dialog.close();
            }
        });
        cancel.setLayoutData((Object)new GridData(4, 4, true, false));
        dialog.setDefaultButton(ok);
        dialog.open();
    }

    public void setDisposeListener(DisposeListener lis) {
        this.dialog.addDisposeListener(lis);
    }

    public boolean isSet() {
        return this.set;
    }

    public String[] getResults() {
        return this.result;
    }
}

