/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.vp_pda.v4;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.ConnectException;
import java.net.Socket;
import java.util.Hashtable;
import java.util.Vector;
import ro.atreides.utils.Logger;
import ro.atreides.vp_pda.v4.Config3;
import ro.atreides.vp_pda.v4.MessageListener;
import ro.atreides.vp_pda.v4.messages.AbstractMessage;

public class ConnectionLogic {
    private static ConnectionLogic instance;
    private boolean isConnected = false;
    private ObjectOutputStream outS;
    private ObjectInputStream inputS;
    private Vector outQueue = new Vector();
    private Vector inputQueue = new Vector();
    private Socket socket;
    private Hashtable messagesListeners = new Hashtable();

    private ConnectionLogic() {
        Thread connectionThread = new Thread(new Runnable(){

            public void run() {
                while (true) {
                    if (!ConnectionLogic.this.isConnected()) {
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                        }
                        try {
                            ConnectionLogic.this.connect();
                        }
                        catch (ConnectException e) {
                            System.out.println("Conexiune neefectuata. Verificati reteaua wireless");
                            Logger.logException((Object)this, (Exception)e);
                            ConnectionLogic.this.disconnect();
                        }
                        catch (IOException e) {
                            System.out.println("Conexiune neefectuata. Verificati reteaua wireless");
                            Logger.logException((Object)this, (Exception)e);
                            ConnectionLogic.this.disconnect();
                        }
                        continue;
                    }
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                    }
                }
            }
        });
        connectionThread.setName(ConnectionLogic.class.getName() + "_ConnectionThread");
        connectionThread.start();
        Thread senderThread = new Thread(new Runnable(){

            public void run() {
                block8: while (true) {
                    try {
                        while (true) {
                            if (!ConnectionLogic.this.isConnected()) {
                                try {
                                    Thread.sleep(100L);
                                }
                                catch (Exception e) {}
                                continue;
                            }
                            if (ConnectionLogic.this.outQueue.size() > 0) {
                                AbstractMessage toSend = (AbstractMessage)ConnectionLogic.this.outQueue.get(0);
                                if (toSend == null) continue;
                                try {
                                    ConnectionLogic.this.outS.writeObject(toSend);
                                    ConnectionLogic.this.outS.flush();
                                    ConnectionLogic.this.outQueue.remove(0);
                                    continue block8;
                                }
                                catch (IOException e) {
                                    Logger.logException((Object)this, (Exception)e);
                                    ConnectionLogic.this.disconnect();
                                    continue;
                                }
                            }
                            try {
                                Thread.sleep(100L);
                                continue block8;
                            }
                            catch (InterruptedException e) {
                                continue;
                            }
                            break;
                        }
                    }
                    catch (Throwable th) {
                        Logger.logError((Object)this, (Throwable)th);
                        continue;
                    }
                    break;
                }
            }
        });
        senderThread.setName(ConnectionLogic.class.getName() + "_SenderThread");
        senderThread.start();
        Thread receiverThread = new Thread(new Runnable(){

            public void run() {
                while (true) {
                    try {
                        while (true) {
                            if (!ConnectionLogic.this.isConnected()) {
                                try {
                                    Thread.sleep(100L);
                                }
                                catch (Exception e) {}
                                continue;
                            }
                            AbstractMessage message = (AbstractMessage)ConnectionLogic.this.inputS.readObject();
                            if (message == null) continue;
                            MessageListener listener = (MessageListener)ConnectionLogic.this.messagesListeners.get(message.getClass());
                            if (listener == null) {
                                ConnectionLogic.this.inputQueue.add(message);
                                continue;
                            }
                            listener.messageReceived(message);
                        }
                    }
                    catch (IOException e) {
                        System.out.println("Receiver thread : 2");
                        Logger.logException((Object)this, (Exception)e);
                        ConnectionLogic.this.disconnect();
                        continue;
                    }
                    catch (Throwable th) {
                        System.out.println("Receiver thread : 3");
                        Logger.logError((Object)this, (Throwable)th);
                        continue;
                    }
                    break;
                }
            }
        });
        receiverThread.setName(ConnectionLogic.class.getName() + "_ReceiverThread");
        receiverThread.start();
    }

    public void disconnect() {
        this.isConnected = false;
        System.out.println("Disconnecting");
        try {
            if (this.inputS != null) {
                this.inputS.close();
            }
            this.inputS = null;
            if (this.outS != null) {
                this.outS.close();
            }
            this.outS = null;
            if (this.socket != null) {
                this.socket.close();
            }
            this.socket = null;
        }
        catch (IOException e) {
            Logger.logException((Object)this, (Exception)e);
        }
        Logger.logInfo((Object)this, (String)("Disconnected from : " + Config3.serverIp + " : " + Config3.serverPort));
        System.out.println("Disconnected from : " + Config3.serverIp + " : " + Config3.serverPort);
    }

    private void connect() throws IOException, ConnectException {
        System.out.println("Connecting to : " + Config3.serverIp + " : " + Config3.serverPort);
        Socket s = new Socket(Config3.serverIp, Config3.serverPort);
        this.socket.setSoLinger(true, 0);
        this.socket.setTcpNoDelay(true);
        this.outS = new ObjectOutputStream(s.getOutputStream());
        this.outS.flush();
        InputStream ins = s.getInputStream();
        this.inputS = new ObjectInputStream(ins);
        this.socket = s;
        this.isConnected = true;
        Logger.logInfo((Object)this, (String)("ConnectED to : " + Config3.serverIp + " : " + Config3.serverPort));
        System.out.println("ConnectED to : " + Config3.serverIp + " : " + Config3.serverPort);
    }

    public void addMessageListener(Class messageType, MessageListener listener) {
        this.messagesListeners.put(messageType, listener);
    }

    public void sendMessage(AbstractMessage toSend) {
        this.outQueue.add(toSend);
    }

    public boolean isConnected() {
        return this.isConnected;
    }

    public static synchronized ConnectionLogic getInstance() {
        if (instance == null) {
            instance = new ConnectionLogic();
        }
        return instance;
    }
}

