/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.vp_pda.v4;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import ro.atreides.pda_utils.PdaErrorDialog;
import ro.atreides.pda_utils.PdaUtils;
import ro.atreides.utils.Utils;
import ro.atreides.utils.gui.Validators;
import ro.atreides.vp_pda.v2.Categorie;
import ro.atreides.vp_pda.v2.Product;
import ro.atreides.vp_pda.v2.Sectie;
import ro.atreides.vp_pda.v4.Config3;
import ro.atreides.vp_pda.v4.OrderPanel;
import ro.atreides.vp_pda.v4.PdaLogic3;
import ro.atreides.vp_pda.v4.ProductDetails;
import ro.atreides.vp_pda.v4.Sale;
import ro.atreides.vp_pda.v4.Table3;
import ro.atreides.vp_pda.v4.TablesPanel;

public class PreorderPanel {
    private Vector presales = new Vector();
    private PdaLogic3 logic;
    private Hashtable selectorBodyItems = new Hashtable();
    private int currentPage = 0;
    private Sectie currentSectie;
    private Vector currentData;
    private Table3 currentTable;
    private MenuItem totalMenuItem;
    private MenuItem masaMenuItem;
    private MenuItem platouMI;
    private Shell parentShell;
    private static final String PLATOU_START = "Platou start";
    private static final String PLATOU_STOP = "Platou gata";
    private int idPlatou = -1;

    public PreorderPanel(Shell parentShell, final PdaLogic3 logic, Table3 masa) {
        int i;
        this.parentShell = parentShell;
        this.logic = logic;
        this.currentTable = masa;
        int close = Config3.closeMode ? 80 : 0;
        final Shell preorderShell = new Shell(parentShell, close);
        final Table salesTable = new Table((Composite)preorderShell, 2560);
        salesTable.setHeaderVisible(true);
        salesTable.setLinesVisible(true);
        int salesColumnCount = 3;
        TableColumn felC = new TableColumn(salesTable, 0);
        felC.setText("Fel");
        TableColumn produsC = new TableColumn(salesTable, 0);
        produsC.setText("_________Produs________");
        TableColumn cantC = new TableColumn(salesTable, 0);
        cantC.setText("_Cant_");
        for (int i2 = 0; i2 < 3; ++i2) {
            salesTable.getColumn(i2).pack();
        }
        salesTable.pack();
        salesTable.addListener(3, new Listener(){

            public void handleEvent(Event event) {
                Point pt = new Point(event.x, event.y);
                Rectangle clientArea = salesTable.getClientArea();
                boolean stop = false;
                for (int index = salesTable.getTopIndex(); !stop && index < salesTable.getItemCount(); ++index) {
                    boolean visible = false;
                    TableItem item = salesTable.getItem(index);
                    for (int i = 0; i < 3; ++i) {
                        Rectangle rect = item.getBounds(i);
                        if (rect.contains(pt)) {
                            PreorderPanel.this.editSale(preorderShell, index, i, salesTable);
                            stop = true;
                            break;
                        }
                        if (visible || !rect.intersects(clientArea)) continue;
                        visible = true;
                    }
                    if (visible) continue;
                    return;
                }
            }
        });
        final Table selectorHeader = new Table((Composite)preorderShell, 2560);
        selectorHeader.setHeaderVisible(false);
        selectorHeader.setLinesVisible(true);
        TableColumn sectieC = new TableColumn(selectorHeader, 0);
        sectieC.setText("__Sectie__");
        TableColumn categorieC = new TableColumn(selectorHeader, 0);
        categorieC.setText("__Categorie___");
        TableColumn leftC = new TableColumn(selectorHeader, 0);
        leftC.setText("<<");
        TableColumn rightC = new TableColumn(selectorHeader, 0);
        rightC.setText(">>");
        TableItem item = new TableItem(selectorHeader, 0);
        item.setText(0, "Sectie");
        item.setText(1, "Categorie");
        item.setText(2, "<<");
        item.setText(3, ">>");
        for (int i3 = 0; i3 < 4; ++i3) {
            selectorHeader.getColumn(i3).pack();
        }
        final Table selectorBody = new Table((Composite)preorderShell, 2560);
        selectorBody.setHeaderVisible(false);
        selectorBody.setLinesVisible(true);
        for (i = 0; i < Config3.selectorItemsPerLine; ++i) {
            TableColumn col = new TableColumn(selectorBody, 0);
            col.setText("12345678901234567");
        }
        this.fillSelectorBody(logic.getSections(), 0, selectorBody);
        for (i = 0; i < Config3.selectorItemsPerLine; ++i) {
            selectorBody.getColumn(i).pack();
        }
        selectorBody.addListener(3, new Listener(){

            public void handleEvent(Event event) {
                Rectangle clientArea = selectorBody.getClientArea();
                Point pt = new Point(event.x, event.y);
                boolean stop = false;
                for (int index = selectorBody.getTopIndex(); !stop && index < selectorBody.getItemCount(); ++index) {
                    boolean visible = false;
                    TableItem item = selectorBody.getItem(index);
                    for (int i = 0; i < Config3.selectorItemsPerLine; ++i) {
                        Rectangle rect = item.getBounds(i);
                        if (rect.contains(pt)) {
                            Object o = PreorderPanel.this.selectorBodyItems.get(index + "_" + i);
                            PreorderPanel.this.selectorBodySelected(o, salesTable, selectorBody);
                            stop = true;
                            break;
                        }
                        if (visible || !rect.intersects(clientArea)) continue;
                        visible = true;
                    }
                    if (visible) continue;
                    return;
                }
            }
        });
        selectorHeader.addListener(3, new Listener(){

            public void handleEvent(Event event) {
                Rectangle clientArea = selectorHeader.getClientArea();
                Point pt = new Point(event.x, event.y);
                boolean stop = false;
                for (int index = selectorHeader.getTopIndex(); !stop && index < selectorHeader.getItemCount(); ++index) {
                    boolean visible = false;
                    TableItem item = selectorHeader.getItem(index);
                    for (int i = 0; i < 4; ++i) {
                        Rectangle rect = item.getBounds(i);
                        if (rect.contains(pt)) {
                            switch (i) {
                                case 0: {
                                    item.setText(0, "Sectie");
                                    PreorderPanel.this.currentPage = 0;
                                    PreorderPanel.this.fillSelectorBody(logic.getSections(), PreorderPanel.this.currentPage, selectorBody);
                                    break;
                                }
                                case 1: {
                                    item.setText(1, "Categorie");
                                    PreorderPanel.this.currentPage = 0;
                                    PreorderPanel.this.selectorBodySelected(PreorderPanel.this.currentSectie, salesTable, selectorBody);
                                    break;
                                }
                                case 2: {
                                    if (PreorderPanel.this.currentPage <= 0) break;
                                    PreorderPanel.this.currentPage--;
                                    PreorderPanel.this.fillSelectorBody(PreorderPanel.this.currentData, PreorderPanel.this.currentPage, selectorBody);
                                    break;
                                }
                                case 3: {
                                    PreorderPanel.this.currentPage++;
                                    PreorderPanel.this.fillSelectorBody(PreorderPanel.this.currentData, PreorderPanel.this.currentPage, selectorBody);
                                    break;
                                }
                            }
                            stop = true;
                            break;
                        }
                        if (visible || !rect.intersects(clientArea)) continue;
                        visible = true;
                    }
                    if (visible) continue;
                    return;
                }
            }
        });
        this.buildMenu(preorderShell);
        salesTable.setBounds(0, 0, 240, 142);
        selectorHeader.setBounds(0, 143, 240, 20);
        selectorBody.setBounds(0, 162, 240, 130);
        preorderShell.setSize(240, Config3.dY);
        preorderShell.open();
    }

    private void buildMenu(final Shell preorderShell) {
        Menu menu = new Menu((Decorations)preorderShell, 2);
        preorderShell.setMenuBar(menu);
        MenuItem actiuni = new MenuItem(menu, 64);
        actiuni.setText("Actiuni");
        Menu actiuniMenu = new Menu(actiuni);
        actiuni.setMenu(actiuniMenu);
        MenuItem marcaj = new MenuItem(actiuniMenu, 8);
        marcaj.setText("Marcaj");
        marcaj.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (PreorderPanel.this.presales.size() > 0) {
                    PreorderPanel.this.marcaj();
                    Shell parentShell = preorderShell.getParent().getShell();
                    preorderShell.close();
                    new OrderPanel(parentShell, PreorderPanel.this.logic, PreorderPanel.this.currentTable);
                }
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                this.widgetSelected(selectionEvent);
            }
        });
        new MenuItem(actiuniMenu, 2);
        this.platouMI = new MenuItem(actiuniMenu, 8);
        this.platouMI.setText(PLATOU_START);
        this.platouMI.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (PreorderPanel.this.platouMI.getText().equalsIgnoreCase(PreorderPanel.PLATOU_START)) {
                    PreorderPanel.this.platouMI.setText(PreorderPanel.PLATOU_STOP);
                    PreorderPanel.this.idPlatou++;
                    PreorderPanel.this.currentTable.setMaxPlatou(PreorderPanel.this.idPlatou);
                } else {
                    PreorderPanel.this.platouMI.setText(PreorderPanel.PLATOU_START);
                }
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                this.widgetSelected(selectionEvent);
            }
        });
        new MenuItem(actiuniMenu, 2);
        MenuItem mese = new MenuItem(actiuniMenu, 8);
        mese.setText("Mese");
        mese.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (PreorderPanel.this.presales.size() > 0) {
                    new PdaErrorDialog(PreorderPanel.this.parentShell, "Exista produse nemarcate", "Nu pot continua");
                } else {
                    new TablesPanel(PreorderPanel.this.parentShell, PreorderPanel.this.logic);
                    preorderShell.close();
                }
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                this.widgetSelected(selectionEvent);
            }
        });
        MenuItem comanda = new MenuItem(actiuniMenu, 8);
        comanda.setText("Comanda");
        comanda.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (PreorderPanel.this.presales.size() > 0) {
                    new PdaErrorDialog(PreorderPanel.this.parentShell, "Exista produse nemarcate", "Nu pot continua");
                } else {
                    new OrderPanel(PreorderPanel.this.parentShell, PreorderPanel.this.logic, PreorderPanel.this.currentTable);
                    preorderShell.close();
                }
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                this.widgetSelected(selectionEvent);
            }
        });
        new MenuItem(actiuniMenu, 2);
        new MenuItem(actiuniMenu, 2);
        MenuItem mesaje = new MenuItem(actiuniMenu, 8);
        mesaje.setText(this.logic.getNotificationsString());
        mesaje.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                PreorderPanel.this.logic.notificationsAcknoledged();
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                this.widgetSelected(selectionEvent);
            }
        });
        new MenuItem(actiuniMenu, 2);
        new MenuItem(actiuniMenu, 2);
        if (this.currentTable.getStatus() == -1) {
            comanda.setEnabled(false);
        }
        this.totalMenuItem = new MenuItem(actiuniMenu, 8);
        this.totalMenuItem.setText("Total");
        this.masaMenuItem = new MenuItem(actiuniMenu, 8);
        this.masaMenuItem.setText(this.currentTable.getLabel() + " " + this.logic.getLocatie().getLabel());
    }

    private void marcaj() {
        this.logic.marcaj(this.presales, this.currentTable.getId());
    }

    private void fillSelectorBody(Vector newData, int page, Table selectorBody) {
        selectorBody.removeAll();
        int startIndex = page * Config3.selectorLinesPerPage * Config3.selectorItemsPerLine;
        if (startIndex < newData.size()) {
            boolean stop = false;
            int currentIndex = startIndex;
            int line = 0;
            while (!stop) {
                TableItem item1 = new TableItem(selectorBody, 0);
                for (int i = 0; i < Config3.selectorItemsPerLine && !stop; ++i) {
                    Object o = newData.get(currentIndex);
                    item1.setText(i, o.toString());
                    this.selectorBodyItems.put(line + "_" + i, o);
                    stop = ++currentIndex >= newData.size() || currentIndex >= startIndex + Config3.selectorLinesPerPage * Config3.selectorItemsPerLine;
                }
                ++line;
            }
        }
        this.currentData = newData;
    }

    private void selectorBodySelected(Object o, Table salesTable, Table selectorBody) {
        if (o instanceof Sectie) {
            Sectie s;
            this.currentSectie = s = (Sectie)o;
            Vector categorii = this.logic.getCategoriesForSectie(s.getId());
            this.fillSelectorBody(categorii, 0, selectorBody);
        } else if (o instanceof Categorie) {
            Categorie c = (Categorie)o;
            Vector produse = this.logic.getProduseForCategorie(c.getIdCategorie());
            this.fillSelectorBody(produse, 0, selectorBody);
        } else if (o instanceof Product) {
            Product p = (Product)o;
            int id1 = -1;
            if (this.platouMI.getText().equalsIgnoreCase(PLATOU_STOP)) {
                id1 = this.idPlatou;
            }
            this.addProductLaPrecomanda(p, 1.0f, salesTable, id1);
        }
    }

    private void addProductLaPrecomanda(Product p, float quantity, Table salesTable, int idPlatou) {
        Sale s = new Sale(p.getIdProduct(), p.getName(), p.getPret(), quantity, idPlatou);
        this.presales.add(s);
        this.refreshPreorderPanel(true, salesTable);
    }

    private void refreshPreorderPanel(boolean scroll, Table salesTable) {
        float total = 0.0f;
        Iterator iterator = this.presales.iterator();
        while (iterator.hasNext()) {
            Sale i = (Sale)iterator.next();
            total += i.getCantitateNoua() * i.getPret();
        }
        this.totalMenuItem.setText("Total: " + Utils.getString2Decimals((float)total));
        salesTable.removeAll();
        iterator = this.presales.iterator();
        while (iterator.hasNext()) {
            Sale s = (Sale)iterator.next();
            TableItem item1 = new TableItem(salesTable, 0);
            item1.setText(0, "");
            String s1 = s.getNumeProdus();
            if (Validators.correctString((String)s.getPreparare())) {
                s1 = s1 + " (" + s.getPreparare() + ")";
            }
            item1.setText(1, s1);
            item1.setText(2, Utils.getString3Decimals((float)s.getCantitateNoua()));
            Color c = PdaUtils.getTableBgColor(s.getIdPlatou(), this.parentShell.getDisplay());
            item1.setBackground(c);
        }
        if (scroll) {
            int maxItems = 5;
            if (this.presales.size() > maxItems) {
                int preorderTopIndex = this.presales.size() - maxItems;
                salesTable.setTopIndex(preorderTopIndex);
            }
        }
    }

    private void editSale(Shell preorderShell, final int index, int i, final Table salesTable) {
        final Sale s = (Sale)this.presales.get(index);
        final ProductDetails pd = new ProductDetails(preorderShell, s);
        DisposeListener lis = new DisposeListener(){

            public void widgetDisposed(DisposeEvent arg0) {
                if (pd.isSet()) {
                    float q = pd.getCantitate();
                    System.out.println("New quantity: " + q);
                    if (q > 0.0f) {
                        s.setCantitateNoua(q);
                        s.setPreparare(pd.getPreparare());
                    } else {
                        System.out.println("Din sales stergem: " + s.getNumeProdus());
                        PreorderPanel.this.presales.remove(index);
                    }
                    PreorderPanel.this.refreshPreorderPanel(false, salesTable);
                }
            }
        };
        pd.setDisposeListener(lis);
    }
}

