/*
 * Decompiled with CFR 0.152.
 */
package nu.xom;

import java.util.ArrayList;
import nu.xom.NamespaceConflictException;

final class NamespacesInScope {
    private final ArrayList prefixes = new ArrayList();
    private final ArrayList uris = new ArrayList();

    NamespacesInScope() {
        this.reset();
    }

    public void reset() {
        this.prefixes.clear();
        this.uris.clear();
        this.prefixes.add("");
        this.uris.add("");
    }

    public void push() {
        this.prefixes.add(null);
        this.uris.add(null);
    }

    public void pop() {
        int i = this.prefixes.size();
        while (--i >= 0) {
            this.uris.remove(i);
            if (this.prefixes.remove(i) != null) continue;
            return;
        }
        throw new IllegalStateException("NamespacesInScope stack underflow: pop() called more often than push()");
    }

    public boolean addIfAbsent(String prefix, String uri) {
        if (prefix == null) {
            prefix = "";
        }
        if (uri == null) {
            uri = "";
        }
        int i = this.prefixes.size();
        boolean inCurrent = true;
        while (--i >= 0) {
            String existingPrefix = (String)this.prefixes.get(i);
            if (existingPrefix == null) {
                inCurrent = false;
                continue;
            }
            if (prefix.equals(existingPrefix)) break;
        }
        if (inCurrent && i >= 0) {
            this.checkNamespaceConflict(i, uri);
        } else if (i < 0 || !uri.equals(this.uris.get(i))) {
            if (i < 0) {
                NamespacesInScope.checkPrefix(prefix);
            }
            NamespacesInScope.checkNamespaceURI(uri);
            this.prefixes.add(prefix);
            this.uris.add(uri);
            return true;
        }
        return false;
    }

    private void checkNamespaceConflict(int i, String uri) {
        String existingURI = (String)this.uris.get(i);
        if (!uri.equals(existingURI)) {
            String prefix = (String)this.prefixes.get(i);
            String message = prefix.length() == 0 ? "Additional namespace " + uri + " conflicts with existing default namespace " + existingURI : "Additional namespace " + uri + " for the prefix " + prefix + " conflicts with existing namespace binding " + existingURI;
            throw new NamespaceConflictException(message);
        }
    }

    private static void checkPrefix(String prefix) {
    }

    private static void checkNamespaceURI(String uri) {
    }
}

