/*
 * Decompiled with CFR 0.152.
 */
package nu.xom;

import nu.xom.Element;
import nu.xom.NoSuchChildException;
import nu.xom.Node;
import nu.xom.Verifier;

public abstract class ParentNode
extends Node {
    Node[] children;
    int childCount = 0;
    String actualBaseURI;

    ParentNode() {
    }

    public int getChildCount() {
        return this.childCount;
    }

    public void insertChild(Node child, int position) {
        this._insertChild(child, position);
    }

    final void _insertChild(Node child, int position) {
        this.insertionAllowed(child, position);
        this.fastInsertChild(child, position);
    }

    public final void fastInsertChild(Node child, int position) {
        this.checkCapacity(this.childCount + 1);
        if (position < this.childCount) {
            System.arraycopy(this.children, position, this.children, position + 1, this.childCount - position);
        }
        this.children[position] = child;
        ++this.childCount;
        child.setParent(this);
        child.setSiblingPosition(position);
        int i = this.childCount;
        while (--i > position) {
            this.children[i].setSiblingPosition(i);
        }
    }

    private void checkCapacity(int position) {
        if (this.children == null) {
            this.children = new Node[1];
        } else if (position >= this.children.length) {
            Node[] data = new Node[this.children.length * 2];
            System.arraycopy(this.children, 0, data, 0, this.children.length);
            this.children = data;
        }
    }

    abstract void insertionAllowed(Node var1, int var2);

    public void appendChild(Node child) {
        this.insertChild(child, this.childCount);
    }

    public Node getChild(int position) {
        if (this.children == null) {
            throw new IndexOutOfBoundsException("This node has no children");
        }
        return this.children[position];
    }

    public int indexOf(Node child) {
        return child != null && child.getParent() == this ? child.getSiblingPosition() : -1;
    }

    public Node removeChild(int position) {
        int toCopy;
        if (this.children == null) {
            throw new IndexOutOfBoundsException("This node has no children");
        }
        Node removed = this.children[position];
        if (removed.isElement()) {
            this.fillInBaseURI((Element)removed);
        }
        if ((toCopy = this.childCount - position - 1) > 0) {
            System.arraycopy(this.children, position + 1, this.children, position, toCopy);
        }
        --this.childCount;
        this.children[this.childCount] = null;
        removed.setParent(null);
        int i = this.childCount;
        while (--i >= position) {
            this.children[i].setSiblingPosition(i);
        }
        return removed;
    }

    void fillInBaseURI(Element removed) {
        ParentNode parent = removed;
        String actualBaseURI = "";
        while (parent != null && actualBaseURI.length() == 0) {
            actualBaseURI = parent.getActualBaseURI();
            parent = parent.getParent();
        }
        removed.setActualBaseURI(actualBaseURI);
    }

    public Node removeChild(Node child) {
        int position = this.indexOf(child);
        if (position == -1) {
            throw new NoSuchChildException("Child does not belong to this node");
        }
        this.removeChild(position);
        return child;
    }

    public void replaceChild(Node oldChild, Node newChild) {
        if (oldChild == null) {
            throw new NullPointerException("Tried to replace null child");
        }
        if (newChild == null) {
            throw new NullPointerException("Tried to replace child with null");
        }
        int position = this.indexOf(oldChild);
        if (position == -1) {
            throw new NoSuchChildException("Reference node is not a child of this node.");
        }
        if (oldChild == newChild) {
            return;
        }
        this.insertionAllowed(newChild, position);
        this.removeChild(position);
        this.insertChild(newChild, position);
    }

    public abstract void setBaseURI(String var1);

    String getActualBaseURI() {
        if (this.actualBaseURI == null) {
            return "";
        }
        return this.actualBaseURI;
    }

    void setActualBaseURI(String uri) {
        if (uri == null) {
            uri = "";
        }
        if (uri.length() != 0) {
            Verifier.checkAbsoluteURI(uri);
        }
        this.actualBaseURI = uri;
    }

    final String findActualBaseURI() {
        String actualBase;
        ParentNode current = this;
        do {
            actualBase = current.getActualBaseURI();
        } while ((current = current.getParent()) != null && actualBase.length() == 0);
        return actualBase;
    }
}

