/*
 * Decompiled with CFR 0.152.
 */
package nu.xom;

import nu.xom.LRUHashMap;
import nu.xom.QName;

public final class QNameCache {
    private final LRUHashMap entries = new LRUHashMap(256);

    public QName getQName(QName qname) {
        QName cached = (QName)this.entries.get(qname);
        if (cached == null) {
            this.entries.put(qname, qname);
            cached = qname;
        }
        return cached;
    }

    private static final class LRUMicroCache {
        private final QName[] qnames;
        private int hits;
        private int misses;

        public LRUMicroCache() {
            this(16);
        }

        public LRUMicroCache(int size) {
            if (size <= 0) {
                throw new IllegalArgumentException();
            }
            this.qnames = new QName[size];
        }

        public QName get(String name, String uri) {
            QName qname;
            int len = this.qnames.length;
            int i = 0;
            while (i < len && (qname = this.qnames[i]) != null) {
                if (name == qname.getQualifiedName() && uri == qname.getNamespaceURI()) {
                    if (i > 0) {
                        System.arraycopy(this.qnames, 0, this.qnames, 1, i);
                        this.qnames[0] = qname;
                    }
                    ++this.hits;
                    return qname;
                }
                ++i;
            }
            ++this.misses;
            return null;
        }

        public void put(QName qname) {
            System.arraycopy(this.qnames, 0, this.qnames, 1, this.qnames.length - 1);
            this.qnames[0] = qname;
        }

        public String toString() {
            return "hits=" + this.hits + ", misses=" + this.misses;
        }
    }
}

