/*
 * Decompiled with CFR 0.152.
 */
package nu.xom;

import java.io.IOException;
import java.io.Writer;
import nu.xom.TextWriter;
import nu.xom.XMLException;

final class UnicodeWriter
extends TextWriter {
    UnicodeWriter(Writer out, String encoding) {
        super(out, encoding);
    }

    boolean needsEscaping(char c) {
        return false;
    }

    final void writeMarkup(String s) throws IOException {
        if (this.normalize) {
            s = this.normalize(s);
        }
        int i = 0;
        int length = s.length();
        while (i < length) {
            char c;
            int start = i;
            int unicodeLength = 0;
            while (i < length && !UnicodeWriter.mightNeedMarkupEscaping(c = s.charAt(i))) {
                if (c < '\ud800' || c > '\udbff') {
                    ++unicodeLength;
                }
                ++i;
            }
            if (i > start) {
                this.out.write(s, start, i - start);
                if (unicodeLength > 0) {
                    this.column += unicodeLength;
                    this.lastCharacterWasSpace = false;
                    this.skipFollowingLinefeed = false;
                    this.justBroke = false;
                }
            }
            while (i < length && UnicodeWriter.mightNeedMarkupEscaping(c = s.charAt(i))) {
                this.writeMarkup(c);
                ++i;
            }
        }
    }

    final void writePCDATA(String s) throws IOException {
        if (this.normalize) {
            s = this.normalize(s);
        }
        int i = 0;
        int length = s.length();
        while (i < length) {
            char c;
            int start = i;
            int unicodeLength = 0;
            while (i < length && !UnicodeWriter.mightNeedPCDATAEscaping(c = s.charAt(i))) {
                if (c < '\ud800' || c > '\udbff') {
                    ++unicodeLength;
                }
                ++i;
            }
            if (i > start) {
                this.out.write(s, start, i - start);
                if (unicodeLength > 0) {
                    this.column += unicodeLength;
                    this.lastCharacterWasSpace = false;
                    this.skipFollowingLinefeed = false;
                    this.justBroke = false;
                }
            }
            while (i < length && UnicodeWriter.mightNeedPCDATAEscaping(c = s.charAt(i))) {
                this.writePCDATA(c);
                ++i;
            }
        }
    }

    final void writeAttributeValue(String s) throws IOException {
        if (this.normalize) {
            s = this.normalize(s);
        }
        int i = 0;
        int length = s.length();
        while (i < length) {
            char c;
            int start = i;
            int unicodeLength = 0;
            while (i < length && !UnicodeWriter.mightNeedAttributeEscaping(c = s.charAt(i))) {
                if (c < '\ud800' || c > '\udbff') {
                    ++unicodeLength;
                }
                ++i;
            }
            if (i > start) {
                this.out.write(s, start, i - start);
                if (unicodeLength > 0) {
                    this.column += unicodeLength;
                    this.lastCharacterWasSpace = false;
                    this.skipFollowingLinefeed = false;
                    this.justBroke = false;
                }
            }
            while (i < length && UnicodeWriter.mightNeedAttributeEscaping(c = s.charAt(i))) {
                this.writeAttributeValue(c);
                ++i;
            }
        }
    }

    void writeName(String name) throws IOException {
        if (this.normalize) {
            name = this.normalize(name);
        }
        int unicodeStringLength = UnicodeWriter.getUnicodeLengthForName(name);
        this.out.write(name);
        this.column += unicodeStringLength;
        this.lastCharacterWasSpace = false;
        this.skipFollowingLinefeed = false;
        this.justBroke = false;
    }

    private static int getUnicodeLengthForName(String name) {
        int unicodeLength = 0;
        int javaLength = name.length();
        int i = 0;
        while (i < javaLength) {
            char c = name.charAt(i);
            if (c < '\ud800' || c > '\udbff') {
                ++unicodeLength;
            }
            ++i;
        }
        return unicodeLength;
    }

    private static boolean mightNeedMarkupEscaping(char c) {
        return c <= ' ';
    }

    private static boolean mightNeedPCDATAEscaping(char c) {
        switch (c) {
            case '&': {
                return true;
            }
            case '<': {
                return true;
            }
            case '>': {
                return true;
            }
            case '\r': {
                return true;
            }
            case '\t': {
                return true;
            }
            case '\n': {
                return true;
            }
            case ' ': {
                return true;
            }
        }
        return false;
    }

    private static boolean mightNeedAttributeEscaping(char c) {
        switch (c) {
            case '\t': {
                return true;
            }
            case '\n': {
                return true;
            }
            case '\"': {
                return true;
            }
            case '\r': {
                return true;
            }
            case '&': {
                return true;
            }
            case '<': {
                return true;
            }
            case '>': {
                return true;
            }
            case ' ': {
                return true;
            }
        }
        return false;
    }

    final void writeMarkupold(String s) throws IOException {
        int unicodeStringLength;
        if (this.normalize) {
            s = this.normalize(s);
        }
        if ((unicodeStringLength = UnicodeWriter.getUnicodeLengthForMarkup(s)) >= 0) {
            this.out.write(s);
            if (unicodeStringLength > 0) {
                this.column += unicodeStringLength;
                this.lastCharacterWasSpace = false;
                this.skipFollowingLinefeed = false;
                this.justBroke = false;
            }
        } else {
            int length = s.length();
            int i = 0;
            while (i < length) {
                this.writeMarkup(s.charAt(i));
                ++i;
            }
        }
    }

    private static int getUnicodeLengthForMarkup(String s) {
        int unicodeLength = 0;
        int javaLength = s.length();
        int i = 0;
        while (i < javaLength) {
            char c = s.charAt(i);
            if (c <= ' ') {
                return -1;
            }
            if (c < '\ud800' || c > '\udbff') {
                ++unicodeLength;
            }
            ++i;
        }
        return unicodeLength;
    }

    final void writeAttributeValueold(String s) throws IOException {
        int unicodeStringLength;
        if (this.normalize) {
            s = this.normalize(s);
        }
        if ((unicodeStringLength = UnicodeWriter.getUnicodeLengthForAttributeValue(s)) >= 0) {
            this.out.write(s);
            if (unicodeStringLength > 0) {
                this.column += unicodeStringLength;
                this.lastCharacterWasSpace = false;
                this.skipFollowingLinefeed = false;
                this.justBroke = false;
            }
        } else {
            int length = s.length();
            int i = 0;
            while (i < length) {
                this.writeAttributeValue(s.charAt(i));
                ++i;
            }
        }
    }

    private static int getUnicodeLengthForAttributeValue(String s) {
        int unicodeLength = 0;
        int javaLength = s.length();
        int i = 0;
        while (i < javaLength) {
            char c = s.charAt(i);
            switch (c) {
                case '\t': {
                    return -1;
                }
                case '\n': {
                    return -1;
                }
                case '\u000b': 
                case '\f': {
                    throw new XMLException("Bad character snuck into document");
                }
                case '\r': {
                    return -1;
                }
                case '\u000e': 
                case '\u000f': 
                case '\u0010': 
                case '\u0011': 
                case '\u0012': 
                case '\u0013': 
                case '\u0014': 
                case '\u0015': 
                case '\u0016': 
                case '\u0017': 
                case '\u0018': 
                case '\u0019': 
                case '\u001a': 
                case '\u001b': 
                case '\u001c': 
                case '\u001d': 
                case '\u001e': 
                case '\u001f': {
                    throw new XMLException("Bad character snuck into document");
                }
                case ' ': {
                    return -1;
                }
                case '!': {
                    ++unicodeLength;
                    break;
                }
                case '\"': {
                    return -1;
                }
                case '#': {
                    ++unicodeLength;
                    break;
                }
                case '$': {
                    ++unicodeLength;
                    break;
                }
                case '%': {
                    ++unicodeLength;
                    break;
                }
                case '&': {
                    return -1;
                }
                case '\'': {
                    ++unicodeLength;
                    break;
                }
                case '(': {
                    ++unicodeLength;
                    break;
                }
                case ')': {
                    ++unicodeLength;
                    break;
                }
                case '*': {
                    ++unicodeLength;
                    break;
                }
                case '+': {
                    ++unicodeLength;
                    break;
                }
                case ',': {
                    ++unicodeLength;
                    break;
                }
                case '-': {
                    ++unicodeLength;
                    break;
                }
                case '.': {
                    ++unicodeLength;
                    break;
                }
                case '/': {
                    ++unicodeLength;
                    break;
                }
                case '0': {
                    ++unicodeLength;
                    break;
                }
                case '1': {
                    ++unicodeLength;
                    break;
                }
                case '2': {
                    ++unicodeLength;
                    break;
                }
                case '3': {
                    ++unicodeLength;
                    break;
                }
                case '4': {
                    ++unicodeLength;
                    break;
                }
                case '5': {
                    ++unicodeLength;
                    break;
                }
                case '6': {
                    ++unicodeLength;
                    break;
                }
                case '7': {
                    ++unicodeLength;
                    break;
                }
                case '8': {
                    ++unicodeLength;
                    break;
                }
                case '9': {
                    ++unicodeLength;
                    break;
                }
                case ':': {
                    ++unicodeLength;
                    break;
                }
                case ';': {
                    ++unicodeLength;
                    break;
                }
                case '<': {
                    return -1;
                }
                case '=': {
                    ++unicodeLength;
                    break;
                }
                case '>': {
                    return -1;
                }
                default: {
                    if (c >= '\ud800' && c <= '\udbff') break;
                    ++unicodeLength;
                }
            }
            ++i;
        }
        return unicodeLength;
    }

    final void writePCDATAold(String s) throws IOException {
        int unicodeStringLength;
        if (this.normalize) {
            s = this.normalize(s);
        }
        if ((unicodeStringLength = UnicodeWriter.getUnicodeLengthForPCDATA(s)) >= 0) {
            this.out.write(s);
            if (unicodeStringLength > 0) {
                this.column += unicodeStringLength;
                this.lastCharacterWasSpace = false;
                this.skipFollowingLinefeed = false;
                this.justBroke = false;
            }
        } else {
            int length = s.length();
            int i = 0;
            while (i < length) {
                this.writePCDATA(s.charAt(i));
                ++i;
            }
        }
    }

    private static int getUnicodeLengthForPCDATA(String s) {
        int unicodeLength = 0;
        int javaLength = s.length();
        int i = 0;
        while (i < javaLength) {
            char c = s.charAt(i);
            switch (c) {
                case '\t': {
                    return -1;
                }
                case '\n': {
                    return -1;
                }
                case '\u000b': 
                case '\f': {
                    throw new XMLException("Bad character snuck into document");
                }
                case '\r': {
                    return -1;
                }
                case '\u000e': 
                case '\u000f': 
                case '\u0010': 
                case '\u0011': 
                case '\u0012': 
                case '\u0013': 
                case '\u0014': 
                case '\u0015': 
                case '\u0016': 
                case '\u0017': 
                case '\u0018': 
                case '\u0019': 
                case '\u001a': 
                case '\u001b': 
                case '\u001c': 
                case '\u001d': 
                case '\u001e': 
                case '\u001f': {
                    throw new XMLException("Bad character snuck into document");
                }
                case ' ': {
                    return -1;
                }
                case '!': {
                    ++unicodeLength;
                    break;
                }
                case '\"': {
                    ++unicodeLength;
                    break;
                }
                case '#': {
                    ++unicodeLength;
                    break;
                }
                case '$': {
                    ++unicodeLength;
                    break;
                }
                case '%': {
                    ++unicodeLength;
                    break;
                }
                case '&': {
                    return -1;
                }
                case '\'': {
                    ++unicodeLength;
                    break;
                }
                case '(': {
                    ++unicodeLength;
                    break;
                }
                case ')': {
                    ++unicodeLength;
                    break;
                }
                case '*': {
                    ++unicodeLength;
                    break;
                }
                case '+': {
                    ++unicodeLength;
                    break;
                }
                case ',': {
                    ++unicodeLength;
                    break;
                }
                case '-': {
                    ++unicodeLength;
                    break;
                }
                case '.': {
                    ++unicodeLength;
                    break;
                }
                case '/': {
                    ++unicodeLength;
                    break;
                }
                case '0': {
                    ++unicodeLength;
                    break;
                }
                case '1': {
                    ++unicodeLength;
                    break;
                }
                case '2': {
                    ++unicodeLength;
                    break;
                }
                case '3': {
                    ++unicodeLength;
                    break;
                }
                case '4': {
                    ++unicodeLength;
                    break;
                }
                case '5': {
                    ++unicodeLength;
                    break;
                }
                case '6': {
                    ++unicodeLength;
                    break;
                }
                case '7': {
                    ++unicodeLength;
                    break;
                }
                case '8': {
                    ++unicodeLength;
                    break;
                }
                case '9': {
                    ++unicodeLength;
                    break;
                }
                case ':': {
                    ++unicodeLength;
                    break;
                }
                case ';': {
                    ++unicodeLength;
                    break;
                }
                case '<': {
                    return -1;
                }
                case '=': {
                    ++unicodeLength;
                    break;
                }
                case '>': {
                    return -1;
                }
                default: {
                    if (c >= '\ud800' && c <= '\udbff') break;
                    ++unicodeLength;
                }
            }
            ++i;
        }
        return unicodeLength;
    }
}

