/*
 * Decompiled with CFR 0.152.
 */
package nu.xom.canonical;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.StringTokenizer;
import java.util.TreeMap;
import nu.xom.Attribute;
import nu.xom.Comment;
import nu.xom.DocType;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Namespace;
import nu.xom.Node;
import nu.xom.Nodes;
import nu.xom.ParentNode;
import nu.xom.ProcessingInstruction;
import nu.xom.Serializer;
import nu.xom.Text;
import nu.xom.XPathContext;
import nu.xom.canonical.CanonicalizationException;
import org.xml.sax.helpers.NamespaceSupport;

public class Canonicalizer {
    private boolean withComments;
    private boolean exclusive = false;
    private CanonicalXMLSerializer serializer;
    private List inclusiveNamespacePrefixes = new ArrayList();
    private static Comparator comparator = new AttributeComparator();
    public static final String CANONICAL_XML = "http://www.w3.org/TR/2001/REC-xml-c14n-20010315";
    public static final String CANONICAL_XML_WITH_COMMENTS = "http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments";
    public static final String EXCLUSIVE_XML_CANONICALIZATION = "http://www.w3.org/2001/10/xml-exc-c14n#";
    public static final String EXCLUSIVE_XML_CANONICALIZATION_WITH_COMMENTS = "http://www.w3.org/2001/10/xml-exc-c14n#WithComments";

    public Canonicalizer(OutputStream out) {
        this(out, true, false);
    }

    public Canonicalizer(OutputStream out, boolean withComments) {
        this(out, withComments, false);
    }

    private Canonicalizer(OutputStream out, boolean withComments, boolean exclusive) {
        this.serializer = new CanonicalXMLSerializer(out);
        this.serializer.setLineSeparator("\n");
        this.withComments = withComments;
        this.exclusive = exclusive;
    }

    public Canonicalizer(OutputStream out, String algorithm) {
        if (algorithm == null) {
            throw new NullPointerException("Null algorithm");
        }
        this.serializer = new CanonicalXMLSerializer(out);
        this.serializer.setLineSeparator("\n");
        if (algorithm.equals(CANONICAL_XML)) {
            this.withComments = false;
            this.exclusive = false;
        } else if (algorithm.equals(CANONICAL_XML_WITH_COMMENTS)) {
            this.withComments = true;
            this.exclusive = false;
        } else if (algorithm.equals(EXCLUSIVE_XML_CANONICALIZATION)) {
            this.withComments = false;
            this.exclusive = true;
        } else if (algorithm.equals(EXCLUSIVE_XML_CANONICALIZATION_WITH_COMMENTS)) {
            this.withComments = true;
            this.exclusive = true;
        } else {
            throw new CanonicalizationException("Unsupported canonicalization algorithm: " + algorithm);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void write(Node node) throws IOException {
        block9: {
            if (node instanceof Element) {
                Object var4_4;
                Document doc = node.getDocument();
                Element pseudoRoot = null;
                if (doc == null) {
                    pseudoRoot = new Element("pseudo");
                    new Document(pseudoRoot);
                    ParentNode root = (ParentNode)node;
                    while (true) {
                        if (root.getParent() == null) {
                            pseudoRoot.appendChild(root);
                            break;
                        }
                        root = root.getParent();
                    }
                }
                try {
                    this.write(node.query(".//. | .//@* | .//namespace::*"));
                }
                catch (Throwable throwable) {
                    var4_4 = null;
                    if (pseudoRoot != null) {
                        pseudoRoot.removeChild(0);
                    }
                    throw throwable;
                }
                {
                    var4_4 = null;
                    if (pseudoRoot != null) {
                        pseudoRoot.removeChild(0);
                    }
                    break block9;
                }
            }
            this.serializer.nodes = null;
            this.serializer.write(node);
        }
        this.serializer.flush();
    }

    public final void write(Nodes documentSubset) throws IOException {
        if (documentSubset.size() > 0) {
            Document doc = documentSubset.get(0).getDocument();
            if (doc == null) {
                throw new CanonicalizationException("Canonicalization is not defined for detached nodes");
            }
            Nodes result = this.sort(documentSubset);
            this.serializer.nodes = result;
            this.serializer.write(doc);
            this.serializer.flush();
        }
    }

    public final void setInclusiveNamespacePrefixList(String inclusiveNamespacePrefixes) throws IOException {
        this.inclusiveNamespacePrefixes.clear();
        if (this.exclusive && inclusiveNamespacePrefixes != null) {
            StringTokenizer tokenizer = new StringTokenizer(inclusiveNamespacePrefixes, " \t\r\n", false);
            while (tokenizer.hasMoreTokens()) {
                this.inclusiveNamespacePrefixes.add(tokenizer.nextToken());
            }
        }
    }

    private Nodes sort(Nodes in) {
        Document root = in.get(0).getDocument();
        if (in.size() > 1) {
            Nodes out = new Nodes();
            ArrayList<Node> list = new ArrayList<Node>(in.size());
            ArrayList<Node> namespaces = new ArrayList<Node>();
            int i = 0;
            while (i < in.size()) {
                Node node = in.get(i);
                list.add(node);
                if (node instanceof Namespace) {
                    namespaces.add(node);
                }
                ++i;
            }
            Canonicalizer.sort(list, namespaces, out, root);
            if (!list.isEmpty()) {
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    Node next = (Node)iterator.next();
                    if (root == next.getDocument()) continue;
                    throw new CanonicalizationException("Cannot canonicalize subsets that contain nodes from more than one document");
                }
            }
            return out;
        }
        return new Nodes(in.get(0));
    }

    private static void sort(List in, List namespaces, Nodes out, ParentNode parent) {
        if (in.isEmpty()) {
            return;
        }
        if (in.contains(parent)) {
            out.append(parent);
            in.remove(parent);
        }
        int childCount = parent.getChildCount();
        int i = 0;
        while (i < childCount) {
            Node child = parent.getChild(i);
            if (child instanceof Element) {
                Element element = (Element)child;
                if (in.contains(element)) {
                    out.append(element);
                    in.remove(element);
                }
                if (!namespaces.isEmpty()) {
                    Iterator iterator = in.iterator();
                    while (iterator.hasNext()) {
                        Namespace n;
                        Object o = iterator.next();
                        if (!(o instanceof Namespace) || element != (n = (Namespace)o).getParent()) continue;
                        out.append(n);
                        iterator.remove();
                    }
                }
                int a = 0;
                while (a < element.getAttributeCount()) {
                    Attribute att = element.getAttribute(a);
                    if (in.contains(att)) {
                        out.append(att);
                        in.remove(att);
                        if (in.isEmpty()) {
                            return;
                        }
                    }
                    ++a;
                }
                Canonicalizer.sort(in, namespaces, out, element);
            } else if (in.contains(child)) {
                out.append(child);
                in.remove(child);
                if (in.isEmpty()) {
                    return;
                }
            }
            ++i;
        }
    }

    private static class AttributeComparator
    implements Comparator {
        private AttributeComparator() {
        }

        public int compare(Object o1, Object o2) {
            String namespace2;
            Attribute a1 = (Attribute)o1;
            Attribute a2 = (Attribute)o2;
            String namespace1 = a1.getNamespaceURI();
            if (namespace1.equals(namespace2 = a2.getNamespaceURI())) {
                return a1.getLocalName().compareTo(a2.getLocalName());
            }
            if (namespace1.equals("")) {
                return -1;
            }
            if (namespace2.equals("")) {
                return 1;
            }
            return namespace1.compareTo(namespace2);
        }
    }

    private class CanonicalXMLSerializer
    extends Serializer {
        private Nodes nodes;
        private NamespaceSupport inScope;
        private final XPathContext xmlcontext = new XPathContext("xml", "http://www.w3.org/XML/1998/namespace");

        CanonicalXMLSerializer(OutputStream out) {
            super(out);
            this.setLineSeparator("\n");
        }

        public final void write(Document doc) throws IOException {
            Node child;
            this.inScope = new NamespaceSupport();
            int position = 0;
            do {
                child = doc.getChild(position);
                if (this.nodes == null || child instanceof Element || this.nodes.contains(child)) {
                    this.writeChild(child);
                    if (child instanceof ProcessingInstruction) {
                        this.breakLine();
                    } else if (child instanceof Comment && Canonicalizer.this.withComments) {
                        this.breakLine();
                    }
                }
                ++position;
            } while (!(child instanceof Element));
            int i = position;
            while (i < doc.getChildCount()) {
                Node child2 = doc.getChild(i);
                if (this.nodes == null || child2 instanceof Element || this.nodes.contains(child2)) {
                    if (child2 instanceof ProcessingInstruction) {
                        this.breakLine();
                    } else if (child2 instanceof Comment && Canonicalizer.this.withComments) {
                        this.breakLine();
                    }
                    this.writeChild(child2);
                }
                ++i;
            }
            this.flush();
        }

        protected final void write(Element element) throws IOException {
            if (element.getChildCount() == 0) {
                this.writeStartTag(element, false);
                this.writeEndTag(element);
            } else {
                Node current = element;
                boolean end = false;
                int index = -1;
                int[] indexes = new int[10];
                int top = 0;
                indexes[0] = -1;
                while (true) {
                    if (!end && ((Node)current).getChildCount() > 0) {
                        this.writeStartTag((Element)current, false);
                        current = ((Node)current).getChild(0);
                        index = 0;
                        indexes = this.grow(indexes, ++top);
                        indexes[top] = 0;
                        continue;
                    }
                    if (end) {
                        this.writeEndTag((Element)current);
                        if (current == element) {
                            break;
                        }
                    } else {
                        this.writeChild(current);
                    }
                    end = false;
                    ParentNode parent = current.getParent();
                    if (parent.getChildCount() - 1 == index) {
                        current = parent;
                        --top;
                        if (current != element) {
                            index = indexes[top];
                        }
                        end = true;
                        continue;
                    }
                    indexes[top] = ++index;
                    current = parent.getChild(index);
                }
            }
        }

        private int[] grow(int[] indexes, int top) {
            if (top < indexes.length) {
                return indexes;
            }
            int[] result = new int[indexes.length * 2];
            System.arraycopy(indexes, 0, result, 0, indexes.length);
            return result;
        }

        protected void writeStartTag(Element element, boolean isEmpty) throws IOException {
            boolean writeElement;
            boolean bl = writeElement = this.nodes == null || this.nodes.contains(element);
            if (writeElement) {
                this.inScope.pushContext();
                this.writeRaw("<");
                this.writeRaw(element.getQualifiedName());
            }
            TreeMap<String, String> map = new TreeMap<String, String>();
            if (this.nodes == null) {
                ParentNode parent = element.getParent();
                Element parentElement = null;
                if (parent instanceof Element) {
                    parentElement = (Element)parent;
                }
                int i = 0;
                while (i < element.getNamespaceDeclarationCount()) {
                    String prefix = element.getNamespacePrefix(i);
                    String uri = element.getNamespaceURI(prefix);
                    if (!uri.equals(this.inScope.getURI(prefix))) {
                        if (Canonicalizer.this.exclusive) {
                            if (this.needToDeclareNamespace(element, prefix, uri)) {
                                map.put(prefix, uri);
                            }
                        } else if (uri.equals("")) {
                            if (parentElement != null && !"".equals(parentElement.getNamespaceURI(""))) {
                                map.put(prefix, uri);
                            }
                        } else {
                            map.put(prefix, uri);
                        }
                    }
                    ++i;
                }
                this.writeNamespaceDeclarations(map);
            } else {
                int position = this.indexOf(element);
                if (position != -1 && "".equals(element.getNamespaceURI())) {
                    String uri;
                    ParentNode parent = element.getParent();
                    while (parent instanceof Element && !this.nodes.contains(parent)) {
                        parent = parent.getParent();
                    }
                    if (parent instanceof Element && !"".equals(uri = ((Element)parent).getNamespaceURI(""))) {
                        map.put("", "");
                    }
                }
                int i = position + 1;
                while (i < this.nodes.size()) {
                    Node next = this.nodes.get(i);
                    if (!(next instanceof Namespace)) break;
                    Namespace namespace = (Namespace)next;
                    String prefix = namespace.getPrefix();
                    String uri = namespace.getValue();
                    if (!uri.equals(this.inScope.getURI(prefix))) {
                        if (Canonicalizer.this.exclusive) {
                            if (this.needToDeclareNamespace(element, prefix, uri)) {
                                map.put(prefix, uri);
                            }
                        } else {
                            map.put(prefix, uri);
                        }
                    }
                    ++i;
                }
                this.writeNamespaceDeclarations(map);
            }
            Attribute[] sorted = this.sortAttributes(element);
            int i = 0;
            while (i < sorted.length) {
                if (this.nodes == null || this.nodes.contains(sorted[i]) || sorted[i].getNamespaceURI().equals("http://www.w3.org/XML/1998/namespace") && sorted[i].getParent() != element) {
                    this.write(sorted[i]);
                }
                ++i;
            }
            if (writeElement) {
                this.writeRaw(">");
            }
        }

        private void writeNamespaceDeclarations(SortedMap map) throws IOException {
            Iterator prefixes = map.entrySet().iterator();
            while (prefixes.hasNext()) {
                Map.Entry entry = prefixes.next();
                String prefix = (String)entry.getKey();
                String uri = (String)entry.getValue();
                this.writeRaw(" ");
                this.writeNamespaceDeclaration(prefix, uri);
                this.inScope.declarePrefix(prefix, uri);
            }
        }

        private boolean needToDeclareNamespace(Element parent, String prefix, String uri) {
            boolean match = this.visiblyUtilized(parent, prefix, uri);
            if (match || Canonicalizer.this.inclusiveNamespacePrefixes.contains(prefix)) {
                return this.noOutputAncestorUsesPrefix(parent, prefix, uri);
            }
            return false;
        }

        private boolean visiblyUtilized(Element element, String prefix, String uri) {
            boolean match = false;
            String pfx = element.getNamespacePrefix();
            String local = element.getNamespaceURI();
            if (prefix.equals(pfx) && local.equals(uri)) {
                match = true;
            } else {
                int i = 0;
                while (i < element.getAttributeCount()) {
                    Attribute attribute = element.getAttribute(i);
                    if ((this.nodes == null || this.nodes.contains(attribute)) && prefix.equals(pfx = attribute.getNamespacePrefix())) {
                        match = true;
                        break;
                    }
                    ++i;
                }
            }
            return match;
        }

        /*
         * Unable to fully structure code
         */
        private boolean noOutputAncestorUsesPrefix(Element original, String prefix, String uri) {
            parent = original.getParent();
            if (!(parent instanceof Document) || !"".equals(uri)) ** GOTO lbl20
            return false;
lbl-1000:
            // 1 sources

            {
                if (this.nodes == null || this.nodes.contains(parent)) {
                    element = (Element)parent;
                    pfx = element.getNamespacePrefix();
                    if (pfx.equals(prefix)) {
                        newURI = element.getNamespaceURI(prefix);
                        return newURI.equals(uri) == false;
                    }
                    i = 0;
                    while (i < element.getAttributeCount()) {
                        attribute = element.getAttribute(i);
                        current = attribute.getNamespacePrefix();
                        if (current.equals(prefix)) {
                            newURI = element.getNamespaceURI(prefix);
                            return newURI.equals(uri) == false;
                        }
                        ++i;
                    }
                }
                parent = parent.getParent();
lbl20:
                // 2 sources

                ** while (parent != null && !(parent instanceof Document))
            }
lbl21:
            // 1 sources

            return true;
        }

        private int indexOf(Element element) {
            int i = 0;
            while (i < this.nodes.size()) {
                if (this.nodes.get(i) == element) {
                    return i;
                }
                ++i;
            }
            return -1;
        }

        protected void write(Attribute attribute) throws IOException {
            this.writeRaw(" ");
            this.writeRaw(attribute.getQualifiedName());
            this.writeRaw("=\"");
            this.writeRaw(this.prepareAttributeValue(attribute));
            this.writeRaw("\"");
        }

        protected void writeEndTag(Element element) throws IOException {
            if (this.nodes == null || this.nodes.contains(element)) {
                this.writeRaw("</");
                this.writeRaw(element.getQualifiedName());
                this.writeRaw(">");
                this.inScope.popContext();
            }
        }

        private Attribute[] sortAttributes(Element element) {
            TreeMap<String, Attribute> nearest = new TreeMap<String, Attribute>();
            if (!Canonicalizer.this.exclusive && this.nodes != null && this.nodes.contains(element) && !this.nodes.contains(element.getParent())) {
                Nodes attributes = element.query("ancestor::*/@xml:*", this.xmlcontext);
                if (attributes.size() != 0) {
                    int i = attributes.size() - 1;
                    while (i >= 0) {
                        Attribute a = (Attribute)attributes.get(i);
                        String name = a.getLocalName();
                        if (element.getAttribute(name, "http://www.w3.org/XML/1998/namespace") == null && !nearest.containsKey(name)) {
                            Element parent = (Element)a.getParent();
                            if (!this.nodes.contains(parent)) {
                                nearest.put(name, a);
                            } else {
                                nearest.put(name, null);
                            }
                        }
                        --i;
                    }
                }
                Iterator iterator = nearest.values().iterator();
                while (iterator.hasNext()) {
                    if (iterator.next() != null) continue;
                    iterator.remove();
                }
            }
            int localCount = element.getAttributeCount();
            Attribute[] result = new Attribute[localCount + nearest.size()];
            int i = 0;
            while (i < localCount) {
                result[i] = element.getAttribute(i);
                ++i;
            }
            Iterator iterator = nearest.values().iterator();
            int j = localCount;
            while (j < result.length) {
                result[j] = (Attribute)iterator.next();
                ++j;
            }
            Arrays.sort(result, comparator);
            return result;
        }

        private String prepareAttributeValue(Attribute attribute) {
            String value = attribute.getValue();
            StringBuffer result = new StringBuffer(value.length());
            if (attribute.getType().equals(Attribute.Type.CDATA) || attribute.getType().equals(Attribute.Type.UNDECLARED)) {
                char[] data = value.toCharArray();
                int i = 0;
                while (i < data.length) {
                    char c = data[i];
                    if (c == '\t') {
                        result.append("&#x9;");
                    } else if (c == '\n') {
                        result.append("&#xA;");
                    } else if (c == '\r') {
                        result.append("&#xD;");
                    } else if (c == '\"') {
                        result.append("&quot;");
                    } else if (c == '&') {
                        result.append("&amp;");
                    } else if (c == '<') {
                        result.append("&lt;");
                    } else {
                        result.append(c);
                    }
                    ++i;
                }
            } else {
                char[] data = value.toCharArray();
                boolean seenFirstNonSpace = false;
                int i = 0;
                while (i < data.length) {
                    if (data[i] == ' ') {
                        if (i != data.length - 1 && data[i + 1] != ' ' && seenFirstNonSpace) {
                            result.append(data[i]);
                        }
                    } else {
                        seenFirstNonSpace = true;
                        if (data[i] == '\t') {
                            result.append("&#x9;");
                        } else if (data[i] == '\n') {
                            result.append("&#xA;");
                        } else if (data[i] == '\r') {
                            result.append("&#xD;");
                        } else if (data[i] == '\"') {
                            result.append("&quot;");
                        } else if (data[i] == '&') {
                            result.append("&amp;");
                        } else if (data[i] == '<') {
                            result.append("&lt;");
                        } else {
                            result.append(data[i]);
                        }
                    }
                    ++i;
                }
            }
            return result.toString();
        }

        protected final void write(Text text) throws IOException {
            if (this.nodes == null || this.nodes.contains(text)) {
                String input = text.getValue();
                StringBuffer result = new StringBuffer(input.length());
                int i = 0;
                while (i < input.length()) {
                    char c = input.charAt(i);
                    if (c == '\r') {
                        result.append("&#xD;");
                    } else if (c == '&') {
                        result.append("&amp;");
                    } else if (c == '<') {
                        result.append("&lt;");
                    } else if (c == '>') {
                        result.append("&gt;");
                    } else {
                        result.append(c);
                    }
                    ++i;
                }
                this.writeRaw(result.toString());
            }
        }

        protected final void write(Comment comment) throws IOException {
            if (Canonicalizer.this.withComments && (this.nodes == null || this.nodes.contains(comment))) {
                super.write(comment);
            }
        }

        protected final void write(ProcessingInstruction pi) throws IOException {
            if (this.nodes == null || this.nodes.contains(pi)) {
                super.write(pi);
            }
        }

        protected final void write(DocType doctype) {
        }

        public void write(Node node) throws IOException {
            if (node instanceof Document) {
                this.write((Document)node);
            } else if (node instanceof Attribute) {
                this.write((Attribute)node);
            } else if (node instanceof Namespace) {
                this.write((Namespace)node);
            } else {
                this.writeChild(node);
            }
        }

        private void write(Namespace namespace) throws IOException {
            String prefix = namespace.getPrefix();
            String uri = namespace.getValue();
            this.writeRaw(" xmlns");
            if (!"".equals(prefix)) {
                this.writeRaw(":");
                this.writeRaw(prefix);
            }
            this.writeRaw("=\"");
            this.writeAttributeValue(uri);
            this.writeRaw("\"");
        }
    }
}

