/*
 * Decompiled with CFR 0.152.
 */
package ro.deversoft.devices;

import java.util.Vector;
import ro.deversoft.devices.DeviceDefinition;
import ro.deversoft.devices.DeviceEventConsumer;
import ro.deversoft.devices.DeviceType;

public abstract class DeviceAbstract
implements DeviceDefinition,
Runnable {
    private Vector<DeviceEventConsumer> consumerList = new Vector();
    protected Boolean mustRun = true;
    protected String deviceName;

    @Override
    public final void startRunning() {
        this.mustRun = true;
        Thread thread = new Thread(this);
        thread.setName("Device_" + this.deviceName);
        thread.start();
    }

    @Override
    public final void stopRunning() {
        this.mustRun = false;
    }

    @Override
    public synchronized void addDeviceEventConsumer(DeviceEventConsumer consumer) {
        this.consumerList.add(consumer);
    }

    @Override
    public synchronized void removeDeviceEventConsumer(DeviceEventConsumer consumer) {
        Vector newList = new Vector();
        this.consumerList.stream().forEach(c -> {
            if (!consumer.equals(c)) {
                newList.add(c);
            }
        });
        this.consumerList = newList;
    }

    protected void notifyConsumers(Object payload) {
        for (DeviceEventConsumer deviceEventConsumer : this.consumerList) {
            deviceEventConsumer.dataFromDevice(this.deviceName, payload);
        }
    }

    public abstract void processData(Object var1) throws ClassCastException;

    public abstract DeviceType getDeviceType();

    public void logDebug(Object object, String message) {
        System.out.println(object.toString() + " : " + message);
    }

    public void logError(Object object, String message) {
        System.out.println(object.toString() + " : " + message);
    }

    public void logInfo(Object object, String message) {
        System.out.println(object.toString() + " : " + message);
    }

    public void logException(Object object, Throwable message) {
        System.out.println(object.toString() + " : " + message);
        message.printStackTrace();
    }

    public void logError(Object object, Throwable message) {
        System.out.println(object.toString() + " : " + message);
        message.printStackTrace();
    }
}

