/*
 * Decompiled with CFR 0.152.
 */
package com.easynth.designer.laf.popup;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Window;
import java.awt.image.BufferedImage;
import javax.swing.JApplet;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JPopupMenu;
import javax.swing.JWindow;
import javax.swing.Popup;
import javax.swing.SwingUtilities;

public class EaSynthPopup
extends Popup {
    public static final String POPUP_BACKGROUND_IMAGE = "POPUP_BACKGROUND_IMAGE";
    private Component contents;
    private int x;
    private int y;
    private Popup popup;
    private Container heavyContainer;
    private static BufferedImage popupBgImage;

    public EaSynthPopup() {
    }

    public EaSynthPopup(Component component, Component component2, int n, int n2, Popup popup) {
        Container container;
        this.contents = component2;
        this.popup = popup;
        this.x = n;
        this.y = n2;
        ((JComponent)container).putClientProperty(POPUP_BACKGROUND_IMAGE, null);
        for (container = component2.getParent(); container != null; container = container.getParent()) {
            if (!(container instanceof JWindow) && !(container instanceof Panel) && !(container instanceof Window)) continue;
            this.heavyContainer = container;
            break;
        }
        this.fixCursorForInternalFrame(component);
        if (this.heavyContainer != null && System.getProperty("os.name").startsWith("Mac")) {
            this.heavyContainer.setBackground(new Color(0x1000000, true));
            this.heavyContainer.setBackground(new Color(0, true));
            if (this.heavyContainer instanceof JWindow) {
                ((JWindow)this.heavyContainer).getRootPane().putClientProperty("apple.awt.draggableWindowBackground", Boolean.FALSE);
            }
        }
    }

    private void fixCursorForInternalFrame(Component component) {
        if (component != null && component instanceof JInternalFrame) {
            Container container = ((JInternalFrame)component).getTopLevelAncestor();
            Cursor cursor = Cursor.getPredefinedCursor(0);
            if (container instanceof JFrame) {
                ((JFrame)container).getGlassPane().setCursor(cursor);
                ((JFrame)container).getGlassPane().setVisible(false);
            } else if (container instanceof JWindow) {
                ((JWindow)container).getGlassPane().setCursor(cursor);
                ((JWindow)container).getGlassPane().setVisible(false);
            } else if (container instanceof JDialog) {
                ((JDialog)container).getGlassPane().setCursor(cursor);
                ((JDialog)container).getGlassPane().setVisible(false);
            } else if (container instanceof JApplet) {
                ((JApplet)container).getGlassPane().setCursor(cursor);
                ((JApplet)container).getGlassPane().setVisible(false);
            }
        }
    }

    public void hide() {
        Container container = (JComponent)this.contents.getParent();
        this.popup.hide();
        if (this.heavyContainer != null) {
            this.heavyContainer = null;
            while (container != null) {
                if (container instanceof JFrame) {
                    ((JFrame)container).update(((Component)container).getGraphics());
                }
                container = ((Component)container).getParent();
            }
        }
        this.contents = null;
        this.popup = null;
    }

    public Popup getPopup() {
        return this.popup;
    }

    public void show() {
        boolean bl;
        boolean bl2 = bl = this.contents instanceof JPopupMenu;
        if (bl && this.heavyContainer == null) {
            this.heavyContainer = this.contents.getParent();
        }
        if (this.heavyContainer == null) {
            this.popup.show();
            return;
        }
        SwingUtilities.invokeLater(new CaptureBgRunnable());
    }

    private void captureBackground() {
        if (this.heavyContainer != null) {
            try {
                Robot robot = new Robot();
                Dimension dimension = this.heavyContainer.getPreferredSize();
                Rectangle rectangle = new Rectangle(this.x, this.y, dimension.width, dimension.height);
                popupBgImage = robot.createScreenCapture(rectangle);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private class CaptureBgRunnable
    implements Runnable {
        private CaptureBgRunnable() {
        }

        public void run() {
            Popup popup;
            if (EaSynthPopup.this.contents != null && EaSynthPopup.this.contents.getParent() instanceof JComponent) {
                EaSynthPopup.this.captureBackground();
                ((JComponent)EaSynthPopup.this.contents.getParent()).putClientProperty(EaSynthPopup.POPUP_BACKGROUND_IMAGE, popupBgImage);
            }
            if ((popup = EaSynthPopup.this.getPopup()) != null) {
                popup.show();
            }
        }
    }
}

