package purejavacomm.testsuite;

import com.sun.jna.Native;
import com.sun.jna.NativeLong;
import com.sun.jna.Pointer;

public class ExperimentWithJNAEndianness {

	public static class CLib {
		native public Pointer malloc();

		native public void memcpy(byte[] dst, byte[] src, long n);

		native public void memcpy(short[] dst, byte[] src, long n);

		native public void memcpy(int[] dst, byte[] src, long n);

		native public void memcpy(long[] dst, byte[] src, long n);

		static {
			Native.register("c");
		}
	}

	static CLib C = new CLib();

	public static void main(String[] args) {
		byte[] src = { 0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07 };
		byte[] bdst = new byte[8];
		short[] sdst = new short[4];
		int[] idst = new int[2];
		long[] ldst = new long[1];
		C.memcpy(bdst, src, 8);
		C.memcpy(sdst, src, 8);
		C.memcpy(idst, src, 8);
		C.memcpy(ldst, src, 8);
		for (int i = 0; i < 8; i++)
			System.out.printf("0x%02X ", 0xFF & bdst[i]);
		System.out.println();
		for (int i = 0; i < 4; i++)
			System.out.printf("0x%04X ", 0xFFFF & sdst[i]);
		System.out.println();
		for (int i = 0; i < 2; i++)
			System.out.printf("0x%08X ", 0xFFFFFF & idst[i]);
		System.out.println();
		for (int i = 0; i < 1; i++)
			System.out.printf("0x%016X ", 0xFFFFFFFF & ldst[i]);
		System.out.println();
		
		System.out.println("sizeof(long) "+NativeLong.SIZE);
	}

}
