package purejavacomm.testsuite;

import static jtermios.JTermios.*;
import jtermios.Termios;

public class Experiment_VMIN_VTIME {

	/**
	 * @param args
	 */
	public static void main(String[] args) {
		// TODO Auto-generated method stub
		//int[] fds = { 0, 0 };
		//System.out.println("create pipe " + m_Clib.pipe(fds) + " " + fds[0] + " " + fds[1]);

		System.out.println("opening port");
		int m_FD = open("/dev/tty.usbserial-FTOXM3NX", O_RDWR | O_NOCTTY | O_NONBLOCK);
		System.out.println("port fd "+m_FD);
		int flags = fcntl(m_FD, F_GETFL, 0);
		flags &= ~O_NONBLOCK;
		
		System.out.println("clear O_NONBLOCK");
		checkReturnCode(fcntl(m_FD, F_SETFL, flags));
		
		Termios m_Termios=new Termios();
		
		System.out.println("get termios");
		checkReturnCode(tcgetattr(m_FD, m_Termios));
		cfmakeraw(m_FD, m_Termios);
		m_Termios.c_cflag |= CLOCAL | CREAD;
		m_Termios.c_lflag &= ~(ICANON | ECHO | ECHOE | ISIG);
		m_Termios.c_lflag |= ISIG; // DEBUG/TESTING
		m_Termios.c_oflag &= ~OPOST;

		m_Termios.c_cc[VSTART] = (byte) DC1;
		m_Termios.c_cc[VSTOP] = (byte) DC3;
		m_Termios.c_cc[VMIN] = 0;
		m_Termios.c_cc[VTIME] = 10; // 1 second
		System.out.println("set termios");
		checkReturnCode(tcsetattr(m_FD, TCSANOW, m_Termios));


		byte[] m_Buffer=new byte[100];
		System.out.println("calling read");
		long T0=System.currentTimeMillis();
		int n=read(m_FD, m_Buffer, 100);
		long T1=System.currentTimeMillis();
		System.out.println("read returned "+n+" in "+(T1-T0)+" msec");
		close(m_FD);
		
	}

	//INVESTIGATE IF VMIN>0 VTIME>0 VTIME is intercharacter delay or total timeout
	private static void checkReturnCode(int code) {
		if (code != 0) {
			System.out.println("err code "+code);
			System.exit(0);
		}
	}

}

/*
 * 
 * 
 * 
 * 
 * 
 * Serial communication survivalquide
 * 
 * syncing
 * 	ctrl lines
 *  time based
 *  marker based
 *  checksum based
 *  checksum + marker based
 *  
 *  waiting for data
 *   select+available
 *  
 * using threshold
 * selecting timeout
 * timeout
 * handshake
 */
