/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.base;

import java.awt.event.ActionListener;
import java.util.Hashtable;
import javax.swing.Action;
import javax.swing.ImageIcon;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.tigris.gef.base.Cmd;
import org.tigris.gef.base.Editor;
import org.tigris.gef.base.Globals;
import org.tigris.gef.base.ModePlace;
import org.tigris.gef.graph.GraphFactory;
import org.tigris.gef.graph.GraphModel;
import org.tigris.gef.graph.GraphNodeHooks;
import org.tigris.gef.graph.MutableGraphModel;

public class CmdCreateNode
extends Cmd
implements GraphFactory {
    private static final long serialVersionUID = -4746215260464595235L;
    public static Class DEFAULT_NODE_CLASS = class$org$tigris$gef$graph$presentation$NetNode == null ? (class$org$tigris$gef$graph$presentation$NetNode = CmdCreateNode.class$("org.tigris.gef.graph.presentation.NetNode")) : class$org$tigris$gef$graph$presentation$NetNode;
    private static Log LOG = LogFactory.getLog((Class)(class$org$tigris$gef$base$CmdCreateNode == null ? (class$org$tigris$gef$base$CmdCreateNode = CmdCreateNode.class$("org.tigris.gef.base.CmdCreateNode")) : class$org$tigris$gef$base$CmdCreateNode));
    static /* synthetic */ Class class$org$tigris$gef$graph$presentation$NetNode;
    static /* synthetic */ Class class$org$tigris$gef$base$CmdCreateNode;

    public CmdCreateNode(Hashtable args, String resource, String name) {
        super(args, resource, name);
    }

    public CmdCreateNode(Hashtable args, String name) {
        super(args, "GefBase", name);
    }

    public CmdCreateNode(Class nodeClass, String resource, String name) {
        this(new Hashtable(), resource, name);
        this.setArg("className", nodeClass);
    }

    public CmdCreateNode(Class nodeClass, String name) {
        this(new Hashtable(), name);
        this.setArg("className", nodeClass);
    }

    public CmdCreateNode(Object nodeClass, String name, ImageIcon icon) {
        super(new Hashtable(), name, icon);
        this.setArg("className", nodeClass);
    }

    public CmdCreateNode(Class nodeClass, boolean sticky, String resource, String name) {
        this(nodeClass, resource, name);
        this.setArg("shouldBeSticky", sticky ? Boolean.TRUE : Boolean.FALSE);
    }

    public CmdCreateNode(Class nodeClass, boolean sticky, String name) {
        this(nodeClass, name);
        this.setArg("shouldBeSticky", sticky ? Boolean.TRUE : Boolean.FALSE);
    }

    public void doIt() {
        Editor ce = Globals.curEditor();
        GraphModel gm = ce.getGraphModel();
        if (!(gm instanceof MutableGraphModel)) {
            return;
        }
        this.setArg("graphModel", gm);
        String instructions = null;
        Object actionName = this.getValue("Name");
        if (actionName != null) {
            instructions = "Click to place " + actionName.toString();
        }
        ModePlace placeMode = new ModePlace(this, instructions);
        Object shouldBeSticky = this.getArg("shouldBeSticky");
        Globals.mode(placeMode, shouldBeSticky == Boolean.TRUE);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Mode set to ModePlace with sticky mode " + shouldBeSticky));
        }
    }

    public void undoIt() {
        LOG.warn((Object)"undo is not implemented");
    }

    public GraphModel makeGraphModel() {
        return null;
    }

    public Object makeEdge() {
        return null;
    }

    public Object makeNode() {
        Object newNode;
        Object nodeType = this.getArg("className", DEFAULT_NODE_CLASS);
        if (nodeType instanceof Action) {
            ActionListener a = null;
            a.actionPerformed(null);
            newNode = a.getValue("node");
        } else {
            Class nodeClass = (Class)this.getArg("className", DEFAULT_NODE_CLASS);
            try {
                newNode = nodeClass.newInstance();
            }
            catch (IllegalAccessException ignore) {
                LOG.error((Object)("Unable to instantiate node " + nodeClass.getName()));
                return null;
            }
            catch (InstantiationException ignore) {
                LOG.error((Object)("Failed to instantiate node " + nodeClass.getName()));
                return null;
            }
        }
        LOG.debug((Object)("New node created " + newNode));
        if (newNode instanceof GraphNodeHooks) {
            LOG.debug((Object)"Initializing GraphNodeHooks");
            ((GraphNodeHooks)newNode).initialize(this._args);
        }
        return newNode;
    }

    public Object getActiveGraphModel() {
        return this.getArg("graphModel");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

