/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.gsonrmi;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonSerializationContext;
import java.lang.reflect.Type;

public class Parameter {
    private Object value;
    private Type type;
    private JsonElement serializedValue;

    public Parameter(Object value) {
        this.value = value;
        this.type = value != null ? (value instanceof Exception ? Exception.class : value.getClass()) : Object.class;
    }

    public Parameter(Object value, Type type) {
        this.value = value;
        this.type = value != null && value instanceof Exception ? Exception.class : type;
    }

    public Parameter(JsonElement serializedValue) {
        if (serializedValue == null) {
            throw new NullPointerException("You probably want to invoke the other constructor!");
        }
        this.serializedValue = serializedValue;
    }

    public <T> T getValue(Type type, Gson deserializer) {
        if (this.value == null && this.serializedValue != null) {
            this.value = deserializer.fromJson(this.serializedValue, type);
            this.type = type;
            this.serializedValue = null;
        }
        return (T)this.value;
    }

    public <T> T getValue(Class<T> type, Gson deserializer) {
        if (this.value == null && this.serializedValue != null) {
            this.value = deserializer.fromJson(this.serializedValue, type);
            this.type = type;
            this.serializedValue = null;
        }
        return (T)this.value;
    }

    public JsonElement getSerializedValue(Gson serializer) {
        if (this.serializedValue == null) {
            this.serializedValue = serializer.toJsonTree(this.value, this.type);
        }
        return this.serializedValue;
    }

    public JsonElement getSerializedValue(JsonSerializationContext context) {
        if (this.serializedValue == null) {
            this.serializedValue = context.serialize(this.value, this.type);
        }
        return this.serializedValue;
    }
}

