/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.gsonrmi.transport.tcp;

import com.google.code.gsonrmi.transport.DeliveryFailure;
import com.google.code.gsonrmi.transport.Message;
import com.google.code.gsonrmi.transport.Proxy;
import com.google.code.gsonrmi.transport.Route;
import com.google.code.gsonrmi.transport.Transport;
import com.google.code.gsonrmi.transport.tcp.SocketTimeoutAction;
import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.KeyStore;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

public class TcpProxy
extends Proxy {
    private final List<TcpListener> listeners = new LinkedList<TcpListener>();
    protected KeyStore keyStore;
    private SocketTimeoutAction socketTimeoutAction;
    private int localPort;
    private boolean started = true;

    public TcpProxy(List<InetSocketAddress> listeningAddresses, Transport transport, Gson serializer) throws IOException {
        super(transport, serializer);
        for (InetSocketAddress address : listeningAddresses) {
            TcpListener l = new TcpListener(address);
            l.start();
            this.listeners.add(l);
        }
    }

    public int getLocalPort() {
        return this.localPort;
    }

    public boolean isStarted() {
        return this.started;
    }

    @Override
    protected void handle(Transport.Shutdown m) {
        super.handle(m);
        for (TcpListener l : this.listeners) {
            l.shutdown();
        }
    }

    @Override
    public String getScheme() {
        return "tcp";
    }

    @Override
    public Proxy.Connection createConnection(String remoteAuthority) {
        try {
            TcpConnection c = new TcpConnection(null, remoteAuthority);
            c.start();
            return c;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        return null;
    }

    protected Socket buildSocket(String host, int port) throws IOException {
        return new Socket(host, port);
    }

    protected ServerSocket buildServerSocket() throws IOException {
        return new ServerSocket();
    }

    public void setKeyStore(KeyStore keyStore) {
        this.keyStore = keyStore;
    }

    public SocketTimeoutAction getSocketTimeoutAction() {
        return this.socketTimeoutAction;
    }

    public void setSocketTimeoutAction(SocketTimeoutAction socketTimeoutAction) {
        this.socketTimeoutAction = socketTimeoutAction;
    }

    private class TcpConnection
    extends Thread
    implements Proxy.Connection {
        private Socket s;
        private volatile PrintWriter out;
        private final URI remoteAddr;
        private final List<Message> sendQueue;

        public TcpConnection(Socket socket, String remoteAuthority) throws URISyntaxException, IOException {
            this.s = socket;
            if (this.s != null) {
                this.out = new PrintWriter((Writer)new OutputStreamWriter(this.s.getOutputStream(), "utf-8"), true);
            }
            this.remoteAddr = new URI(TcpProxy.this.getScheme(), remoteAuthority, null, null, null);
            this.sendQueue = new LinkedList<Message>();
        }

        @Override
        public String getRemoteAuthority() {
            return this.remoteAddr.getAuthority();
        }

        @Override
        public void shutdown() {
            try {
                if (this.s != null) {
                    this.s.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void send(Message m) {
            if (this.out != null) {
                this.send(m, this.out);
            } else {
                List<Message> list = this.sendQueue;
                synchronized (list) {
                    this.sendQueue.add(m);
                }
                if (this.out != null) {
                    this.send(m, this.out);
                }
            }
        }

        private void send(Message m, PrintWriter pw) {
            LinkedList<Route> dests = new LinkedList<Route>();
            for (Route dest : m.dests) {
                dests.add(dest.removeFirst());
            }
            String x = TcpProxy.this.gson.toJson(new Message(m.src, dests, m.content, m.contentType));
            pw.println(x);
            pw.flush();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object line;
            try {
                if (this.out == null) {
                    String[] tokens = this.remoteAddr.getAuthority().split(":");
                    this.s = TcpProxy.this.buildSocket(tokens[0], Integer.parseInt(tokens[1]));
                    this.s.setSoTimeout(300000);
                    List<Message> list = this.sendQueue;
                    synchronized (list) {
                        PrintWriter pw = new PrintWriter((Writer)new OutputStreamWriter(this.s.getOutputStream(), "utf-8"), true);
                        for (Message m : this.sendQueue) {
                            this.send(m, pw);
                        }
                        this.out = pw;
                    }
                }
                BufferedReader in = new BufferedReader(new InputStreamReader(this.s.getInputStream(), "utf-8"));
                while ((line = in.readLine()) != null) {
                    Message m = TcpProxy.this.gson.fromJson((String)line, Message.class);
                    TcpProxy.this.transport.send(new Message(m.src.addFirst(this.remoteAddr), m.dests, m.content, m.contentType));
                }
            }
            catch (IOException e) {
                if (this.s != null) {
                    if (!this.s.isClosed()) {
                        e.printStackTrace();
                    }
                }
                System.err.println("Connect failed to " + this.remoteAddr.getAuthority());
                line = this.sendQueue;
                synchronized (line) {
                    for (Message m : this.sendQueue) {
                        if (m.contentOfType(DeliveryFailure.class)) continue;
                        TcpProxy.this.transport.send(new Message(null, Arrays.asList(m.src), new DeliveryFailure(m)));
                    }
                }
            }
            try {
                if (this.s != null) {
                    int port = this.s.getPort();
                    String hostAddress = this.s.getInetAddress().getHostAddress();
                    if (TcpProxy.this.socketTimeoutAction != null) {
                        TcpProxy.this.socketTimeoutAction.doAction(hostAddress, port);
                    }
                    this.s.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        @Override
        public String toString() {
            return "TcpConnection{s=" + this.s + ", out=" + this.out + ", remoteAddr=" + this.remoteAddr + ", sendQueue=" + this.sendQueue + '}';
        }
    }

    private class TcpListener
    extends Thread {
        private final ServerSocket ss;

        public TcpListener(InetSocketAddress address) throws IOException {
            this.ss = TcpProxy.this.buildServerSocket();
            this.ss.bind(address);
            System.out.println("TcpListener started on port : " + this.ss.getLocalPort());
            TcpProxy.this.localPort = this.ss.getLocalPort();
        }

        public void shutdown() {
            try {
                this.ss.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        @Override
        public void run() {
            try {
                TcpProxy.this.started = true;
                while (true) {
                    Socket s = this.ss.accept();
                    s.setSoTimeout(300000);
                    InetSocketAddress addr = (InetSocketAddress)s.getRemoteSocketAddress();
                    TcpConnection c = new TcpConnection(s, addr.getHostName() + ":" + addr.getPort());
                    c.start();
                    TcpProxy.this.addConnection(c);
                }
            }
            catch (IOException e) {
                if (!this.ss.isClosed()) {
                    e.printStackTrace();
                }
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
        }
    }
}

