/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.field.types;

import com.j256.ormlite.field.BaseFieldConverter;
import com.j256.ormlite.field.DataPersister;
import com.j256.ormlite.field.FieldType;
import com.j256.ormlite.field.SqlType;
import com.j256.ormlite.support.DatabaseResults;
import java.lang.reflect.Field;
import java.sql.SQLException;

public abstract class BaseDataType
extends BaseFieldConverter
implements DataPersister {
    private final SqlType sqlType;
    private final Class<?>[] classes;

    public BaseDataType(SqlType sqlType, Class<?>[] classes) {
        this.sqlType = sqlType;
        this.classes = classes;
    }

    @Override
    public abstract Object parseDefaultString(FieldType var1, String var2) throws SQLException;

    @Override
    public abstract Object resultToSqlArg(FieldType var1, DatabaseResults var2, int var3) throws SQLException;

    @Override
    public boolean isValidForField(Field field) {
        if (this.classes.length == 0) {
            return true;
        }
        for (Class<?> clazz : this.classes) {
            if (!clazz.isAssignableFrom(field.getType())) continue;
            return true;
        }
        return false;
    }

    @Override
    public Class<?> getPrimaryClass() {
        if (this.classes.length == 0) {
            return null;
        }
        return this.classes[0];
    }

    @Override
    public Object makeConfigObject(FieldType fieldType) throws SQLException {
        return null;
    }

    @Override
    public SqlType getSqlType() {
        return this.sqlType;
    }

    @Override
    public Class<?>[] getAssociatedClasses() {
        return this.classes;
    }

    @Override
    public String[] getAssociatedClassNames() {
        return null;
    }

    @Override
    public Object convertIdNumber(Number number) {
        return null;
    }

    @Override
    public boolean isValidGeneratedType() {
        return false;
    }

    @Override
    public boolean isEscapedDefaultValue() {
        return this.isEscapedValue();
    }

    @Override
    public boolean isEscapedValue() {
        return true;
    }

    @Override
    public boolean isPrimitive() {
        return false;
    }

    @Override
    public boolean isComparable() {
        return true;
    }

    @Override
    public boolean isAppropriateId() {
        return true;
    }

    @Override
    public boolean isArgumentHolderRequired() {
        return false;
    }

    @Override
    public boolean isSelfGeneratedId() {
        return false;
    }

    @Override
    public Object generateId() {
        throw new IllegalStateException("Should not have tried to generate this type");
    }

    @Override
    public int getDefaultWidth() {
        return 0;
    }

    @Override
    public boolean dataIsEqual(Object fieldObj1, Object fieldObj2) {
        if (fieldObj1 == null) {
            return fieldObj2 == null;
        }
        if (fieldObj2 == null) {
            return false;
        }
        return fieldObj1.equals(fieldObj2);
    }

    @Override
    public boolean isValidForVersion() {
        return false;
    }

    @Override
    public Object moveToNextValue(Object currentValue) {
        return null;
    }

    @Override
    public Object resultStringToJava(FieldType fieldType, String stringValue, int columnPos) throws SQLException {
        return this.parseDefaultString(fieldType, stringValue);
    }
}

