/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.field.types;

import com.j256.ormlite.field.FieldType;
import com.j256.ormlite.field.SqlType;
import com.j256.ormlite.field.types.BaseEnumType;
import com.j256.ormlite.support.DatabaseResults;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

public class EnumStringType
extends BaseEnumType {
    public static int DEFAULT_WIDTH = 100;
    private static final EnumStringType singleTon = new EnumStringType();

    public static EnumStringType getSingleton() {
        return singleTon;
    }

    private EnumStringType() {
        super(SqlType.STRING, new Class[]{Enum.class});
    }

    protected EnumStringType(SqlType sqlType, Class<?>[] classes) {
        super(sqlType, classes);
    }

    @Override
    public Object resultToSqlArg(FieldType fieldType, DatabaseResults results, int columnPos) throws SQLException {
        return results.getString(columnPos);
    }

    @Override
    public Object sqlArgToJava(FieldType fieldType, Object sqlArg, int columnPos) throws SQLException {
        if (fieldType == null) {
            return sqlArg;
        }
        String value = (String)sqlArg;
        Map enumStringMap = (Map)fieldType.getDataTypeConfigObj();
        if (enumStringMap == null) {
            return EnumStringType.enumVal(fieldType, value, null, fieldType.getUnknownEnumVal());
        }
        return EnumStringType.enumVal(fieldType, value, (Enum)enumStringMap.get(value), fieldType.getUnknownEnumVal());
    }

    @Override
    public Object parseDefaultString(FieldType fieldType, String defaultStr) {
        return defaultStr;
    }

    @Override
    public Object javaToSqlArg(FieldType fieldType, Object obj) {
        Enum enumVal = (Enum)obj;
        return enumVal.name();
    }

    @Override
    public Object makeConfigObject(FieldType fieldType) throws SQLException {
        HashMap<String, Enum> enumStringMap = new HashMap<String, Enum>();
        Enum[] constants = (Enum[])fieldType.getType().getEnumConstants();
        if (constants == null) {
            throw new SQLException("Field " + fieldType + " improperly configured as type " + this);
        }
        for (Enum enumVal : constants) {
            enumStringMap.put(enumVal.name(), enumVal);
        }
        return enumStringMap;
    }

    @Override
    public int getDefaultWidth() {
        return DEFAULT_WIDTH;
    }

    @Override
    public Object resultStringToJava(FieldType fieldType, String stringValue, int columnPos) throws SQLException {
        return this.sqlArgToJava(fieldType, stringValue, columnPos);
    }
}

