/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.fastagi;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.asteriskjava.fastagi.AgiRequest;
import org.asteriskjava.fastagi.AgiScript;
import org.asteriskjava.fastagi.MappingStrategy;

public class CompositeMappingStrategy
implements MappingStrategy {
    private List<MappingStrategy> strategies;

    public CompositeMappingStrategy() {
    }

    public CompositeMappingStrategy(MappingStrategy ... strategies) {
        this.strategies = new ArrayList<MappingStrategy>();
        for (MappingStrategy strategy : strategies) {
            this.strategies.add(strategy);
        }
    }

    public CompositeMappingStrategy(List<MappingStrategy> strategies) {
        this.strategies = new ArrayList<MappingStrategy>(strategies);
    }

    public void addStrategy(MappingStrategy strategy) {
        if (this.strategies == null) {
            this.strategies = new ArrayList<MappingStrategy>();
        }
        this.strategies.add(strategy);
    }

    public void setStrategies(List<MappingStrategy> strategies) {
        this.strategies = new ArrayList<MappingStrategy>(strategies);
    }

    @Override
    public AgiScript determineScript(AgiRequest request) {
        MappingStrategy strategy;
        AgiScript script = null;
        if (this.strategies == null) {
            return null;
        }
        Iterator<MappingStrategy> i$ = this.strategies.iterator();
        while (i$.hasNext() && (script = (strategy = i$.next()).determineScript(request)) == null) {
        }
        return script;
    }
}

