/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.manager.internal;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.asteriskjava.manager.event.AgentCallbackLoginEvent;
import org.asteriskjava.manager.event.AgentCallbackLogoffEvent;
import org.asteriskjava.manager.event.AgentCalledEvent;
import org.asteriskjava.manager.event.AgentCompleteEvent;
import org.asteriskjava.manager.event.AgentConnectEvent;
import org.asteriskjava.manager.event.AgentDumpEvent;
import org.asteriskjava.manager.event.AgentLoginEvent;
import org.asteriskjava.manager.event.AgentLogoffEvent;
import org.asteriskjava.manager.event.AgentsCompleteEvent;
import org.asteriskjava.manager.event.AgentsEvent;
import org.asteriskjava.manager.event.AlarmClearEvent;
import org.asteriskjava.manager.event.AlarmEvent;
import org.asteriskjava.manager.event.BridgeEvent;
import org.asteriskjava.manager.event.CdrEvent;
import org.asteriskjava.manager.event.ChannelReloadEvent;
import org.asteriskjava.manager.event.DbGetResponseEvent;
import org.asteriskjava.manager.event.DialEvent;
import org.asteriskjava.manager.event.DndStateEvent;
import org.asteriskjava.manager.event.ExtensionStatusEvent;
import org.asteriskjava.manager.event.FaxReceivedEvent;
import org.asteriskjava.manager.event.HangupEvent;
import org.asteriskjava.manager.event.HoldEvent;
import org.asteriskjava.manager.event.HoldedCallEvent;
import org.asteriskjava.manager.event.JoinEvent;
import org.asteriskjava.manager.event.LeaveEvent;
import org.asteriskjava.manager.event.LinkEvent;
import org.asteriskjava.manager.event.LogChannelEvent;
import org.asteriskjava.manager.event.ManagerEvent;
import org.asteriskjava.manager.event.MeetMeJoinEvent;
import org.asteriskjava.manager.event.MeetMeLeaveEvent;
import org.asteriskjava.manager.event.MeetMeMuteEvent;
import org.asteriskjava.manager.event.MeetMeStopTalkingEvent;
import org.asteriskjava.manager.event.MeetMeTalkingEvent;
import org.asteriskjava.manager.event.MessageWaitingEvent;
import org.asteriskjava.manager.event.NewCallerIdEvent;
import org.asteriskjava.manager.event.NewChannelEvent;
import org.asteriskjava.manager.event.NewExtenEvent;
import org.asteriskjava.manager.event.NewStateEvent;
import org.asteriskjava.manager.event.OriginateFailureEvent;
import org.asteriskjava.manager.event.OriginateResponseEvent;
import org.asteriskjava.manager.event.OriginateSuccessEvent;
import org.asteriskjava.manager.event.ParkedCallEvent;
import org.asteriskjava.manager.event.ParkedCallGiveUpEvent;
import org.asteriskjava.manager.event.ParkedCallTimeOutEvent;
import org.asteriskjava.manager.event.ParkedCallsCompleteEvent;
import org.asteriskjava.manager.event.PeerEntryEvent;
import org.asteriskjava.manager.event.PeerStatusEvent;
import org.asteriskjava.manager.event.PeerlistCompleteEvent;
import org.asteriskjava.manager.event.QueueCallerAbandonEvent;
import org.asteriskjava.manager.event.QueueEntryEvent;
import org.asteriskjava.manager.event.QueueMemberAddedEvent;
import org.asteriskjava.manager.event.QueueMemberEvent;
import org.asteriskjava.manager.event.QueueMemberPausedEvent;
import org.asteriskjava.manager.event.QueueMemberRemovedEvent;
import org.asteriskjava.manager.event.QueueMemberStatusEvent;
import org.asteriskjava.manager.event.QueueParamsEvent;
import org.asteriskjava.manager.event.QueueStatusCompleteEvent;
import org.asteriskjava.manager.event.QueueSummaryCompleteEvent;
import org.asteriskjava.manager.event.QueueSummaryEvent;
import org.asteriskjava.manager.event.RegistryEvent;
import org.asteriskjava.manager.event.ReloadEvent;
import org.asteriskjava.manager.event.RenameEvent;
import org.asteriskjava.manager.event.ResponseEvent;
import org.asteriskjava.manager.event.ShutdownEvent;
import org.asteriskjava.manager.event.StatusCompleteEvent;
import org.asteriskjava.manager.event.StatusEvent;
import org.asteriskjava.manager.event.UnholdEvent;
import org.asteriskjava.manager.event.UnlinkEvent;
import org.asteriskjava.manager.event.UnparkedCallEvent;
import org.asteriskjava.manager.event.UserEvent;
import org.asteriskjava.manager.event.ZapShowChannelsCompleteEvent;
import org.asteriskjava.manager.event.ZapShowChannelsEvent;
import org.asteriskjava.manager.internal.EventBuilder;
import org.asteriskjava.manager.internal.ManagerUtil;
import org.asteriskjava.util.AstUtil;
import org.asteriskjava.util.Log;
import org.asteriskjava.util.LogFactory;
import org.asteriskjava.util.ReflectionUtil;

class EventBuilderImpl
implements EventBuilder {
    private final Log logger = LogFactory.getLog(this.getClass());
    private Map<String, Class> registeredEventClasses = new HashMap<String, Class>();

    EventBuilderImpl() {
        this.registerBuiltinEventClasses();
    }

    private void registerBuiltinEventClasses() {
        this.registerEventClass(AgentCallbackLoginEvent.class);
        this.registerEventClass(AgentCallbackLogoffEvent.class);
        this.registerEventClass(AgentCalledEvent.class);
        this.registerEventClass(AgentConnectEvent.class);
        this.registerEventClass(AgentCompleteEvent.class);
        this.registerEventClass(AgentDumpEvent.class);
        this.registerEventClass(AgentLoginEvent.class);
        this.registerEventClass(AgentLogoffEvent.class);
        this.registerEventClass(AgentsEvent.class);
        this.registerEventClass(AgentsCompleteEvent.class);
        this.registerEventClass(AlarmEvent.class);
        this.registerEventClass(AlarmClearEvent.class);
        this.registerEventClass(CdrEvent.class);
        this.registerEventClass(ChannelReloadEvent.class);
        this.registerEventClass(DbGetResponseEvent.class);
        this.registerEventClass(DialEvent.class);
        this.registerEventClass(DndStateEvent.class);
        this.registerEventClass(ExtensionStatusEvent.class);
        this.registerEventClass(FaxReceivedEvent.class);
        this.registerEventClass(HangupEvent.class);
        this.registerEventClass(HoldedCallEvent.class);
        this.registerEventClass(HoldEvent.class);
        this.registerEventClass(JoinEvent.class);
        this.registerEventClass(LeaveEvent.class);
        this.registerEventClass(LinkEvent.class);
        this.registerEventClass(LogChannelEvent.class);
        this.registerEventClass(MeetMeJoinEvent.class);
        this.registerEventClass(MeetMeLeaveEvent.class);
        this.registerEventClass(MeetMeMuteEvent.class);
        this.registerEventClass(MeetMeTalkingEvent.class);
        this.registerEventClass(MeetMeStopTalkingEvent.class);
        this.registerEventClass(MessageWaitingEvent.class);
        this.registerEventClass(NewCallerIdEvent.class);
        this.registerEventClass(NewChannelEvent.class);
        this.registerEventClass(NewExtenEvent.class);
        this.registerEventClass(NewStateEvent.class);
        this.registerEventClass(OriginateFailureEvent.class);
        this.registerEventClass(OriginateSuccessEvent.class);
        this.registerEventClass(OriginateResponseEvent.class);
        this.registerEventClass(ParkedCallGiveUpEvent.class);
        this.registerEventClass(ParkedCallEvent.class);
        this.registerEventClass(ParkedCallTimeOutEvent.class);
        this.registerEventClass(ParkedCallsCompleteEvent.class);
        this.registerEventClass(PeerEntryEvent.class);
        this.registerEventClass(PeerlistCompleteEvent.class);
        this.registerEventClass(PeerStatusEvent.class);
        this.registerEventClass(QueueCallerAbandonEvent.class);
        this.registerEventClass(QueueEntryEvent.class);
        this.registerEventClass(QueueMemberAddedEvent.class);
        this.registerEventClass(QueueMemberEvent.class);
        this.registerEventClass(QueueMemberPausedEvent.class);
        this.registerEventClass(QueueMemberRemovedEvent.class);
        this.registerEventClass(QueueMemberStatusEvent.class);
        this.registerEventClass(QueueParamsEvent.class);
        this.registerEventClass(QueueStatusCompleteEvent.class);
        this.registerEventClass(QueueSummaryCompleteEvent.class);
        this.registerEventClass(QueueSummaryEvent.class);
        this.registerEventClass(RegistryEvent.class);
        this.registerEventClass(ReloadEvent.class);
        this.registerEventClass(RenameEvent.class);
        this.registerEventClass(ShutdownEvent.class);
        this.registerEventClass(StatusEvent.class);
        this.registerEventClass(StatusCompleteEvent.class);
        this.registerEventClass(UnholdEvent.class);
        this.registerEventClass(UnlinkEvent.class);
        this.registerEventClass(UnparkedCallEvent.class);
        this.registerEventClass(ZapShowChannelsEvent.class);
        this.registerEventClass(ZapShowChannelsCompleteEvent.class);
        this.registerEventClass(BridgeEvent.class);
    }

    @Override
    public final void registerEventClass(Class clazz) throws IllegalArgumentException {
        String className = clazz.getName();
        String eventType = className.substring(className.lastIndexOf(46) + 1).toLowerCase(Locale.ENGLISH);
        if (eventType.endsWith("event")) {
            eventType = eventType.substring(0, eventType.length() - "event".length());
        }
        if (UserEvent.class.isAssignableFrom(clazz) && !eventType.startsWith("userevent")) {
            eventType = "userevent" + eventType;
        }
        this.registerEventClass(eventType, clazz);
    }

    public final void registerEventClass(String eventType, Class clazz) throws IllegalArgumentException {
        Constructor defaultConstructor;
        if (!ManagerEvent.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException(clazz + " is not a ManagerEvent");
        }
        if ((clazz.getModifiers() & 0x400) != 0) {
            throw new IllegalArgumentException(clazz + " is abstract");
        }
        try {
            defaultConstructor = clazz.getConstructor(Object.class);
        }
        catch (NoSuchMethodException ex) {
            throw new IllegalArgumentException(clazz + " has no usable constructor");
        }
        if ((defaultConstructor.getModifiers() & 1) == 0) {
            throw new IllegalArgumentException(clazz + " has no public default constructor");
        }
        this.registeredEventClasses.put(eventType.toLowerCase(), clazz);
        this.logger.debug("Registered event type '" + eventType + "' (" + clazz + ")");
    }

    @Override
    public ManagerEvent buildEvent(Object source, Map<String, String> attributes) {
        ResponseEvent responseEvent;
        String actionId;
        ManagerEvent event;
        Constructor constructor;
        Class eventClass;
        if (attributes.get("event") == null) {
            this.logger.error("No event event type in properties");
            return null;
        }
        String eventType = attributes.get("event").toLowerCase();
        if ("userevent".equals(eventType)) {
            if (attributes.get("userevent") == null) {
                this.logger.error("No user event type in properties");
                return null;
            }
            String userEventType = attributes.get("userevent").toLowerCase();
            eventType = eventType + userEventType;
        }
        if ((eventClass = this.registeredEventClasses.get(eventType)) == null) {
            this.logger.info("No event class registered for event type '" + eventType + "', attributes: " + attributes);
            return null;
        }
        try {
            constructor = eventClass.getConstructor(Object.class);
        }
        catch (NoSuchMethodException ex) {
            this.logger.error("Unable to get constructor of " + eventClass.getName(), ex);
            return null;
        }
        try {
            event = (ManagerEvent)constructor.newInstance(source);
        }
        catch (Exception ex) {
            this.logger.error("Unable to create new instance of " + eventClass.getName(), ex);
            return null;
        }
        this.setAttributes(event, attributes);
        if (event instanceof ResponseEvent && (actionId = (responseEvent = (ResponseEvent)event).getActionId()) != null) {
            responseEvent.setActionId(ManagerUtil.stripInternalActionId(actionId));
            responseEvent.setInternalActionId(ManagerUtil.getInternalActionId(actionId));
        }
        return event;
    }

    private void setAttributes(ManagerEvent event, Map<String, String> attributes) {
        Map<String, Method> setters = ReflectionUtil.getSetters(event.getClass());
        for (String name : attributes.keySet()) {
            Object value;
            if ("event".equals(name)) continue;
            Method setter = "source".equals(name) ? setters.get("src") : setters.get(this.stripIllegalCharacters(name));
            if (setter == null && !(event instanceof UserEvent)) {
                this.logger.error("Unable to set property '" + name + "' to '" + attributes.get(name) + "' on " + event.getClass().getName() + ": no setter");
            }
            if (setter == null) continue;
            Class<String> dataType = setter.getParameterTypes()[0];
            if (dataType == Boolean.class) {
                value = AstUtil.isTrue(attributes.get(name));
            } else if (dataType.isAssignableFrom(String.class)) {
                value = attributes.get(name);
            } else {
                try {
                    Constructor<?> constructor = dataType.getConstructor(String.class);
                    value = constructor.newInstance(attributes.get(name));
                }
                catch (Exception e) {
                    this.logger.error("Unable to convert value '" + attributes.get(name) + "' of property '" + name + "' on " + event.getClass().getName() + " to required type " + dataType, e);
                    continue;
                }
            }
            try {
                setter.invoke((Object)event, value);
            }
            catch (Exception e) {
                this.logger.error("Unable to set property '" + name + "' to '" + attributes.get(name) + "' on " + event.getClass().getName(), e);
            }
        }
    }

    private String stripIllegalCharacters(String s) {
        char c;
        int i;
        boolean needsStrip = false;
        if (s == null) {
            return null;
        }
        for (i = 0; i < s.length(); ++i) {
            c = s.charAt(i);
            if (c >= '0' && c <= '9' || c >= 'a' && c <= 'z') continue;
            needsStrip = true;
            break;
        }
        if (!needsStrip) {
            return s;
        }
        StringBuffer sb = new StringBuffer(s.length());
        for (i = 0; i < s.length(); ++i) {
            c = s.charAt(i);
            if (c >= '0' && c <= '9') {
                sb.append(c);
                continue;
            }
            if (c < 'a' || c > 'z') continue;
            sb.append(c);
        }
        return sb.toString();
    }
}

