/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.base;

import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import org.tigris.gef.util.Localizer;
import org.tigris.gef.util.ResourceLoader;

public abstract class Cmd
extends AbstractAction
implements Serializable {
    protected Hashtable _args;
    protected String _resource;
    private static Vector _registeredCmds = new Vector();

    public Cmd(Hashtable args, String resource, String name) {
        super(Localizer.localize(resource, name));
        ImageIcon icon = ResourceLoader.lookupIconResource(name, name);
        if (icon != null) {
            this.putValue("SmallIcon", icon);
        }
        this._args = args;
        this._resource = resource;
    }

    public Cmd(String resource, String name) {
        this(null, resource, name);
    }

    public Cmd(Hashtable args, String resource, String name, ImageIcon icon) {
        super(Localizer.localize(resource, name), icon);
        this._args = args;
        this._resource = resource;
    }

    protected Cmd(String name) {
        this(null, "GefBase", name);
    }

    protected Cmd(Hashtable args, String name, ImageIcon icon) {
        this(args, "GefBase", name, icon);
    }

    protected Cmd(Hashtable args, String name) {
        this(args, "GefBase", name);
    }

    public void updateEnabled() {
        this.setEnabled(this.shouldBeEnabled());
    }

    public boolean shouldBeEnabled() {
        return true;
    }

    public void setResource(String resource) {
        this._resource = resource;
    }

    public String getResource() {
        return this._resource;
    }

    public String getName() {
        return (String)this.getValue("Name");
    }

    public void setName(String n) {
        this.putValue("Name", Localizer.localize(this._resource, n));
    }

    protected Object getArg(String key) {
        if (this._args == null) {
            return null;
        }
        return this._args.get(key);
    }

    protected Object getArg(String key, Object defaultValue) {
        if (this._args == null) {
            return defaultValue;
        }
        Object res = this._args.get(key);
        if (res == null) {
            return defaultValue;
        }
        return res;
    }

    protected void setArg(String key, Object value) {
        if (this._args == null) {
            this._args = new Hashtable();
        }
        this._args.put(key, value);
    }

    protected boolean containsArg(String key) {
        return this._args != null && this._args.containsKey(key);
    }

    public String about() {
        return "http://gef.tigris.org" + this.getClass().getName();
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        this.doIt();
    }

    public abstract void doIt();

    public abstract void undoIt();

    public static Enumeration registeredCmds() {
        return _registeredCmds.elements();
    }

    public static void register(Cmd c) {
        _registeredCmds.addElement(c);
    }

    public static Cmd cmdAtIndex(int i) {
        return (Cmd)_registeredCmds.elementAt(i);
    }
}

