/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.base;

import java.awt.Rectangle;
import java.util.Vector;
import org.tigris.gef.base.Cmd;
import org.tigris.gef.base.Editor;
import org.tigris.gef.base.Globals;
import org.tigris.gef.base.SelectionManager;
import org.tigris.gef.presentation.Fig;

public class CmdDistribute
extends Cmd {
    private static final long serialVersionUID = 196913544124639762L;
    public static final int H_SPACING = 0;
    public static final int H_CENTERS = 1;
    public static final int H_PACK = 2;
    public static final int V_SPACING = 4;
    public static final int V_CENTERS = 5;
    public static final int V_PACK = 6;
    protected int _request;
    protected Rectangle _bbox = null;

    public CmdDistribute(int r) {
        super("Distribute" + CmdDistribute.wordFor(r));
        this._request = r;
    }

    protected static String wordFor(int r) {
        switch (r) {
            case 0: {
                return "HorizontalSpacing";
            }
            case 1: {
                return "HorizontalCenters";
            }
            case 2: {
                return "Leftward";
            }
            case 4: {
                return "VerticalSpacing";
            }
            case 5: {
                return "VerticalCenters";
            }
            case 6: {
                return "Upward";
            }
        }
        return "";
    }

    @Override
    public void doIt() {
        int i;
        Editor ce = Globals.curEditor();
        Vector figs = (Vector)this.getArg("figs");
        Integer packGapInt = (Integer)this.getArg("gap");
        int packGap = 8;
        if (packGapInt != null) {
            packGap = packGapInt;
        }
        this._bbox = (Rectangle)this.getArg("bbox");
        if (figs == null) {
            SelectionManager sm = ce.getSelectionManager();
            if (sm.getLocked()) {
                Globals.showStatus("Cannot Modify Locked Objects");
                return;
            }
            figs = sm.getFigs();
        }
        int leftMostCenter = 0;
        int rightMostCenter = 0;
        int topMostCenter = 0;
        int bottomMostCenter = 0;
        int size = figs.size();
        if (size == 0) {
            return;
        }
        Fig f = (Fig)figs.elementAt(0);
        if (this._bbox == null) {
            this._bbox = f.getBounds();
            leftMostCenter = this._bbox.x + this._bbox.width / 2;
            rightMostCenter = this._bbox.x + this._bbox.width / 2;
            topMostCenter = this._bbox.y + this._bbox.height / 2;
            bottomMostCenter = this._bbox.y + this._bbox.height / 2;
            for (int i2 = 1; i2 < size; ++i2) {
                f = (Fig)figs.elementAt(i2);
                Rectangle r = f.getBounds();
                this._bbox.add(r);
                leftMostCenter = Math.min(leftMostCenter, r.x + r.width / 2);
                rightMostCenter = Math.max(rightMostCenter, r.x + r.width / 2);
                topMostCenter = Math.min(topMostCenter, r.y + r.height / 2);
                bottomMostCenter = Math.max(bottomMostCenter, r.y + r.height / 2);
            }
        }
        int totalWidth = 0;
        int totalHeight = 0;
        for (int i3 = 0; i3 < size; ++i3) {
            f = (Fig)figs.elementAt(i3);
            totalWidth += f.getWidth();
            totalHeight += f.getHeight();
        }
        float gap = 0.0f;
        float oncenter = 0.0f;
        float xNext = 0.0f;
        float yNext = 0.0f;
        switch (this._request) {
            case 0: {
                xNext = this._bbox.x;
                gap = (this._bbox.width - totalWidth) / Math.max(size - 1, 1);
                break;
            }
            case 1: {
                xNext = leftMostCenter;
                oncenter = (rightMostCenter - leftMostCenter) / Math.max(size - 1, 1);
                break;
            }
            case 2: {
                xNext = this._bbox.x;
                gap = packGap;
                break;
            }
            case 4: {
                yNext = this._bbox.y;
                gap = (this._bbox.height - totalHeight) / Math.max(size - 1, 1);
                break;
            }
            case 5: {
                yNext = topMostCenter;
                oncenter = (bottomMostCenter - topMostCenter) / Math.max(size - 1, 1);
                break;
            }
            case 6: {
                yNext = this._bbox.y;
                gap = packGap;
            }
        }
        for (i = 0; i < size; ++i) {
            for (int j = i + 1; j < size; ++j) {
                Fig fi = (Fig)figs.elementAt(i);
                Fig fj = (Fig)figs.elementAt(j);
                if (this._request == 0 || this._request == 1 || this._request == 2) {
                    if (fi.getX() <= fj.getX()) continue;
                    this.swap(figs, i, j);
                    continue;
                }
                if (fi.getY() <= fj.getY()) continue;
                this.swap(figs, i, j);
            }
        }
        for (i = 0; i < size; ++i) {
            f = (Fig)figs.elementAt(i);
            switch (this._request) {
                case 0: 
                case 2: {
                    f.setLocation((int)xNext, f.getY());
                    xNext += (float)f.getWidth() + gap;
                    break;
                }
                case 1: {
                    f.setLocation((int)xNext - f.getWidth() / 2, f.getY());
                    xNext += oncenter;
                    break;
                }
                case 4: 
                case 6: {
                    f.setLocation(f.getX(), (int)yNext);
                    yNext += (float)f.getHeight() + gap;
                    break;
                }
                case 5: {
                    f.setLocation(f.getX(), (int)yNext - f.getHeight() / 2);
                    yNext += oncenter;
                }
            }
            f.endTrans();
        }
    }

    @Override
    public void undoIt() {
    }

    protected void swap(Vector v, int i, int j) {
        Object temp = v.elementAt(i);
        v.setElementAt(v.elementAt(j), i);
        v.setElementAt(temp, j);
    }

    public Rectangle getLastBBox() {
        return this._bbox;
    }
}

