/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.base;

import java.awt.Dimension;
import java.awt.FileDialog;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Iterator;
import java.util.List;
import org.tigris.gef.base.Cmd;
import org.tigris.gef.base.Editor;
import org.tigris.gef.base.Globals;
import org.tigris.gef.base.Layer;
import org.tigris.gef.graph.presentation.JGraphFrame;
import org.tigris.gef.presentation.Fig;

public class CmdOpen
extends Cmd
implements FilenameFilter {
    private static final long serialVersionUID = 5761727153340445060L;

    public CmdOpen() {
        super("Open");
    }

    public CmdOpen(String filterPattern) {
        this();
        this.setArg("filterPattern", filterPattern);
    }

    @Override
    public void doIt() {
        try {
            Editor ce = Globals.curEditor();
            FileDialog fd = new FileDialog(ce.findFrame(), "Open...", 0);
            fd.setFilenameFilter(this);
            fd.setDirectory(Globals.getLastDirectory());
            fd.setVisible(true);
            String filename = fd.getFile();
            String path = fd.getDirectory();
            Globals.setLastDirectory(path);
            if (filename != null) {
                Globals.showStatus("Reading " + path + filename + "...");
                FileInputStream fis = new FileInputStream(path + filename);
                ObjectInputStream s = new ObjectInputStream(fis);
                List figs = (List)s.readObject();
                if (fis != null) {
                    fis.close();
                }
                Globals.showStatus("Read " + path + filename);
                JGraphFrame jgf = new JGraphFrame(path + filename);
                Layer lay = Globals.curEditor().getLayerManager().getActiveLayer();
                Iterator it = figs.iterator();
                while (it.hasNext()) {
                    lay.add((Fig)it.next());
                }
                Object d = this.getArg("dimension");
                if (d instanceof Dimension) {
                    jgf.setSize((Dimension)d);
                }
                jgf.setVisible(true);
            }
        }
        catch (FileNotFoundException ignore) {
            System.out.println("got an FileNotFoundException");
        }
        catch (ClassNotFoundException ignore) {
            System.out.println("got an ClassNotFoundException");
        }
        catch (IOException ignore) {
            System.out.println("got an IOException");
        }
    }

    @Override
    public boolean accept(File dir, String name) {
        if (this.containsArg("filterPattern")) {
            return true;
        }
        return true;
    }

    @Override
    public void undoIt() {
        System.out.println("Undo does not make sense for CmdOpen");
    }
}

