/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.base;

import java.awt.FileDialog;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.ObjectOutputStream;
import org.tigris.gef.base.Cmd;
import org.tigris.gef.base.Editor;
import org.tigris.gef.base.Globals;

public class CmdSave
extends Cmd
implements FilenameFilter {
    private static final long serialVersionUID = -548213442545482573L;

    public CmdSave() {
        super("Save");
    }

    public CmdSave(String filterPattern) {
        this();
        this.setArg("filterPattern", filterPattern);
    }

    @Override
    public void doIt() {
        try {
            Editor ce = Globals.curEditor();
            FileDialog fd = new FileDialog(ce.findFrame(), "Save Diagram", 1);
            fd.setFilenameFilter(this);
            fd.setDirectory(Globals.getLastDirectory());
            fd.setVisible(true);
            String filename = fd.getFile();
            String path = fd.getDirectory();
            Globals.setLastDirectory(path);
            if (filename != null) {
                Globals.showStatus("Writing " + path + filename + "...");
                FileOutputStream f = new FileOutputStream(path + filename);
                ObjectOutputStream s = new ObjectOutputStream(f);
                ce.preSave();
                s.writeObject(ce.getLayerManager().getContents());
                ce.postSave();
                Globals.showStatus("Wrote " + path + filename);
                f.close();
            }
        }
        catch (FileNotFoundException ignore) {
            System.out.println("got an FileNotFoundException");
        }
        catch (IOException ignore) {
            System.out.println("got an IOException");
            ignore.printStackTrace();
        }
    }

    @Override
    public boolean accept(File dir, String name) {
        if (this.containsArg("filterPattern")) {
            return true;
        }
        return true;
    }

    @Override
    public void undoIt() {
        System.out.println("Undo does not make sense for CmdSave");
    }
}

